/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.cons.FillConstant;
import com.ejianc.business.jlprogress.progress.enums.DefDocIdEnum;
import com.ejianc.business.jlprogress.progress.handler.DurationUtil;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.mapper.DayFillDetailMapper;
import com.ejianc.business.jlprogress.progress.mapper.DayFillMapper;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.utils.OrgUtil;
import com.ejianc.business.jlprogress.progress.utils.PageUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.business.jlprogress.progress.utils.WarnFeignUtil;
import com.ejianc.business.jlprogress.progress.vo.BaseDetailVO;
import com.ejianc.business.jlprogress.progress.vo.DayFillDetailVO;
import com.ejianc.business.jlprogress.progress.vo.DayFillVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dayFillService")
public class DayFillServiceImpl
extends BaseServiceImpl<DayFillMapper, DayFillEntity>
implements IDayFillService {
    private static final String BILL_CODE = "ZJKJ_DAY_FILL";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DayFillMapper dayFillMapper;
    @Autowired
    private DayFillDetailMapper dayFillDetailMapper;
    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    private static final List<Long> diffTypes = new ArrayList<Long>(Arrays.asList(1607284873290158082L, 1607284911340883970L, 1607285065540276225L, 1607285101045059585L, 1607285151582228482L, 1607285189104472066L, 1607285573499850754L));

    @Override
    public CommonResponse<DayFillVO> saveOrUpdate(DayFillVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId(), saveOrUpdateVO.getFillUserId());
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)saveOrUpdateVO.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && saveOrUpdateVO.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        List tasks = saveOrUpdateVO.getTasks();
        ArrayList<DayFillDetailVO> detailList = new ArrayList<DayFillDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            HashMap<String, Long> pkMap = new HashMap<String, Long>();
            TreeHelper2.tree2List(pkMap, detailList, tasks, saveOrUpdateVO.getImportFlag());
            this.resetOldPreLink(detailList, pkMap);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        DayFillEntity progressEntity = null;
        saveOrUpdateVO.setFinishFlag(Integer.valueOf(DateUtil.getBetweenDays(saveOrUpdateVO.getFillDate(), new Date()) + 1));
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            saveOrUpdateVO.setUpdateUserId(this.sessionManager.getUserContext().getUserId());
            saveOrUpdateVO.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            saveOrUpdateVO.setUpdateDate(new Date());
            progressEntity = (DayFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DayFillEntity.class));
            this.dayFillMapper.updateById((Object)progressEntity);
            if (detailList.size() > 0) {
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailService.deleteByProgressId(progressEntity.getId());
                }
                ArrayList<DayFillDetailEntity> saveList = new ArrayList<DayFillDetailEntity>();
                ArrayList updateList = new ArrayList();
                for (DayFillDetailVO progressDetailVo : detailList) {
                    DayFillDetailEntity progressDetailEntity;
                    progressDetailVo.setPredictStart(DateUtil.setHours(progressDetailVo.getPredictStart(), 8));
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                        progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                        progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                        progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                        progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                        progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                        saveList.add(progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                    progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                    progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                    progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                    progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                    progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                    updateList.add(progressDetailEntity);
                }
                if (saveList.size() > 0) {
                    this.detailService.saveBatch(saveList);
                }
                if (updateList.size() > 0) {
                    this.detailService.updateBatchById(updateList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (DayFillDetailVO progressDetailVo : delDetailList) {
                    this.dayFillDetailMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            progressEntity = (DayFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DayFillEntity.class));
            progressEntity.setId(masterPkId);
            this.dayFillMapper.insert((Object)progressEntity);
            if (detailList.size() > 0) {
                ArrayList<DayFillDetailEntity> saveList = new ArrayList<DayFillDetailEntity>();
                for (DayFillDetailVO progressDetailVo : detailList) {
                    DayFillDetailEntity progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                    progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                    progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                    progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                    progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                    progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                    saveList.add(progressDetailEntity);
                }
                this.detailService.saveBatch(saveList);
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    private void validateDetailList(DayFillVO saveOrUpdateVO, List<DayFillDetailVO> detailList) {
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> actualList = new ArrayList<String>();
        ArrayList<String> percentList = new ArrayList<String>();
        Date fillDate = saveOrUpdateVO.getFillDate();
        JSONObject calender = DurationUtil.getCalender(saveOrUpdateVO.getCalendars(), saveOrUpdateVO.getCalendarUid());
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (DayFillDetailVO vo : detailList) {
                if (vo.getShowState().booleanValue() && vo.getLeafFlag().booleanValue() && StringUtils.isNotEmpty((CharSequence)vo.getName())) {
                    if (vo.getActualStart() != null && (vo.getPercentComplete() == null || vo.getPercentComplete() == 0)) {
                        errorList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                    }
                    if (vo.getPercentComplete() != null && vo.getPercentComplete() == 100 && vo.getActualFinish() == null) {
                        actualList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                    }
                    if (vo.getPercentComplete() != null && vo.getPercentComplete() != 0) {
                        BigDecimal percentComplete = this.calculatePercentComplete(fillDate, vo, calender);
                        BigDecimal duration = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.toBigDecimal((Integer)DurationUtil.calculateDuration(vo.getActualStart(), fillDate, calender)), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)vo.getPlanDuration()), (BigDecimal)ComputeUtil.safeSub((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.toBigDecimal((Integer)vo.getPercentComplete()), (BigDecimal)new BigDecimal("100"))))).setScale(0, 4);
                        if (!vo.getPercentComplete().equals(percentComplete.intValue()) && !vo.getDuration().equals(duration.intValue())) {
                            percentList.add(vo.getOutlineNumber() + "[" + vo.getName() + "]");
                        }
                    }
                }
                if (vo.getActualFinish() == null || DateUtil.compareDay(vo.getActualFinish(), vo.getFinish()) == 0) continue;
                throw new BusinessException(vo.getOutlineNumber() + "[" + vo.getName() + "]\u9884\u6d4b\u5b8c\u6210\u65e5\u671f\u4e0d\u7b49\u4e8e\u5b9e\u9645\u5b8c\u6210\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
        }
        if (CollectionUtils.isNotEmpty(errorList)) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u4efb\u52a1\u5f00\u59cb\u540e\uff08\u5373[\u5b9e\u9645\u5f00\u59cb\u65e5\u671f]\u6709\u503c\uff09\uff0c[\u5b8c\u6210\u767e\u5206\u6bd4]\u5fc5\u987b\u5927\u4e8e0\uff0c\u4ee5\u4e0b\u4efb\u52a1\u4e0d\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\uff1a" + StringUtils.join(errorList, (String)","));
        }
        if (CollectionUtils.isNotEmpty(actualList)) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u4efb\u52a1\u5df2\u5b8c\u6210\uff08\u5373\u5b9e\u9645\u5f00\u59cb\u65e5\u671f]\u6709\u503c\uff0c[\u5b8c\u6210\u767e\u5206\u6bd4]\u7b49\u4e8e100\uff09\uff0c[\u5b9e\u9645\u5b8c\u6210\u65e5\u671f]\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u4ee5\u4e0b\u4efb\u52a1\u4e0d\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\uff1a" + StringUtils.join(actualList, (String)","));
        }
        if (CollectionUtils.isNotEmpty(percentList)) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u6839\u636e\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4\u8ba1\u7b97\u5b8c\u6210\u767e\u5206\u6bd4\u5e94\u8be5\u4e00\u81f4\uff0c\u4ee5\u4e0b\u4efb\u52a1\u4e0d\u6ee1\u8db3\u6821\u9a8c\u6761\u4ef6\uff1a" + StringUtils.join(percentList, (String)","));
        }
    }

    private void resetOldPreLink(List<DayFillDetailVO> detailList, Map<String, Long> pkMap) {
        int len = detailList.size();
        for (int i = 0; i < len; ++i) {
            DayFillDetailVO vo = detailList.get(i);
            if (vo.getOldPreLink() == null || vo.getOldPreLink().size() <= 0) continue;
            for (int j = 0; j < vo.getOldPreLink().size(); ++j) {
                String TaskUID;
                JSONObject predecessorLinkObj = vo.getOldPreLink().getJSONObject(j);
                String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
                if (pkMap.containsKey(PredecessorUID)) {
                    predecessorLinkObj.put("PredecessorUID", (Object)pkMap.get(PredecessorUID));
                }
                if (!pkMap.containsKey(TaskUID = predecessorLinkObj.getString("TaskUID"))) continue;
                predecessorLinkObj.put("TaskUID", (Object)pkMap.get(TaskUID));
            }
        }
    }

    private void syncDiffType(List<DayFillDetailVO> detailList, Long projectId) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        ExecPlanEntity exec = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)));
        List execDetailList = this.execPlanDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)exec.getId())).orderByAsc((Object)"tid"));
        Map<String, ExecPlanDetailEntity> codeMap = execDetailList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        Map<Long, ExecPlanDetailEntity> idMap = execDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x));
        Map<String, DayFillDetailVO> detailMap = detailList.stream().collect(Collectors.toMap(x -> x.getStructCode(), x -> x, (v1, v2) -> v2));
        for (DayFillDetailVO vo : detailList) {
            if (!vo.getShowState().booleanValue() && !vo.getLeafFlag().booleanValue()) continue;
            if (ComputeUtil.isLessOrEqual((BigDecimal)vo.getDiffValue(), (BigDecimal)BigDecimal.ZERO) || FillConstant.FINISHED.equals(vo.getFinishState())) {
                vo.setDiffType(null);
                vo.setDiffResson(null);
            }
            if (ComputeUtil.isGreaterThan((BigDecimal)vo.getDiffValue(), (BigDecimal)BigDecimal.ZERO) && !FillConstant.FINISHED.equals(vo.getFinishState()) && vo.getDiffType() == null) {
                DayFillDetailVO preVO = this.getPreVO(codeMap, idMap, detailMap, vo.getStructCode());
                if (ComputeUtil.isLessOrEqual((BigDecimal)preVO.getDiffValue(), (BigDecimal)BigDecimal.ZERO) || FillConstant.FINISHED.equals(preVO.getFinishState())) continue;
                vo.setDiffType(preVO.getDiffType());
                vo.setDiffResson(preVO.getDiffResson());
            }
            if (!ComputeUtil.isGreaterThan((BigDecimal)vo.getDiffValue(), (BigDecimal)BigDecimal.ZERO) || vo.getDiffType() != null) continue;
            throw new BusinessException(vo.getOutlineNumber() + "[" + vo.getName() + "]\u504f\u5dee\u65e5\u671f\u5927\u4e8e0\uff0c\u8bf7\u586b\u5199\u504f\u5dee\u539f\u56e0\uff01");
        }
    }

    private DayFillDetailVO getPreVO(Map<String, ExecPlanDetailEntity> codeMap, Map<Long, ExecPlanDetailEntity> idMap, Map<String, DayFillDetailVO> detailMap, String structCode) {
        if (!codeMap.containsKey(structCode)) {
            return new DayFillDetailVO();
        }
        String PredecessorLink = codeMap.get(structCode).getPredecessorLink();
        if (StringUtils.isEmpty((CharSequence)PredecessorLink)) {
            return new DayFillDetailVO();
        }
        JSONArray array = JSON.parseArray((String)PredecessorLink);
        ArrayList<ExecPlanDetailEntity> preList = new ArrayList<ExecPlanDetailEntity>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            if (!idMap.containsKey(obj.getLong("PredecessorUID"))) continue;
            preList.add(idMap.get(obj.getLong("PredecessorUID")));
        }
        for (ExecPlanDetailEntity pre : preList) {
            DayFillDetailVO preVO;
            if (!detailMap.containsKey(pre.getStructCode()) || (preVO = detailMap.get(pre.getStructCode())).getDiffType() == null) continue;
            return preVO;
        }
        return new DayFillDetailVO();
    }

    @Override
    public DayFillVO queryDetail(Long id) {
        DayFillEntity progressEntity = (DayFillEntity)((Object)((DayFillMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailService.list((Wrapper)queryWrapper);
        DayFillVO progressVo = (DayFillVO)BeanMapper.map((Object)((Object)progressEntity), DayFillVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<DayFillDetailVO> progressDetailVoList = new ArrayList<DayFillDetailVO>();
            for (DayFillDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(DayFillDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getExecPlan(DayFillVO vo) {
        List list;
        if (vo.getFillDate().getTime() > new Date().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExecPlanEntity::getProjectId, (Object)vo.getProjectId());
        ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)queryWrapper));
        if (execPlanEntity == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper1.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        queryWrapper1.notIn(DayFillEntity::getBillState, new Object[]{1, 3});
        if (vo.getId() != null) {
            queryWrapper1.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)queryWrapper1)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && vo.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)execPlanEntity.getId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetailEntities = this.execPlanDetailService.list((Wrapper)ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<Object> detailVOS = new ArrayList<ExecPlanDetailVO>();
            if (CollectionUtils.isNotEmpty((Collection)execPlanDetailEntities)) {
                List epds = BeanMapper.mapList((Iterable)execPlanDetailEntities, ExecPlanDetailEntity.class);
                ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            ArrayList<String> leafList = new ArrayList<String>();
            this.getLeaf(leafList, detailVOS);
            ArrayList<DayFillDetailVO> tasks = new ArrayList();
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = (DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)epd), DayFillDetailEntity.class));
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() : (epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish()));
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(Integer.valueOf(dvo.getActualStart() == null ? 0 : 1));
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(Boolean.valueOf(true));
                } else {
                    dvo.setLeafFlag(Boolean.valueOf(false));
                }
                dvo.setFixedDate(Integer.valueOf(0));
                if (dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)dvo.getPredecessorLink()) || dvo.getLeafFlag().booleanValue() && DateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0)) {
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
                dvo.setOldPreLink(dvo.getPredecessorLink());
                tasks.add(dvo);
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    Date date = startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                    continue;
                }
                finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
            }
            tasks = TreeHelper2.list2Tree(tasks);
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            LinkedList<DayFillDetailVO> result = DayFillServiceImpl.sort(tasks);
            this.dealPlanPreLink(result, tasks);
            resMap.put("Tasks", tasks);
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    private static LinkedList<DayFillDetailVO> sort(List<DayFillDetailVO> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new LinkedList<DayFillDetailVO>();
        }
        List<DayFillDetailVO> list = TreeHelper2.tree2List(sourceList);
        LinkedList<DayFillDetailVO> result = new LinkedList<DayFillDetailVO>();
        DayFillServiceImpl.toSort(list, result, "-1");
        return result;
    }

    private static LinkedList<DayFillDetailVO> toSort(List<DayFillDetailVO> list, LinkedList<DayFillDetailVO> result, String parentId) {
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        List temp = list.stream().filter(x -> x.getParentTaskUID().equals(parentId)).collect(Collectors.toList());
        if (temp.size() < 1) {
            return result;
        }
        list = list.stream().filter(x -> !x.getParentTaskUID().equals(parentId)).collect(Collectors.toList());
        temp = temp.stream().sorted(Comparator.comparing(BaseDetailVO::getId)).collect(Collectors.toList());
        for (DayFillDetailVO vo : temp) {
            result.add(vo);
            DayFillServiceImpl.toSort(list, result, vo.getUid());
        }
        return result;
    }

    @Override
    public Map getExecPlanMobile(DayFillVO vo) {
        List list;
        vo.setFillDate(new Date());
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExecPlanEntity::getProjectId, (Object)vo.getProjectId());
        ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)queryWrapper));
        if (execPlanEntity == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper1.notIn(DayFillEntity::getBillState, new Object[]{1, 3});
        if (vo.getId() != null) {
            queryWrapper1.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)queryWrapper1)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        if (!vo.getFillUserId().equals(303581417601122400L)) {
            queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        }
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && vo.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)execPlanEntity.getId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetailEntities = this.execPlanDetailService.list((Wrapper)ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<Object> detailVOS = new ArrayList<ExecPlanDetailVO>();
            if (CollectionUtils.isNotEmpty((Collection)execPlanDetailEntities)) {
                List epds = BeanMapper.mapList((Iterable)execPlanDetailEntities, ExecPlanDetailEntity.class);
                ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            ArrayList<String> leafList = new ArrayList<String>();
            this.getLeaf(leafList, detailVOS);
            HashMap<String, String> pmap = new HashMap<String, String>();
            this.getParentName(pmap, detailVOS, null);
            ArrayList<DayFillDetailVO> tasks = new ArrayList();
            ArrayList<Object> detailList = new ArrayList<Object>();
            List<DefdocDetailVO> defDocList = this.feignUtil.getDefDocListById(DefDocIdEnum.\u504f\u5dee\u539f\u56e0\u7c7b\u578b.getCode());
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = (DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)epd), DayFillDetailEntity.class));
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() : (epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish()));
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(Integer.valueOf(dvo.getActualStart() == null ? 0 : 1));
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(Boolean.valueOf(true));
                } else {
                    dvo.setLeafFlag(Boolean.valueOf(false));
                }
                dvo.setFixedDate(Integer.valueOf(0));
                dvo.setParentName((String)pmap.get(dvo.getStructCode()));
                dvo.setDiffTypeName(this.feignUtil.getDefDocDetail(defDocList, dvo.getDiffType()).getName());
                if (dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)dvo.getPredecessorLink()) || dvo.getLeafFlag().booleanValue() && DateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0)) {
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
                dvo.setOldPreLink(dvo.getPredecessorLink());
                dvo.setShowState(Boolean.valueOf(false));
                if (leafList.contains(epd.getStructCode()) && dvo.getActualFinish() == null && dvo.getStart().getTime() <= vo.getFillDate().getTime() && (dvo.getEmployeeId() != null && dvo.getEmployeeId().equals(vo.getFillUserId()) || vo.getFillUserId().equals(303581417601122400L))) {
                    if (dvo.getActualStart() != null) {
                        dvo.setFinishState(Integer.valueOf(1));
                    } else {
                        dvo.setFinishState(Integer.valueOf(0));
                    }
                    dvo.setShowState(Boolean.valueOf(true));
                    detailList.add(Utils.deepCopy((Object)dvo));
                }
                tasks.add((DayFillDetailVO)Utils.deepCopy((Object)dvo));
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    Date date = startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                    continue;
                }
                finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
            }
            tasks = TreeHelper2.list2Tree(tasks);
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            LinkedList<DayFillDetailVO> result = DayFillServiceImpl.sort(tasks);
            this.dealPlanPreLink(result, tasks);
            resMap.put("Tasks", tasks);
            resMap.put("progressDetailList", TreeHelper2.list2Tree(detailList));
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    @Override
    public JSONObject projectDiffTypeList(QueryParam param) {
        JSONObject page = new JSONObject();
        String text = param.getSearchText();
        int current = param.getPageIndex();
        int size = param.getPageSize();
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        param.getFuzzyFields().add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List fillList = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)fillList)) {
            page.put("records", new ArrayList());
            page.put("total", (Object)0);
            page.put("pages", (Object)0);
            return page;
        }
        List ids = fillList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("progress_id", new Parameter("in", ids));
        List detailList = this.detailService.queryList(detailParam);
        Map<Long, List<DayFillEntity>> fillMap = fillList.stream().collect(Collectors.groupingBy(DayFillEntity::getProjectId));
        Map<Long, List<DayFillDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ProgressDetailEntity::getProgressId));
        List<Long> orgIds = fillList.stream().map(DayFillEntity::getOrgId).collect(Collectors.toList());
        Map<Long, OrgVO> corpMap = this.orgUtil.findListByIds(orgIds);
        JSONArray array = new JSONArray();
        for (Long projectId : fillMap.keySet()) {
            DayFillEntity fill = fillMap.get(projectId).stream().max(Comparator.comparing(BaseEntity::getCreateTime)).get();
            JSONObject obj = new JSONObject();
            obj.put("projectId", (Object)fill.getProjectId());
            obj.put("corpName", corpMap.containsKey(fill.getOrgId()) ? corpMap.get(fill.getOrgId()).getName() : null);
            obj.put("projectName", (Object)fill.getProjectName());
            this.calculateDiffTypes(fillMap.get(projectId), detailMap, obj);
            array.add((Object)obj);
        }
        int total = array.size();
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);
        page.put("records", (Object)records);
        page.put("total", (Object)total);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public JSONArray diffTypeRate(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ExecPlanEntity::getProjectId, (Object)projectId);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)wrapper));
        JSONArray array = new JSONArray();
        if (entity == null) {
            return array;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.execPlanDetailService.list((Wrapper)ew);
        detailList = detailList.stream().filter(x -> x.getDiffType() != null).collect(Collectors.toList());
        Map<Long, List<ExecPlanDetailEntity>> diffTypeMap = detailList.stream().collect(Collectors.groupingBy(ExecPlanDetailEntity::getDiffType));
        List<DefdocDetailVO> defDocList = this.feignUtil.getDefDocListById(DefDocIdEnum.\u504f\u5dee\u539f\u56e0\u7c7b\u578b.getCode());
        for (Long diffType : diffTypeMap.keySet()) {
            JSONObject obj = new JSONObject();
            obj.put("diffType", (Object)diffType);
            obj.put("diffTypeName", (Object)this.feignUtil.getDefDocDetail(defDocList, diffType).getName());
            obj.put("num", (Object)diffTypeMap.get(diffType).size());
            obj.put("sum", (Object)detailList.size());
            obj.put("rate", (Object)ComputeUtil.bigDecimalPercent((Integer)diffTypeMap.get(diffType).size(), (Integer)detailList.size(), (int)0));
            array.add((Object)obj);
        }
        return array;
    }

    private void calculateDiffTypes(List<DayFillEntity> fillList, Map<Long, List<DayFillDetailEntity>> detailMap, JSONObject obj) {
        Integer num;
        int i;
        Integer sum = 0;
        for (i = 0; i < diffTypes.size(); ++i) {
            num = 0;
            Integer value = 0;
            Long diffType = diffTypes.get(i);
            for (DayFillEntity vo : fillList) {
                if (!detailMap.containsKey(vo.getId())) continue;
                List list = detailMap.get(vo.getId()).stream().filter(x -> x.getDiffType() != null && x.getDiffType().equals(diffType)).collect(Collectors.toList());
                num = num + list.size();
                BigDecimal diffValue = list.stream().map(DayFillDetailEntity::getDiffValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                value = value + diffValue.intValue();
            }
            sum = sum + num;
            obj.put("diffType0" + i, (Object)diffType);
            obj.put("num0" + i, (Object)num);
            obj.put("value0" + i, (Object)value);
        }
        obj.put("sum", (Object)sum);
        for (i = 0; i < diffTypes.size(); ++i) {
            num = obj.getIntValue("num0" + i);
            obj.put("rate0" + i, (Object)ComputeUtil.bigDecimalPercent((Integer)num, (Integer)sum, (int)2));
        }
    }

    @Override
    public DayFillVO resetExecPlan(Long id) {
        DayFillVO fill = this.queryDetail(id);
        List progressDetailList = TreeHelper2.tree2List(fill.getProgressDetailList());
        Map<String, DayFillDetailVO> detailMap = progressDetailList.stream().collect(Collectors.toMap(BaseDetailVO::getStructCode, x -> x));
        JSONObject calender = DurationUtil.getCalender(fill.getCalendars(), fill.getCalendarUid());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DayFillEntity::getProjectId, (Object)fill.getProjectId());
        wrapper.in(DayFillEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByDesc(DayFillEntity::getFillDate);
        List list = super.list((Wrapper)wrapper);
        Date maxDate = CollectionUtils.isEmpty((Collection)list) || fill.getFillDate().getTime() > ((DayFillEntity)((Object)list.get(0))).getFillDate().getTime() ? fill.getFillDate() : ((DayFillEntity)((Object)list.get(0))).getFillDate();
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(ExecPlanEntity::getProjectId, (Object)fill.getProjectId());
        ExecPlanEntity exec = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)ew));
        if (exec == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        fill.setImportFlag(Boolean.valueOf(true));
        fill.setFillVersion(exec.getFillVersion());
        QueryWrapper ew2 = new QueryWrapper();
        ew2.eq((Object)"progress_id", (Object)exec.getId());
        ew2.orderByAsc((Object)"tid");
        List detailList = this.execPlanDetailService.list((Wrapper)ew2);
        if (detailList.size() <= 0) {
            fill.setProgressDetailList(null);
            fill.setRemovedTasks(progressDetailList);
            return fill;
        }
        List<Object> detailVOList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            detailVOList = TreeHelper2.list2Tree(detailVOList);
        }
        ArrayList<String> leafList = new ArrayList<String>();
        this.getLeaf(leafList, detailVOList);
        ArrayList<DayFillDetailVO> tasks = new ArrayList();
        for (ExecPlanDetailEntity detail : detailList) {
            if (!detailMap.containsKey(detail.getStructCode())) continue;
            DayFillDetailVO vo = DayFillDetailEntity.convertEntityToVo((DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), DayFillDetailEntity.class)));
            vo.setStart(detail.getActualStart() != null ? detail.getActualStart() : detail.getPredictStart());
            vo.setFinish(detail.getActualFinish() != null ? detail.getActualFinish() : (detail.getEstimateFinish() != null ? detail.getEstimateFinish() : detail.getPredictFinish()));
            if (leafList.contains(detail.getStructCode())) {
                vo.setLeafFlag(Boolean.valueOf(true));
            } else {
                vo.setLeafFlag(Boolean.valueOf(false));
            }
            vo.setFixedDate(Integer.valueOf(0));
            vo.setOldPreLink(vo.getPredecessorLink());
            vo.setShowState(Boolean.valueOf(true));
            DayFillDetailVO old = detailMap.get(vo.getStructCode());
            if (vo.getLeafFlag().booleanValue() && old.getActualStart() != null && fill.getFillUserId().equals(InvocationInfoProxy.getUserid())) {
                vo.setActualStart(old.getActualStart());
                vo.setActualFinish(old.getActualFinish());
                vo.setEstimateFinish(old.getEstimateFinish());
                vo.setStart(old.getActualStart() != null ? old.getActualStart() : detail.getPredictStart());
                vo.setFinish(old.getActualFinish() != null ? old.getActualFinish() : (old.getEstimateFinish() != null ? old.getEstimateFinish() : detail.getPredictFinish()));
                vo.setPercentComplete(old.getPercentComplete());
                vo.setFinishNum(old.getFinishNum());
                vo.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(vo.getFinish(), vo.getPlanFinish())));
                vo.setDiffType(old.getDiffType());
                vo.setDiffResson(old.getDiffResson());
                vo.setResourceNum(old.getResourceNum());
                vo.setDiffNum(old.getDiffNum());
                if (vo.getActualStart() != null) {
                    vo.setPredecessorLink(null);
                }
            }
            vo.setDuration(DurationUtil.calculateDuration(vo.getStart(), vo.getFinish(), calender));
            if (vo.getLeafFlag().booleanValue() && DateUtil.compareDay(vo.getStart(), fill.getFillDate()) < 0 && vo.getActualStart() == null) {
                vo.setStart(DateUtil.setHours(fill.getFillDate(), 8));
                vo.setConstraintType(Integer.valueOf(4));
                vo.setConstraintDate(vo.getStart());
            }
            if (vo.getActualStart() == null && vo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)vo.getPredecessorLink()) || vo.getLeafFlag().booleanValue() && DateUtil.compareDate(vo.getConstraintDate(), fill.getFillDate()) < 0)) {
                vo.setConstraintDate(DateUtil.setHours(fill.getFillDate(), 8));
            }
            vo.setShowState(old.getShowState());
            vo.setPlanDuration(detail.getDuration());
            vo.setStartSourceType(Integer.valueOf(vo.getActualStart() == null ? 0 : 1));
            tasks.add(vo);
        }
        tasks = TreeHelper2.list2Tree(tasks);
        this.dealParentTask(calender, maxDate, tasks);
        LinkedList<DayFillDetailVO> result = DayFillServiceImpl.sort(tasks);
        this.dealPlanPreLink(result, tasks);
        fill.setProgressDetailList(tasks);
        return fill;
    }

    private void dealParentTask(JSONObject calender, Date maxDate, List<DayFillDetailVO> tasks) {
        for (DayFillDetailVO task : tasks) {
            if (CollectionUtils.isEmpty((Collection)task.getChildren())) continue;
            this.dealParentTask(calender, maxDate, task.getChildren());
            List childList = (List)Utils.deepCopy((Object)task.getChildren());
            Date Finish = task.getFinish();
            task.setStart((Date)childList.stream().map(BaseDetailVO::getStart).filter(Objects::nonNull).min(Comparator.comparing(x -> x)).orElse(null));
            task.setFinish((Date)childList.stream().map(BaseDetailVO::getFinish).filter(Objects::nonNull).max(Comparator.comparing(x -> x)).orElse(null));
            task.setDuration(DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender));
            task.setActualStart(task.getStart());
            if (childList.stream().filter(x -> x.getActualStart() != null).count() == 0L) {
                task.setActualStart(null);
            }
            if (task.getActualFinish() != null) {
                task.setFixedDate(Integer.valueOf(1));
            }
            Date maxPlanFinish = childList.stream().map(DayFillDetailVO::getPlanFinish).filter(Objects::nonNull).max(Comparator.comparing(x -> x)).orElse(null);
            if (!DateUtil.isSameDay(Finish, task.getFinish()) && task.getActualFinish() == null && !DateUtil.isSameDay(maxPlanFinish, task.getPlanFinish())) {
                this.addVirtualVO(task, calender);
                childList = (List)Utils.deepCopy((Object)task.getChildren());
                task.setFinish((Date)childList.stream().map(BaseDetailVO::getFinish).filter(Objects::nonNull).max(Comparator.comparing(x -> x)).orElse(null));
                task.setDuration(DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender));
            }
            if (childList.stream().filter(x -> x.getPercentComplete() != null && x.getPercentComplete() > 0).count() == 0L) {
                task.setPercentComplete(Integer.valueOf(0));
            }
            if (childList.stream().filter(x -> x.getActualFinish() == null).count() == 0L) {
                task.setActualFinish(task.getFinish());
                task.setEstimateFinish(null);
            } else {
                task.setEstimateFinish(task.getFinish());
                task.setActualFinish(null);
            }
            task.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(task.getFinish(), task.getPlanFinish())));
            BigDecimal percentComplete = this.calculatePercentComplete(maxDate, task, calender);
            task.setPercentComplete(Integer.valueOf(percentComplete.intValue()));
            BigDecimal finishNum = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)new BigDecimal(task.getPercentComplete()), (BigDecimal)new BigDecimal("100")), (BigDecimal)task.getPlanNum());
            task.setFinishNum(finishNum);
            if (task.getActualStart() != null && task.getPercentComplete() != 0) continue;
            task.setActualFinish(null);
            task.setEstimateFinish(null);
            task.setFinishNum(null);
        }
    }

    private void addVirtualVO(DayFillDetailVO task, JSONObject calender) {
        DayFillDetailVO vo = new DayFillDetailVO();
        vo.setUid(String.valueOf(IdWorker.getId()));
        vo.setParentTaskUID(task.getUid());
        vo.setStart(task.getStart());
        Date Finish = DurationUtil.calculateFinish(task.getStart(), task.getPlanDuration(), calender);
        vo.setFinish(Finish);
        vo.setDuration(task.getPlanDuration());
        vo.setActualStart(task.getActualStart());
        vo.setLeafFlag(Boolean.valueOf(true));
        vo.setFixedDate(Integer.valueOf(0));
        vo.setShowState(Boolean.valueOf(false));
        vo.setId(task.getChildren().stream().max(Comparator.comparing(BaseDetailVO::getId)).get().getId());
        DayFillDetailVO min = task.getChildren().stream().sorted(Comparator.comparing(BaseDetailVO::getStart).thenComparing(DayFillDetailVO::getPlanStart)).findFirst().orElse(null);
        if (min != null) {
            JSONArray PredecessorLink = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("LagFormat", (Object)7);
            obj.put("PredecessorUID", (Object)min.getUid());
            obj.put("Type", (Object)3);
            obj.put("TaskUID", (Object)vo.getUid());
            obj.put("LinkLag", (Object)0);
            PredecessorLink.add((Object)obj);
            vo.setPredecessorLink(PredecessorLink);
        }
        List children = task.getChildren();
        children.add(vo);
    }

    private void dealPlanPreLink(LinkedList<DayFillDetailVO> result, List<DayFillDetailVO> tasks) {
        for (DayFillDetailVO task : tasks) {
            task.setPlanPreLink(TreeUtils.getPlanPreLink(result, task.getPredecessorLink()));
            if (!CollectionUtils.isNotEmpty((Collection)task.getChildren())) continue;
            this.dealPlanPreLink(result, task.getChildren());
        }
    }

    private BigDecimal calculatePercentComplete(Date fillDate, DayFillDetailVO task, JSONObject calender) {
        if (task.getActualStart() == null) {
            return BigDecimal.ZERO;
        }
        Integer duration = DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender);
        Integer fillDuration = DurationUtil.calculateDuration(task.getStart(), fillDate, calender);
        BigDecimal percentComplete = ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Integer)100), (BigDecimal)ComputeUtil.bigDecimalPercent((BigDecimal)ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Integer)duration), (BigDecimal)ComputeUtil.toBigDecimal((Integer)fillDuration)), (BigDecimal)ComputeUtil.toBigDecimal((Integer)task.getPlanDuration()), (int)0));
        if (task.getActualStart() != null && task.getActualFinish() != null) {
            percentComplete = new BigDecimal("100");
        }
        if (task.getActualStart() == null && task.getActualFinish() == null && task.getEstimateFinish() == null) {
            percentComplete = BigDecimal.ZERO;
        }
        if (ComputeUtil.isGreaterThan((BigDecimal)percentComplete, (BigDecimal)new BigDecimal("100"))) {
            percentComplete = new BigDecimal("100");
        }
        if (ComputeUtil.isLessThan((BigDecimal)percentComplete, (BigDecimal)new BigDecimal("0"))) {
            percentComplete = new BigDecimal("0");
        }
        return percentComplete;
    }

    private void getParents(Map<Long, ExecPlanDetailEntity> res, List<ExecPlanDetailEntity> list, Long pid) {
        if (pid != -1L) {
            for (ExecPlanDetailEntity epd : list) {
                if (pid != epd.getId()) continue;
                res.put(epd.getId(), epd);
                if (epd.getParentId() == -1L) continue;
                this.getParents(res, list, epd.getParentId());
            }
        }
    }

    private void getLeaf(List<String> res, List<ExecPlanDetailVO> detailVOS) {
        for (ExecPlanDetailVO epd : detailVOS) {
            if (CollectionUtils.isNotEmpty((Collection)epd.getChildren())) {
                this.getLeaf(res, epd.getChildren());
                continue;
            }
            res.add(epd.getStructCode());
        }
    }

    private void getParentName(Map<String, String> pmap, List<ExecPlanDetailVO> detailVOS, String pname) {
        for (ExecPlanDetailVO epd : detailVOS) {
            String name = epd.getName();
            if (StringUtils.isNotBlank((CharSequence)pname)) {
                pmap.put(epd.getStructCode(), pname);
                name = pname + "/" + name;
            }
            if (!CollectionUtils.isNotEmpty((Collection)epd.getChildren())) continue;
            this.getParentName(pmap, epd.getChildren(), name);
        }
    }
}

