/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import PluSoft.Utils.Convert;
import PluSoft.Utils.StringUtil;
import com.ejianc.business.jlprogress.progress.cons.CustomizeCloumVO;
import com.ejianc.business.jlprogress.progress.cons.PlanCloumCons;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Export {
    public static void exportExtendedAttributes(HashMap project, Map<String, CustomizeCloumVO> cloumMap) {
        for (CustomizeCloumVO cloum : cloumMap.values()) {
            Export.exportExtendedAttribute(project, Long.valueOf(cloum.getFieldID()), cloum.getFieldName(), cloum.getField());
        }
    }

    public static void exportExtendedAttributes(HashMap project) {
        Export.exportExtendedAttributes(project, PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
    }

    private static void exportExtendedAttribute(HashMap project, long fieldID, String alias, String dataField) {
        ArrayList tasks = (ArrayList)project.get("Tasks");
        tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");
        ArrayList ExtendedAttributesList = (ArrayList)project.get("ExtendedAttributes");
        if (ExtendedAttributesList == null) {
            ExtendedAttributesList = new ArrayList();
            project.put("ExtendedAttributes", ExtendedAttributesList);
        }
        HashMap<String, Object> ea1 = new HashMap<String, Object>();
        ea1.put("FieldID", fieldID);
        ea1.put("FieldName", "");
        ea1.put("Alias", alias);
        ExtendedAttributesList.add(ea1);
        for (Object task_o : tasks) {
            Object value;
            HashMap task = (HashMap)task_o;
            ArrayList eas = (ArrayList)task.get("ExtendedAttribute");
            if (eas == null) {
                eas = new ArrayList();
                task.put("ExtendedAttribute", eas);
            }
            if ((value = task.get(dataField)) == null) continue;
            HashMap<String, Long> ea = new HashMap<String, Long>();
            ea.put("FieldID", fieldID);
            ea.put("Value", (Long)value);
            eas.add(ea);
        }
    }

    private static void createPrincipalName(HashMap project) {
        ArrayList tasks = (ArrayList)project.get("Tasks");
        tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");
        ArrayList principals = (ArrayList)project.get("Principals");
        for (Object task_o : tasks) {
            String[] ss;
            HashMap task = (HashMap)task_o;
            String principal = (String)task.get("Principal");
            if (StringUtil.isNullOrEmpty((Object)principal)) continue;
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : ss = principal.split(",")) {
                ids.add(id);
            }
            String name = "";
            for (Object p_o : principals) {
                HashMap p = (HashMap)p_o;
                String id = p.get("UID").toString();
                if (ids.indexOf(id) == -1) continue;
                if (!name.equals("")) {
                    name = name + ",";
                }
                name = name + p.get("Name").toString();
            }
            task.put("PrincipalName", name);
        }
    }

    public static void exportFixedDateSummarys(HashMap project) {
        ArrayList tasks = (ArrayList)project.get("Tasks");
        tasks = TreeHelper.tree2List(tasks, "-1", "children", "UID", "ParentTaskUID");
        for (Object task_o : tasks) {
            HashMap task = (HashMap)task_o;
            int FixedDate = Convert.toInt(task.get("FixedDate"));
            int Summary = Convert.toInt(task.get("Summary"));
            if (FixedDate != 1 || Summary != 1) continue;
            task.put("Manual", 1);
        }
    }
}

