package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.asset.bean.AllotDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.HandleDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.HandleEntity;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.service.IHandleDetailService;
import com.ejianc.business.jlprogress.asset.service.IHandleService;
import com.ejianc.business.jlprogress.asset.service.IRecordService;
import com.ejianc.business.jlprogress.asset.vo.AllotDetailVO;
import com.ejianc.business.jlprogress.asset.vo.HandleDetailVO;
import com.ejianc.business.jlprogress.asset.vo.HandleVO;
import com.ejianc.business.jlprogress.asset.vo.RecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IHandleService handleService;
	@Autowired
	private IHandleDetailService handleDetailService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private RecordMapper recordMapper;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//提交完成前校验
		HandleEntity entity = handleService.selectById(billId);
		HandleVO saveOrUpdateVO = BeanMapper.map(entity, HandleVO.class);
		List<Long> sourceIds = saveOrUpdateVO.getHandleDetailList().stream().map(HandleDetailVO::getSourceId).collect(Collectors.toList());
		List<RecordVO> useNumList = recordMapper.queryUseNumList(entity.getOrgId(), sourceIds, entity.getId());
		Map<String, BigDecimal> useNumMap = useNumList.stream().collect(Collectors.toMap((recordVO) -> {
			return recordVO.getOrgId().toString() + recordVO.getMaterialId().toString() + recordVO.getSourceBillId().toString();
		}, RecordVO::getUseNum));
		for (HandleDetailEntity detailEntity : entity.getHandleDetailList()) {
			String key = entity.getOrgId().toString() + detailEntity.getMaterialId().toString() + detailEntity.getSourceId();
			if (detailEntity.getMaterialNum().compareTo(useNumMap.get(key)) > 0) {
				return CommonResponse.error("物料" + detailEntity.getMaterialName() + "处置数量超出可用数量");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//根据当前单据id获取单据信息
		HandleEntity handleEntity = handleService.selectById(billId);
		//根据当前单据id获取单据明细信息
		LambdaQueryWrapper<HandleDetailEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(HandleDetailEntity::getHandleId, billId);
		List<HandleDetailEntity> handleDetailEntities = handleDetailService.list(wrapper);
		List<RecordEntity> recordEntities = new ArrayList<>();
		for (HandleDetailEntity handleDetailEntity : handleDetailEntities) {
			//向记录表写入数据
			RecordEntity recordEntity = new RecordEntity();
			recordEntity.setSourceId(billId);
			recordEntity.setSourceBillCode(handleDetailEntity.getSourceBillCode());
			recordEntity.setOrgId(handleEntity.getOrgId());
			recordEntity.setOrgName(handleEntity.getOrgName());
			recordEntity.setOrgCode(handleEntity.getOrgCode());
			recordEntity.setMaterialTypeId(handleDetailEntity.getMaterialTypeId());
			recordEntity.setMaterialTypeCode(handleDetailEntity.getMaterialTypeCode());
			recordEntity.setMaterialTypeName(handleDetailEntity.getMaterialTypeName());
			recordEntity.setMaterialId(handleDetailEntity.getMaterialId());
			recordEntity.setMaterialCode(handleDetailEntity.getMaterialCode());
			recordEntity.setMaterialName(handleDetailEntity.getMaterialName());
			recordEntity.setSpec(handleDetailEntity.getSpec());
			recordEntity.setModel(handleDetailEntity.getModel());
			recordEntity.setUnit(handleDetailEntity.getUnit());
			recordEntity.setRecordType(RecordTypeEnum.处置.getCode());
			recordEntity.setRecordDate(handleDetailEntity.getDetailHandleDate());
			recordEntity.setNum(handleDetailEntity.getHandleNum().negate());
			recordEntity.setState(1);
			recordEntity.setEmployeeId(handleEntity.getEmployeeId());
			recordEntity.setEmployeeName(handleEntity.getEmployeeName());
			recordEntity.setPrice(handleDetailEntity.getPrice());
			recordEntity.setMny(handleDetailEntity.getDetailHandleMny().negate());
			recordEntity.setSourceBillId(handleDetailEntity.getSourceId());
			recordEntities.add(recordEntity);
		}
		recordService.saveOrUpdateBatch(recordEntities);
		

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		recordService.delete(billId);
		List<Long> list = new ArrayList<>();
		list.add(billId);
		recordService.deleteBatch(list);

		return CommonResponse.success();
	}

}
