package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.AttendanceMapper;
import com.ejianc.business.jlprogress.labor.bean.AttendanceEntity;
import com.ejianc.business.jlprogress.labor.service.IAttendanceService;

import java.util.Date;

/**
 * 劳务实名制-考勤记录
 * 
 * @author generator
 * 
 */
@Service("attendanceService")
public class AttendanceServiceImpl extends BaseServiceImpl<AttendanceMapper, AttendanceEntity> implements IAttendanceService{

    @Override
    public int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId, Long projectId) {
        QueryWrapper<AttendanceEntity> queryWrapper = new QueryWrapper<>();

        queryWrapper.eq("project_id",projectId);

        queryWrapper.eq("worker_id",workerId);
//        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.between("punch_card_date",enterDate,exitDate);
        int count = super.count(queryWrapper);
        return count;
    }


    /**
     * 按个人统计分页查询
     *
     * @param p       分页
     * @param wrapper 条件构造器
     *
     * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
     */
    @Override
    public IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate) {
        return baseMapper.queryPageByPerson(p, wrapper, startDate, endDate);
    }

    @Override
    public Integer queryAttendanceOrgIds(String orgIds){
        return baseMapper.queryAttendanceOrgIds(orgIds);
    }
}
