package com.ejianc.business.jlprogress.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanCloumCons;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.CommonHelper;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanDetailMapper;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanService;
import com.ejianc.business.jlprogress.progress.utils.Export;
import com.ejianc.business.jlprogress.progress.utils.OrgUtil;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.business.jlprogress.progress.utils.PlusUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 总计划
 *
 * @author generator
 */
@Service("totalPlanService")
public class TotalPlanServiceImpl extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity> implements ITotalPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJ_TOTAL_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private TotalPlanMapper progressMapper;
    @Autowired
    private TotalPlanDetailMapper progressDetailMapper;
    @Autowired
    private ITotalPlanDetailService detailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<TotalPlanVO> saveOrUpdate(TotalPlanVO saveOrUpdateVO) {
        LambdaQueryWrapper<TotalPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalPlanEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), TotalPlanEntity::getId, saveOrUpdateVO.getId());
        List<TotalPlanEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目已存在总计划");
        }
        // 校验是否存在非生效态单据
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());

        OrgVO orgVO = orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, TotalPlanEntity.class);
            progressMapper.updateById(progressEntity);

            //子表
            List<TotalPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<TotalPlanDetailVO> saveVOList = new ArrayList<TotalPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if (saveOrUpdateVO.getImportFlag()) {
                    detailService.deleteByProgressId(progressEntity.getId());
                }
                for (TotalPlanDetailVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        TotalPlanDetailEntity progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailMapper.insert(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        TotalPlanDetailEntity progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailMapper.updateById(progressDetailEntity);
                    }
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            //子表删除
            List<TotalPlanDetailVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (TotalPlanDetailVO progressDetailVo : delDetailList) {
                    progressDetailMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            progressEntity = BeanMapper.map(saveOrUpdateVO, TotalPlanEntity.class);
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            progressMapper.insert(progressEntity);

            //子表
            List<TotalPlanDetailVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<TotalPlanDetailVO> saveVOList = new ArrayList<TotalPlanDetailVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                for (TotalPlanDetailVO progressDetailVo : saveVOList) {
                    TotalPlanDetailEntity progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    progressDetailMapper.insert(progressDetailEntity);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

        }

        // 生效后更新执行计划
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())
                || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())){
            execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.TOTAL_PLAN);
        }

        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public TotalPlanVO queryDetail(Long id) {
        TotalPlanEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<TotalPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<TotalPlanDetailEntity> progressDetailList = detailService.list(queryWrapper);

        TotalPlanVO progressVo = BeanMapper.map(progressEntity, TotalPlanVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<TotalPlanDetailVO> progressDetailVoList = new ArrayList<>();
            for (TotalPlanDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(TotalPlanDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xml".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            HashMap read = PlusUtil.read(file, PlanCloumCons.TOTAL_PLAN_CLOUM);
//            Map<String, Map> filed = new HashMap<>();
//            filed.put("taskLine", PlanConstant.TASK_LINE);
//            filed.put("nodeLevel", PlanConstant.NODE_LEVEL);
//            filed.put("unit", PlanConstant.UNIT);
//            filed.put("type", PlanConstant.RESOURCE_TYPE);
//            filed.put("typeUnit", PlanConstant.RESOURCE_UNIT);
            Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList) read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
            return CommonResponse.success("解析数据成功！", PlusUtil.readMain(read, filed));
        }
    }

    @Override
    public Map getDetail(Long id) {
        TotalPlanVO totalPlanVO = queryDetail(id);
        Map map = new HashMap();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List<TotalPlanDetailVO> detailList = totalPlanVO.getProgressDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> pkMap = new HashMap<>();
            List<TotalPlanDetailVO> saveVOList = new ArrayList<TotalPlanDetailVO>();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<Map> list = JSONObject.parseArray(jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") != null) {
                    List<Map> link = JSONObject.parseArray(JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                    m.put("PredecessorLink", link);
                }
            }
            key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = totalPlanVO.getCalendars();
        if (StringUtils.isNotBlank(calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", totalPlanVO.getPlanEndDate());
        map.put("Name", totalPlanVO.getProjectName());
        map.put("StartDate", totalPlanVO.getPlanBeginDate());
        map.put("CalendarUID", totalPlanVO.getCalendarUid());
        map.put("UID", totalPlanVO.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap) dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            key2Value(map, "unit", PlanConstant.UNIT);
            key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    @Override
    public TotalPlanVO getTotalPlanByProjectId(Long projectId){

        LambdaQueryWrapper<TotalPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalPlanEntity::getProjectId,projectId);
        TotalPlanEntity planEntity = super.getOne(queryWrapper);
        TotalPlanVO totalPlanVO = this.queryDetail(planEntity.getId());
        return totalPlanVO;

    }

}
