package com.ejianc.business.jlprogress.quality.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 质量检测-检测委托书
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_entrust_detect")
public class EntrustDetectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 委托单号
    @TableField(value="bill_state")
    private Integer billState; // 单据提交状态：0-暂存,1-提交
    @TableField(value="detection_type")
    private Integer detectionType; // 检测类型：0、原材检测；1、产品检测；2、工序检测 
    @TableField(value="entrust_type")
    private Integer entrustType; // 委托类型：0、内委；1、外委
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="depart_id")
    private Long departId; // 委托部门id
    @TableField(value="depart_name")
    private String departName; // 委托部门名称
    @TableField(value="depart_code")
    private String departCode; // 委托部门编码
    @TableField(value="entrust_date")
    private Date entrustDate; // 委托日期
    @TableField(value="sample_name")
    private String sampleName; // 样品名称
    @TableField(value="customer_id")
    private Long customerId; // 客户名称
    @TableField(value="customer_name")
    private String customerName; // 客户名称id
    @TableField(value="entrust_user_id")
    private Long entrustUserId; // 委托人id
    @TableField(value="entrust_user_name")
    private String entrustUserName; // 委托人
    @TableField(value="supply_id")
    private Long supplyId; // 供货单号
    @TableField(value="supply_name")
    private String supplyName; // 供货单号名称
    @TableField(value="plan_id")
    private Long planId; // 计划单号
    @TableField(value="plan_name")
    private String planName; // 计划单号名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="detect_mode")
    private String detectMode; // 委托方式

    @TableField(value="materials")
    private String materials; // 材料
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="detection_location")
    private String detectionLocation; // 检测地点
    @TableField(value="detection_project_id")
    private Long detectionProjectId; // 检测项目id
    @TableField(value="detection_project_name")
    private String detectionProjectName; // 检测项目名称
    @TableField(value="receiver_id")
    private Long receiverId; // 收样人id
    @TableField(value="receiver_name")
    private String receiverName; // 收样人
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="entrustDetectDetailService",pidName = "detectId")
    private List<EntrustDetectDetailEntity> detailList = new ArrayList<>(); // 质量检测-检测委托书详情

    @TableField(exist=false)
    @SubEntity(serviceName="sampleDetailService",pidName = "detectId")
    private List<SampleDetailEntity> sampleDetailList = new ArrayList<>(); // 质量检测-内部检测-样品概况-子表
    @TableField(exist=false)
    @SubEntity(serviceName="requireDetailService",pidName = "detectId")
    private List<RequireDetailEntity> requireDetailList = new ArrayList<>(); // 质量检测-内部检测-检测要求-子表

    public String getMaterials() {
        return materials;
    }

    public void setMaterials(String materials) {
        this.materials = materials;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getDetectionLocation() {
        return detectionLocation;
    }

    public void setDetectionLocation(String detectionLocation) {
        this.detectionLocation = detectionLocation;
    }

    public Long getDetectionProjectId() {
        return detectionProjectId;
    }

    public void setDetectionProjectId(Long detectionProjectId) {
        this.detectionProjectId = detectionProjectId;
    }

    public String getDetectionProjectName() {
        return detectionProjectName;
    }

    public void setDetectionProjectName(String detectionProjectName) {
        this.detectionProjectName = detectionProjectName;
    }

    public Long getReceiverId() {
        return receiverId;
    }

    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public List<SampleDetailEntity> getSampleDetailList() {
        return sampleDetailList;
    }

    public void setSampleDetailList(List<SampleDetailEntity> sampleDetailList) {
        this.sampleDetailList = sampleDetailList;
    }

    public List<RequireDetailEntity> getRequireDetailList() {
        return requireDetailList;
    }

    public void setRequireDetailList(List<RequireDetailEntity> requireDetailList) {
        this.requireDetailList = requireDetailList;
    }

    public String getDetectMode() {
        return detectMode;
    }

    public void setDetectMode(String detectMode) {
        this.detectMode = detectMode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getDetectionType() {
        return detectionType;
    }

    public void setDetectionType(Integer detectionType) {
        this.detectionType = detectionType;
    }
    public Integer getEntrustType() {
        return entrustType;
    }

    public void setEntrustType(Integer entrustType) {
        this.entrustType = entrustType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getDepartId() {
        return departId;
    }

    public void setDepartId(Long departId) {
        this.departId = departId;
    }
    public String getDepartName() {
        return departName;
    }

    public void setDepartName(String departName) {
        this.departName = departName;
    }
    public String getDepartCode() {
        return departCode;
    }

    public void setDepartCode(String departCode) {
        this.departCode = departCode;
    }
    public Date getEntrustDate() {
        return entrustDate;
    }

    public void setEntrustDate(Date entrustDate) {
        this.entrustDate = entrustDate;
    }
    public String getSampleName() {
        return sampleName;
    }

    public void setSampleName(String sampleName) {
        this.sampleName = sampleName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getEntrustUserId() {
        return entrustUserId;
    }

    public void setEntrustUserId(Long entrustUserId) {
        this.entrustUserId = entrustUserId;
    }
    public String getEntrustUserName() {
        return entrustUserName;
    }

    public void setEntrustUserName(String entrustUserName) {
        this.entrustUserName = entrustUserName;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public List<EntrustDetectDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<EntrustDetectDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
