package com.ejianc.business.jlprogress.quality.controller;

import java.io.Serializable;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.vo.PriceVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmDetailEntity;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmDetailService;
import com.ejianc.business.jlprogress.quality.vo.OutPurchaseProductCountVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmEntity;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmService;
import com.ejianc.business.jlprogress.quality.vo.OutsourceConfirmVO;

/**
 * 质量检测-外协检验确认单-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outsourceConfirm")
public class OutsourceConfirmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "OUTSOURCE_CONFIRM_CODE";//此处需要根据实际修改

    @Autowired
    private IOutsourceConfirmService service;

    @Autowired
    private IOutsourceConfirmDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> saveOrUpdate(@RequestBody OutsourceConfirmVO saveOrUpdateVO) {
        OutsourceConfirmEntity entity = BeanMapper.map(saveOrUpdateVO, OutsourceConfirmEntity.class);
        LambdaQueryWrapper<OutsourceConfirmEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OutsourceConfirmEntity::getBillCode,saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(OutsourceConfirmEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(OutsourceConfirmEntity::getId,saveOrUpdateVO.getId());
        }
        List<OutsourceConfirmEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("单据编码已存在！");
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        OutsourceConfirmVO vo = BeanMapper.map(entity, OutsourceConfirmVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> queryDetail(Long id) {
    	OutsourceConfirmEntity entity = service.selectById(id);
    	OutsourceConfirmVO vo = BeanMapper.map(entity, OutsourceConfirmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutsourceConfirmVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutsourceConfirmVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutsourceConfirmVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        //外购确认单号、供货单位、采购员、产品类别、产品名称
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);
        IPage<OutsourceConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutsourceConfirmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        //外购确认单号、供货单位、采购员、产品类别、产品名称
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<OutsourceConfirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<OutsourceConfirmVO> resDatas = BeanMapper.mapList(list, OutsourceConfirmVO.class);
        for (OutsourceConfirmVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("OutsourceConfirm-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refOutsourceConfirmData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> refOutsourceConfirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);
        IPage<OutsourceConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutsourceConfirmVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 外协采购产品统计
     * @param param
     * @return
     */
    @RequestMapping(value = "/outPurchaseProductCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutPurchaseProductCountVO>> outPurchaseProductCount(@RequestBody QueryParam param) {
        //获取年月
        if (param.getParams().get("year") == null || param.getParams().get("mouth") == null){
            return CommonResponse.error("请选择年度和月份");
        }
        String yearStr = param.getParams().get("year").getValue().toString();
        String monthStr = param.getParams().get("mouth").getValue().toString();
        // 将年份和月份转换为整数
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        // 构造日期对象
        LocalDate currentMonth = LocalDate.of(year, month, 1); // 本月1日
        LocalDate lastMonth = currentMonth.minusMonths(1); // 上个月的日期
        // 计算上个月的26日和本月的25日
        LocalDate lastMonth26th = LocalDate.of(lastMonth.getYear(), lastMonth.getMonth(), 26);
        LocalDate currentMonth25th = LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), 25);

        String between = lastMonth26th +","+currentMonth25th;
        param.getParams().put("confirmDate", new Parameter(QueryParam.BETWEEN, between));
        param.getParams().remove("year");
        param.getParams().remove("mouth");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);

        //拿到所有id
        List<OutPurchaseProductCountVO> vos = BeanMapper.mapList(page.getRecords(), OutPurchaseProductCountVO.class);
        List<Long> ids = vos.stream().map(OutPurchaseProductCountVO::getId).collect(Collectors.toList());


        Map<Long, List<OutsourceConfirmDetailEntity>> idAndDetailMap = new HashMap<>();
        //根据id查询子表
        ids.forEach(id -> {
            OutsourceConfirmEntity outsourceConfirm = service.selectById(id);
            if(ObjectUtil.isNotEmpty(outsourceConfirm)){
                idAndDetailMap.put(id,outsourceConfirm.getOutsourceConfirmDetailList()); //（拿不到值 NULL）
            }
        });
        //遍历VO 根据id从map中拿到子表数据 遍历子表list 为VO赋值
        vos.forEach(vo -> {
            List<OutsourceConfirmDetailEntity> detailList = idAndDetailMap.get(vo.getId());
            detailList.forEach(detail -> {
                if("让步接收".equals(detail.getConclusion())){
                    vo.setRbjs(detail.getNum());
                }
                if("返修".equals(detail.getConclusion())){
                    vo.setFx(detail.getNum());
                }
                if("废品".equals(detail.getConclusion())){
                    vo.setFp(detail.getNum());
                }
                if("退货".equals(detail.getConclusion())){
                    vo.setTh(detail.getNum());
                }
                if("损失金额".equals(detail.getConclusion())){
                    vo.setSsje(detail.getNum());
                }
                if("外观".equals(detail.getConclusion())){
                    vo.setWg(detail.getNum());
                }
                if("尺寸".equals(detail.getConclusion())){
                    vo.setCc(detail.getNum());
                }
                if("无损".equals(detail.getConclusion())){
                    vo.setWs(detail.getNum());
                }
                if("化学".equals(detail.getConclusion())){
                    vo.setHx(detail.getNum());
                }
                if("力学".equals(detail.getConclusion())){
                    vo.setLx(detail.getNum());
                }
                vo.setHgl(vo.getQualifiedNum().divide(vo.getTestedNum(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            });

        });
        IPage<OutPurchaseProductCountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/outPurchaseProductCountExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void outPurchaseProductCountExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String yearStr = param.getParams().get("year").getValue().toString();
        String monthStr = param.getParams().get("mouth").getValue().toString();
        // 将年份和月份转换为整数
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        // 构造日期对象
        LocalDate currentMonth = LocalDate.of(year, month, 1); // 本月1日
        LocalDate lastMonth = currentMonth.minusMonths(1); // 上个月的日期
        // 计算上个月的26日和本月的25日
        LocalDate lastMonth26th = LocalDate.of(lastMonth.getYear(), lastMonth.getMonth(), 26);
        LocalDate currentMonth25th = LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), 25);

        String between = lastMonth26th +","+currentMonth25th;
        param.getParams().put("confirmDate", new Parameter(QueryParam.BETWEEN, between));
        param.getParams().remove("year");
        param.getParams().remove("mouth");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);

        //拿到所有id
        List<OutPurchaseProductCountVO> vos = BeanMapper.mapList(page.getRecords(), OutPurchaseProductCountVO.class);
        List<Long> ids = vos.stream().map(OutPurchaseProductCountVO::getId).collect(Collectors.toList());


        Map<Long, List<OutsourceConfirmDetailEntity>> idAndDetailMap = new HashMap<>();
        //根据id查询子表
        ids.forEach(id -> {
            OutsourceConfirmEntity outsourceConfirm = service.selectById(id);
            if(ObjectUtil.isNotEmpty(outsourceConfirm)){
                idAndDetailMap.put(id,outsourceConfirm.getOutsourceConfirmDetailList()); //（拿不到值 NULL）
            }
        });
        //遍历VO 根据id从map中拿到子表数据 遍历子表list 为VO赋值
        vos.forEach(vo -> {
            List<OutsourceConfirmDetailEntity> detailList = idAndDetailMap.get(vo.getId());
            detailList.forEach(detail -> {
                if("让步接收".equals(detail.getConclusion())){
                    vo.setRbjs(detail.getNum());
                }
                if("返修".equals(detail.getConclusion())){
                    vo.setFx(detail.getNum());
                }
                if("废品".equals(detail.getConclusion())){
                    vo.setFp(detail.getNum());
                }
                if("退货".equals(detail.getConclusion())){
                    vo.setTh(detail.getNum());
                }
                if("损失金额".equals(detail.getConclusion())){
                    vo.setSsje(detail.getNum());
                }
                if("外观".equals(detail.getConclusion())){
                    vo.setWg(detail.getNum());
                }
                if("尺寸".equals(detail.getConclusion())){
                    vo.setCc(detail.getNum());
                }
                if("无损".equals(detail.getConclusion())){
                    vo.setWs(detail.getNum());
                }
                if("化学".equals(detail.getConclusion())){
                    vo.setHx(detail.getNum());
                }
                if("力学".equals(detail.getConclusion())){
                    vo.setLx(detail.getNum());
                }
                vo.setHgl(vo.getQualifiedNum().divide(vo.getTestedNum(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            });

        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("OutPurchaseProductCount-export.xlsx", beans, response);
    }
}
