package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.DetectReportEntity;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IDetectReportService;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.ProcessCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 质量检测-工序检测记录
 *
 * @author generator
 */
@Controller
@RequestMapping("processCheck")
public class ProcessCheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROCESS_CHECK";

    @Autowired
    private IProcessCheckService service;

    @Autowired
    private IFinishedCheckService finishedCheckService;

    @Autowired
    private IDetectReportService detectReportService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProcessCheckVO> saveOrUpdate(@RequestBody ProcessCheckVO saveOrUpdateVO) {
        if (StringUtils.isNotBlank(saveOrUpdateVO.getBillCode())) {
            LambdaQueryWrapper<ProcessCheckEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.ne(null != saveOrUpdateVO.getId(), ProcessCheckEntity::getId, saveOrUpdateVO.getId());
            queryWrapper.eq(ProcessCheckEntity::getBillCode, saveOrUpdateVO.getBillCode());
            if (service.count(queryWrapper) > 0) {
                throw new BusinessException("该编码已存在!");
            }
        }
        ProcessCheckEntity entity = BeanMapper.map(saveOrUpdateVO, ProcessCheckEntity.class);
        if (StringUtils.isBlank(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setUseState(0);
        service.saveOrUpdate(entity, false);
        ProcessCheckVO vo = BeanMapper.map(entity, ProcessCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProcessCheckVO> queryDetail(Long id) {
        ProcessCheckEntity entity = service.selectById(id);
        ProcessCheckVO vo = BeanMapper.map(entity, ProcessCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProcessCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProcessCheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProcessCheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProcessCheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplyCode");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("checkUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProcessCheckEntity> page = service.queryPage(param, false);
        IPage<ProcessCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProcessCheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplyCode");
        fuzzyFields.add("wbsName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("checkUserName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ProcessCheckEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("ProcessCheck-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProcessCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProcessCheckVO>> refProcessCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProcessCheckEntity> page = service.queryPage(param, false);
        IPage<ProcessCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProcessCheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refMatCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (!_con.containsKey("sourceType")) {
                return CommonResponse.error("sourceType不能为空!");
            } else {
                Integer sourceType = _con.getInteger("sourceType");
                if (1 == sourceType) {
                    if (!_con.containsKey("planId")) {
                        return CommonResponse.error("工序检测时,planId不能为空!");
                    } else {
                        param.getParams().put("supplyId", new Parameter(QueryParam.EQ, _con.getLong("planId")));
                        param.getParams().put("qualifiedScale", new Parameter(QueryParam.NE, 100));
                        param.getParams().put("useState", new Parameter(QueryParam.EQ, 0));
                        List<Integer> state = new ArrayList<>();
                        state.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                        state.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                        param.getParams().put("billState", new Parameter(QueryParam.IN, state));
                        param.getParams().remove("sourceType");
                        param.getParams().remove("planId");
                        IPage<ProcessCheckEntity> page = service.queryPage(param, false);
                        IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                        List<JSONObject> list = new ArrayList<>();
                        for (ProcessCheckEntity checkEntity : page.getRecords()) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("id", checkEntity.getId());
                            jsonObject.put("code", checkEntity.getBillCode());
                            jsonObject.put("name", checkEntity.getBillCode());
                            jsonObject.put("memo", checkEntity.getMemo());
                            jsonObject.put("productId",checkEntity.getWbsId());
                            jsonObject.put("productName",checkEntity.getWbsName());
                            list.add(jsonObject);
                        }
                        pageData.setRecords(list);
                        return CommonResponse.success("查询参照数据成功！", pageData);
                    }
                } else if (2 == sourceType) {
                    if (!_con.containsKey("planId")) {
                        return CommonResponse.error("成品检测时,planId不能为空!");
                    } else {
                        param.getParams().put("supplyId", new Parameter(QueryParam.EQ, _con.getLong("planId")));
                        param.getParams().put("qualifiedScale", new Parameter(QueryParam.NE, 100));
                        param.getParams().put("useState", new Parameter(QueryParam.EQ, 0));
                        List<Integer> state = new ArrayList<>();
                        state.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                        state.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                        param.getParams().put("billState", new Parameter(QueryParam.IN, state));
                        param.getParams().remove("sourceType");
                        param.getParams().remove("planId");
                        IPage<FinishedCheckEntity> page = finishedCheckService.queryPage(param, false);
                        IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                        List<JSONObject> list = new ArrayList<>();
                        for (FinishedCheckEntity checkEntity : page.getRecords()) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("id", checkEntity.getId());
                            jsonObject.put("code", checkEntity.getBillCode());
                            jsonObject.put("name", checkEntity.getBillCode());
                            jsonObject.put("memo", checkEntity.getMemo());
                            jsonObject.put("productId",checkEntity.getWbsId());
                            jsonObject.put("productName",checkEntity.getWbsName());
                            list.add(jsonObject);
                        }
                        pageData.setRecords(list);
                        return CommonResponse.success("查询参照数据成功！", pageData);
                    }
                } else if (3 == sourceType) {
                    param.getParams().put("reference_flag", new Parameter(QueryParam.EQ, 0));
                    param.getParams().put("detectionType", new Parameter(QueryParam.EQ, 0));
                    param.getParams().put("entrustResultName", new Parameter(QueryParam.NE, "合格"));
                    List<Integer> state = new ArrayList<>();
                    state.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                    state.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                    param.getParams().put("billState", new Parameter(QueryParam.IN, state));
                    param.getParams().remove("sourceType");
                    IPage<DetectReportEntity> page = detectReportService.queryPage(param, false);
                    IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    List<JSONObject> list = new ArrayList<>();
                    for (DetectReportEntity checkEntity : page.getRecords()) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", checkEntity.getId());
                        jsonObject.put("code", checkEntity.getBillCode());
                        jsonObject.put("name", checkEntity.getBillCode());
                        jsonObject.put("memo", checkEntity.getMemo());
                        list.add(jsonObject);
                    }
                    pageData.setRecords(list);
                    return CommonResponse.success("查询参照数据成功！", pageData);
                }
            }
        }else {
            return CommonResponse.error("参数不能为空!");
        }

        return CommonResponse.success("查询参照数据成功！", null);
    }
}
