/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.labor.bean.WorktimeSetEntity;
import com.ejianc.business.jlprogress.labor.mapper.WorktimeSetMapper;
import com.ejianc.business.jlprogress.labor.service.IWorktimeSetService;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="worktimeSetService")
public class WorktimeSetServiceImpl
extends BaseServiceImpl<WorktimeSetMapper, WorktimeSetEntity>
implements IWorktimeSetService {
    private static final String QR_CODE_LOGIN_URL = "ejc-jlprogress-mobile/#/qrCodeLogin";
    private static final String CODE = "Weixin";
    private static final String SCOPE = "snsapi_base";
    private static final String STATE = "123";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Resource
    private IThirdSystemApi thirdSystemApi;

    @Override
    public JSONObject getQrCode(Long id) throws UnsupportedEncodingException {
        Assert.notNull((Object)id, (String)"\u8003\u52e4\u8bbe\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WorktimeSetEntity entity = (WorktimeSetEntity)((Object)super.selectById((Serializable)id));
        Assert.notNull((Object)((Object)entity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject resp = new JSONObject();
        String sb = "?worktimeSetId=" + id + "&tenantId=" + entity.getTenantId() + "&projectId=" + entity.getProjectId() + "&projectName=" + entity.getProjectName();
        String redirectUri = this.BaseHost + QR_CODE_LOGIN_URL + sb;
        String redirectUrl = URLEncoder.encode(redirectUri, "UTF-8");
        CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + thirdSystemResponse.getMsg());
        }
        Assert.notNull((Object)thirdSystemResponse.getData(), (String)"\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ThirdSystemVO thirdSystemVO = (ThirdSystemVO)thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject((String)configInfo);
        String appId = configJson.getString("appid");
        String openWeixin = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
        openWeixin = openWeixin.replace("APPID", appId).replace("REDIRECT_URI", redirectUrl).replace("SCOPE", SCOPE).replace("STATE", STATE);
        resp.put("mobileH5Url", (Object)openWeixin);
        resp.put("mobileWxUrl", (Object)openWeixin);
        return resp;
    }
}

