/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.ProductOutRecordVO;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/orderApi/"})
public class OrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalesService salesService;
    @Autowired
    private IProductOutService productOutService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryService deliveryService;

    @GetMapping(value={"getOrderDataByContractId"})
    CommonResponse<JSONObject> getOrderDataByContractId(@RequestParam Long contractId) {
        JSONObject returnObject = new JSONObject();
        this.logger.info("\u63a5\u6536\u53c2\u6570-contractId-{}", (Object)contractId);
        SalesListVO salesListVO = this.salesService.getContractSales(contractId);
        this.logger.info("\u83b7\u53d6\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f-" + JSONObject.toJSONString((Object)salesListVO));
        returnObject.put("firstOrderDate", (Object)salesListVO.getFirstOrderDate());
        returnObject.put("salesList", (Object)salesListVO.getSalesList());
        ProductOutRecordVO productOutRecordVO = this.productOutService.queryProductOutRecord(contractId);
        this.logger.info("\u83b7\u53d6\u5230\u53d1\u8d27\u8bb0\u5f55\u4fe1\u606f-" + JSONObject.toJSONString((Object)productOutRecordVO));
        returnObject.put("productOutVOList", (Object)productOutRecordVO.getProductOutVOList());
        if (null != productOutRecordVO && CollectionUtils.isNotEmpty((Collection)productOutRecordVO.getProductOutVOList()) && productOutRecordVO.getProductOutVOList().size() > 0) {
            returnObject.put("productOutState", (Object)"\u5df2\u53d1\u8d27");
        } else {
            returnObject.put("productOutState", (Object)"\u672a\u53d1\u8d27");
        }
        JSONObject checkData = this.checkService.getCheckDataByContractId(contractId);
        returnObject.put("checkList", checkData.get((Object)"checkList"));
        returnObject.put("checkState", checkData.get((Object)"checkState"));
        return CommonResponse.success((Object)returnObject);
    }

    @PostMapping(value={"getOrderDataByContractIdList"})
    CommonResponse<JSONObject> getOrderDataByContractIdList(@RequestBody List<Long> ids) {
        JSONObject returnObject = new JSONObject();
        this.logger.info("\u63a5\u6536\u53c2\u6570-ids-{}", (Object)JSONObject.toJSONString(ids));
        Map<Long, SalesListVO> contractSalesMap = this.salesService.getContractSalesByContractIdList(ids);
        Map<Long, ProductOutRecordVO> productOutRecordMap = this.productOutService.queryProductOutRecordByContractIdList(ids);
        Map<Long, JSONObject> checkDataMap = this.checkService.getCheckDataByContractIdList(ids);
        Map<Long, JSONObject> deliveryDataMap = this.deliveryService.getDeliveryDataByContractIdList(ids);
        for (Long contractId : ids) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("contractId", (Object)contractId);
            if (contractSalesMap.containsKey(contractId)) {
                dataObject.put("firstOrderDate", (Object)contractSalesMap.get(contractId).getFirstOrderDate());
                dataObject.put("salesList", (Object)contractSalesMap.get(contractId).getSalesList());
            }
            if (productOutRecordMap.containsKey(contractId)) {
                dataObject.put("productOutVOList", (Object)productOutRecordMap.get(contractId).getProductOutVOList());
                dataObject.put("productOutState", (Object)"\u5df2\u53d1\u8d27");
            }
            if (checkDataMap.containsKey(contractId)) {
                dataObject.put("checkList", checkDataMap.get(contractId).get((Object)"checkList"));
                dataObject.put("checkState", checkDataMap.get(contractId).get((Object)"checkState"));
            }
            if (deliveryDataMap.containsKey(contractId)) {
                dataObject.put("deliveryNoticeList", deliveryDataMap.get(contractId).get((Object)"deliveryNoticeList"));
            }
            returnObject.put(contractId.toString(), (Object)dataObject);
        }
        this.logger.info("\u83b7\u5f97\u5408\u540c\u4e0b\u8ba2\u5355\u4fe1\u606f-returnObject-{}", (Object)JSONObject.toJSONString((Object)returnObject));
        return CommonResponse.success((Object)returnObject);
    }
}

