/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.business.jlprogress.order.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.jlprogress.order.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"delivery"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FHTZ_CODE";
    @Autowired
    private IDeliveryService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CheckBpmServiceImpl check;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity deliveryEntity = this.service.selectNotActivated(saveOrUpdateVO.getId(), saveOrUpdateVO.getContractId());
        if (deliveryEntity != null) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4e2a\u672a\u751f\u6548\u7684\u5355\u636e");
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO deliveryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        DeliveryController.setFuzzyFields(param);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        if (null != page.getRecords() && page.getRecords().size() != 0) {
            List ids = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List checkList = this.checkService.list((Wrapper)new QueryWrapper().in((Object)"delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(CheckEntity::getDeliveryId, e -> 1, (e1, e2) -> {
                e1 = e1 + 1;
                return e1;
            }));
            page.getRecords().forEach(detail -> {
                Integer checkNum = (Integer)checkNums.get(detail.getId());
                detail.setCheckNum(checkNum == null ? 0 : checkNum);
            });
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        DeliveryController.setFuzzyFields(param);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<DeliveryEntity> list = this.service.queryListWithCheckCount(param);
        List voList = BeanMapper.mapList(list, DeliveryVO.class);
        for (DeliveryVO deliveryVO : voList) {
            if (deliveryVO.getBillState() == 0) {
                deliveryVO.setBillStateName("\u81ea\u7531\u6001");
            }
            if (deliveryVO.getBillState() == 2 || deliveryVO.getBillState() == 5) {
                deliveryVO.setBillStateName("\u5ba1\u6279\u4e2d");
            }
            if (deliveryVO.getBillState() == 1) {
                deliveryVO.setBillStateName("\u5df2\u63d0\u4ea4");
            }
            if (deliveryVO.getBillState() == 3) {
                deliveryVO.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
            }
            if (deliveryVO.getBillState() != 4) continue;
            deliveryVO.setBillStateName("\u5ba1\u6279\u9a73\u56de");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter("in", list));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            Long contractId = _con.getLong("contractId");
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/selectDeliveryCount"})
    @ResponseBody
    public CommonResponse selectMoney(Long Id, Long contractId) {
        System.out.println(contractId);
        System.out.println(Id);
        Integer count = this.service.selectCount(Id, contractId);
        return CommonResponse.success((String)"\u6210\u529f", (Object)count);
    }

    private static void setFuzzyFields(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("clientName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("receiverName");
    }

    @RequestMapping(value={"/queryDeliveryRecordByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDeliveryRecordByContractId(@RequestParam Long contractId) {
        JSONObject jsonObject = new JSONObject();
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeliveryEntity::getBillState, Arrays.asList(1, 3))).eq(DeliveryEntity::getContractId, (Object)contractId));
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            List deliveryVOList = BeanMapper.mapList((Iterable)list, DeliveryVO.class);
            List ids = deliveryVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            List checkList = this.checkService.list((Wrapper)new QueryWrapper().in((Object)"delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(CheckEntity::getDeliveryId, e -> 1, (e1, e2) -> {
                e1 = e1 + 1;
                return e1;
            }));
            deliveryVOList.forEach(detail -> {
                Integer checkNum = (Integer)checkNums.get(detail.getId());
                detail.setCheckNum(Integer.valueOf(checkNum == null ? 0 : checkNum));
            });
            jsonObject.put("deliveryVOList", (Object)deliveryVOList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

