/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.mapper.OutStoreDetailMapper;
import com.ejianc.business.jlprogress.order.mapper.OutStoreMapper;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.order.vo.OutStoreVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outStoreService")
public class OutStoreServiceImpl
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CLCK_NUM_PARAM_CODE = "P-3HrsR50012";
    private static final String CLCK_MNY_PARAM_CODE = "P-4wl6550007";
    @Autowired
    private ITargetApi targetApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private OutStoreDetailMapper detailMapper;

    @Override
    public ParamsCheckVO checkParams(OutStoreVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOS.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(OutStoreVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List list = vo.getOutStoreDetailList();
        List<Object> resList = new ArrayList();
        resList = list.stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toMap(OutStoreDetailVO::getMaterialId, e -> e, (e1, e2) -> {
            e1.setMaterialNum(e1.getMaterialNum().add(e2.getMaterialNum()));
            e1.setDetailStoreMny(e1.getDetailStoreMny().add(e2.getDetailStoreMny()));
            return e1;
        })).values().stream().collect(Collectors.toList());
        List MaterialIds = vo.getOutStoreDetailList().stream().map(OutStoreDetailVO::getMaterialId).collect(Collectors.toList());
        CommonResponse targetData = this.targetApi.getMaterialDataByMaterialIds(vo.getProjectId(), vo.getWbsId(), MaterialIds);
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<String, QueryTargetDataVO> targetMap = targetDataList.stream().collect(Collectors.toMap(t -> t.getProjectId() + "-" + t.getProductId() + "-" + t.getMaterialId(), t -> t));
        List<OutStoreDetailVO> detailList = this.detailMapper.getDetailByProjectAndWbs(vo.getProjectId(), vo.getWbsId(), vo.getId());
        Map<String, OutStoreDetailVO> totalMap = detailList.stream().collect(Collectors.toMap(detail -> detail.getProjectId() + "-" + detail.getWbsId() + "-" + detail.getMaterialId(), each -> each));
        CommonResponse billParamNumByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CLCK_NUM_PARAM_CODE, vo.getOrgId());
        if (!billParamNumByCode.isSuccess() || null == billParamNumByCode.getData()) {
            this.logger.info(billParamNumByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List maxParamNumVOS = (List)billParamNumByCode.getData();
        this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u96f6\u4ef6\u6750\u6599\u6e05\u5355\u91cf\u3011\u7ba1\u63a7\u3010\u96f6\u4ef6\u6750\u6599\u6e05\u5355\u51fa\u5e93\u91cf\u3011\uff1a" + JSONObject.toJSONString((Object)maxParamNumVOS));
        for (BillParamVO maxParamVO : maxParamNumVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
            ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
            BigDecimal roleValue = maxParamVO.getRoleValue().setScale(2, 5);
            for (OutStoreDetailVO outStoreDetailVO : resList) {
                String key = vo.getProjectId() + "-" + vo.getWbsId() + "-" + outStoreDetailVO.getMaterialId();
                QueryTargetDataVO queryTargetDataVO = targetMap.get(key);
                if (queryTargetDataVO == null) continue;
                BigDecimal targetNum = queryTargetDataVO.getNum().setScale(2, 5);
                OutStoreDetailVO total = totalMap.get(key);
                BigDecimal num = outStoreDetailVO.getMaterialNum().add(total == null ? BigDecimal.ZERO : total.getMaterialNum()).setScale(2, 5);
                if (queryTargetDataVO.getNum().multiply(roleValue.divide(BigDecimal.valueOf(100L))).compareTo(num) >= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem(outStoreDetailVO.getMaterialName() + " - " + outStoreDetailVO.getSpec() + " \u51fa\u5e93\u91cf\u8d85\u989d\u9884\u8b66");
                paramsCheckDsVO.setWarnName("\u96f6\u4ef6\u6750\u6599\u51fa\u5e93\u91cf\u8d85\u76ee\u6807\u6210\u672c\u96f6\u4ef6\u6750\u6599\u91cf");
                StringBuffer stringBuffer = new StringBuffer();
                String text = "\u8d85\u51fa\u6570\u91cf\uff1a" + num + "-" + targetNum + "*" + roleValue + "=" + num.subtract(queryTargetDataVO.getNum().multiply(roleValue.divide(BigDecimal.valueOf(100L)))).setScale(2, 5) + "\u5428";
                String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                stringBuffer.append("\u7d2f\u8ba1\u51fa\u5e93\u91cf\uff1a").append(num).append("\u5428").append("\uff0c\u76ee\u6807\u6210\u672c\u91cf\uff1a").append(targetNum).append("\u5428").append("\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOSMax.add(paramsCheckDsVO);
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);
        }
        CommonResponse billParamMnyByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CLCK_MNY_PARAM_CODE, vo.getOrgId());
        if (!billParamMnyByCode.isSuccess() || null == billParamMnyByCode.getData()) {
            this.logger.info(billParamMnyByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List maxParamMnyVOS = (List)billParamMnyByCode.getData();
        this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u96f6\u4ef6\u6750\u6599\u6e05\u5355\u91d1\u989d\u3011\u7ba1\u63a7\u3010\u96f6\u4ef6\u6750\u6599\u6e05\u5355\u51fa\u5e93\u91d1\u989d\u3011\uff1a" + JSONObject.toJSONString((Object)maxParamMnyVOS));
        for (BillParamVO maxParamVO : maxParamMnyVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
            ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
            BigDecimal bigDecimal = maxParamVO.getRoleValue().setScale(2, 5);
            for (OutStoreDetailVO outStoreDetailVO : resList) {
                String key = vo.getProjectId() + "-" + vo.getWbsId() + "-" + outStoreDetailVO.getMaterialId();
                QueryTargetDataVO target = targetMap.get(key);
                if (target == null) continue;
                BigDecimal targetMny = target.getMny().setScale(2, 5);
                OutStoreDetailVO total = totalMap.get(key);
                BigDecimal mny = outStoreDetailVO.getDetailStoreMny().add(total == null ? BigDecimal.ZERO : total.getDetailStoreMny()).setScale(2, 5);
                if (targetMny.multiply(bigDecimal.divide(BigDecimal.valueOf(100L))).compareTo(mny) >= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem(outStoreDetailVO.getMaterialName() + " - " + outStoreDetailVO.getSpec() + " \u51fa\u5e93\u91d1\u989d\u8d85\u989d\u9884\u8b66");
                paramsCheckDsVO.setWarnName("\u96f6\u4ef6\u6750\u6599\u51fa\u5e93\u91d1\u989d\u8d85\u76ee\u6807\u6210\u672c\u96f6\u4ef6\u6750\u6599\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + mny + "-" + targetMny + "*" + bigDecimal + "=" + mny.subtract(targetMny.multiply(bigDecimal.divide(BigDecimal.valueOf(100L)))).setScale(2, 5) + "\u5143";
                String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                stringBuffer.append("\u7d2f\u8ba1\u51fa\u5e93\u91d1\u989d\uff1a").append(mny).append("\u5143").append("\uff0c\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a").append(targetMny).append("\u5143").append("\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(bigDecimal).append("%\uff0c").append(redText);
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOSMax.add(paramsCheckDsVO);
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);
        }
        return paramsCheckVOS;
    }
}

