/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmEntity;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmDetailService;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmService;
import com.ejianc.business.jlprogress.quality.vo.OutPurchaseProductCountVO;
import com.ejianc.business.jlprogress.quality.vo.OutsourceConfirmVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outsourceConfirm"})
public class OutsourceConfirmController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "OUTSOURCE_CONFIRM_CODE";
    @Autowired
    private IOutsourceConfirmService service;
    @Autowired
    private IOutsourceConfirmDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> saveOrUpdate(@RequestBody OutsourceConfirmVO saveOrUpdateVO) {
        List list;
        OutsourceConfirmEntity entity = (OutsourceConfirmEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutsourceConfirmEntity.class));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OutsourceConfirmEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        if (entity.getId() != null) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)lambdaQueryWrapper)))) {
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutsourceConfirmVO vo = (OutsourceConfirmVO)BeanMapper.map((Object)((Object)entity), OutsourceConfirmVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> queryDetail(Long id) {
        OutsourceConfirmEntity entity = (OutsourceConfirmEntity)((Object)this.service.selectById(id));
        OutsourceConfirmVO vo = (OutsourceConfirmVO)BeanMapper.map((Object)((Object)entity), OutsourceConfirmVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutsourceConfirmVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutsourceConfirmVO outsourceConfirmVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutsourceConfirmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List resDatas = BeanMapper.mapList((Iterable)list, OutsourceConfirmVO.class);
        for (OutsourceConfirmVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0: {
                    resData.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    resData.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: 
                case 5: {
                    resData.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    resData.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    resData.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("OutsourceConfirm-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutsourceConfirmData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> refOutsourceConfirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutsourceConfirmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/outPurchaseProductCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutPurchaseProductCountVO>> outPurchaseProductCount(@RequestBody QueryParam param) {
        if (param.getParams().get("year") == null || param.getParams().get("mouth") == null) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u5e74\u5ea6\u548c\u6708\u4efd");
        }
        String yearStr = ((Parameter)param.getParams().get("year")).getValue().toString();
        String monthStr = ((Parameter)param.getParams().get("mouth")).getValue().toString();
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        LocalDate currentMonth = LocalDate.of(year, month, 1);
        LocalDate lastMonth = currentMonth.minusMonths(1L);
        LocalDate lastMonth26th = LocalDate.of(lastMonth.getYear(), lastMonth.getMonth(), 26);
        LocalDate currentMonth25th = LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), 25);
        String between = lastMonth26th + "," + currentMonth25th;
        param.getParams().put("confirmDate", new Parameter("between", (Object)between));
        param.getParams().remove("year");
        param.getParams().remove("mouth");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<OutPurchaseProductCountVO> outPurchaseProductCount = this.service.getOutPurchaseProductCount(wrapper);
        Map<Long, List<OutPurchaseProductCountVO>> listMap = outPurchaseProductCount.stream().collect(Collectors.groupingBy(BaseVO::getId));
        ArrayList<OutPurchaseProductCountVO> resultVO = new ArrayList<OutPurchaseProductCountVO>();
        for (Map.Entry<Long, List<OutPurchaseProductCountVO>> entry : listMap.entrySet()) {
            OutPurchaseProductCountVO vo = (OutPurchaseProductCountVO)BeanMapper.map((Object)entry.getValue().get(0), OutPurchaseProductCountVO.class);
            vo.setHgl(vo.getQualifiedNum().divide(vo.getTestedNum(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            List<OutPurchaseProductCountVO> values = entry.getValue();
            values.forEach(value -> {
                if ("\u8ba9\u6b65\u63a5\u6536".equals(value.getConclusion())) {
                    vo.setRbjs(value.getNum());
                }
                if ("\u8fd4\u4fee".equals(value.getConclusion())) {
                    vo.setFx(value.getNum());
                }
                if ("\u5e9f\u54c1".equals(value.getConclusion())) {
                    vo.setFp(value.getNum());
                }
                if ("\u9000\u8d27".equals(value.getConclusion())) {
                    vo.setTh(value.getNum());
                }
                if ("\u635f\u5931\u91d1\u989d".equals(value.getConclusion())) {
                    vo.setSsje(value.getNum());
                }
                if ("\u5916\u89c2".equals(value.getConclusion())) {
                    vo.setWg(value.getNum());
                }
                if ("\u5c3a\u5bf8".equals(value.getConclusion())) {
                    vo.setCc(value.getNum());
                }
                if ("\u65e0\u635f".equals(value.getConclusion())) {
                    vo.setWs(value.getNum());
                }
                if ("\u5316\u5b66".equals(value.getConclusion())) {
                    vo.setHx(value.getNum());
                }
                if ("\u529b\u5b66".equals(value.getConclusion())) {
                    vo.setLx(value.getNum());
                }
            });
            resultVO.add(vo);
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resultVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/outPurchaseProductCountExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void outPurchaseProductCountExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String yearStr = ((Parameter)param.getParams().get("year")).getValue().toString();
        String monthStr = ((Parameter)param.getParams().get("mouth")).getValue().toString();
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        LocalDate currentMonth = LocalDate.of(year, month, 1);
        LocalDate lastMonth = currentMonth.minusMonths(1L);
        LocalDate lastMonth26th = LocalDate.of(lastMonth.getYear(), lastMonth.getMonth(), 26);
        LocalDate currentMonth25th = LocalDate.of(currentMonth.getYear(), currentMonth.getMonth(), 25);
        String between = lastMonth26th + "," + currentMonth25th;
        param.getParams().put("confirmDate", new Parameter("between", (Object)between));
        param.getParams().remove("year");
        param.getParams().remove("mouth");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<OutPurchaseProductCountVO> outPurchaseProductCount = this.service.getOutPurchaseProductCount(wrapper);
        Map<Long, List<OutPurchaseProductCountVO>> listMap = outPurchaseProductCount.stream().collect(Collectors.groupingBy(BaseVO::getId));
        ArrayList<OutPurchaseProductCountVO> resultVO = new ArrayList<OutPurchaseProductCountVO>();
        for (Map.Entry<Long, List<OutPurchaseProductCountVO>> entry : listMap.entrySet()) {
            OutPurchaseProductCountVO vo = (OutPurchaseProductCountVO)BeanMapper.map((Object)entry.getValue().get(0), OutPurchaseProductCountVO.class);
            vo.setHgl(vo.getQualifiedNum().divide(vo.getTestedNum(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            List<OutPurchaseProductCountVO> values = entry.getValue();
            values.forEach(value -> {
                if ("\u8ba9\u6b65\u63a5\u6536".equals(value.getConclusion())) {
                    vo.setRbjs(value.getNum());
                }
                if ("\u8fd4\u4fee".equals(value.getConclusion())) {
                    vo.setFx(value.getNum());
                }
                if ("\u5e9f\u54c1".equals(value.getConclusion())) {
                    vo.setFp(value.getNum());
                }
                if ("\u9000\u8d27".equals(value.getConclusion())) {
                    vo.setTh(value.getNum());
                }
                if ("\u635f\u5931\u91d1\u989d".equals(value.getConclusion())) {
                    vo.setSsje(value.getNum());
                }
                if ("\u5916\u89c2".equals(value.getConclusion())) {
                    vo.setWg(value.getNum());
                }
                if ("\u5c3a\u5bf8".equals(value.getConclusion())) {
                    vo.setCc(value.getNum());
                }
                if ("\u65e0\u635f".equals(value.getConclusion())) {
                    vo.setWs(value.getNum());
                }
                if ("\u5316\u5b66".equals(value.getConclusion())) {
                    vo.setHx(value.getNum());
                }
                if ("\u529b\u5b66".equals(value.getConclusion())) {
                    vo.setLx(value.getNum());
                }
            });
            resultVO.add(vo);
        }
        HashMap<String, ArrayList<OutPurchaseProductCountVO>> beans = new HashMap<String, ArrayList<OutPurchaseProductCountVO>>();
        beans.put("records", resultVO);
        ExcelExport.getInstance().export("OutPurchaseProductCount-export.xlsx", beans, response);
    }
}

