/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.bean.DisposeEntity;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IDisposeService;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.PassRateVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"passRate"})
public class PassRateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessCheckService processCheckService;
    @Autowired
    private IDisposeService disposeService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PassRateVO>> queryList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String startOfMonth = "";
        String endOfMonth = "";
        List processCheckEntities = new ArrayList();
        if (param.getParams().containsKey("orgId")) {
            String checkMonth = ((Parameter)param.getParams().get("month")).getValue().toString();
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            Month lastMonth = date.minusMonths(1L).getMonth();
            Month month = date.getMonth();
            int year = date.minusMonths(1L).getYear();
            startOfMonth = LocalDate.of(year, lastMonth, 26).toString();
            endOfMonth = LocalDate.of(year, month, 25).toString();
            param.getParams().remove("month");
            param.getParams().put("month", new Parameter("between", (Object)startOfMonth, endOfMonth));
        }
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        if (param.getParams().containsKey("orgId")) {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            checkWrapper.eq(ProcessCheckEntity::getProductOrgId, (Object)orgId);
            checkWrapper.between(ProcessCheckEntity::getCheckDate, (Object)startOfMonth, (Object)endOfMonth);
            processCheckEntities = this.processCheckService.list((Wrapper)checkWrapper);
        }
        List billCodes = processCheckEntities.stream().map(item -> item.getBillCode()).collect(Collectors.toList());
        List checkDisposeEntities = new ArrayList();
        if (billCodes.size() != 0) {
            LambdaQueryWrapper checkDisposeWrapper = new LambdaQueryWrapper();
            checkDisposeWrapper.in(DisposeEntity::getCheckCode, billCodes);
            checkDisposeWrapper.between(BaseEntity::getCreateTime, (Object)startOfMonth, (Object)endOfMonth);
            checkDisposeEntities = this.disposeService.list((Wrapper)checkDisposeWrapper);
        }
        ArrayList<PassRateVO> passRateVOS = new ArrayList<PassRateVO>();
        for (ProcessCheckEntity processCheckEntity : processCheckEntities) {
            PassRateVO passRateVO = new PassRateVO();
            BigDecimal totalNum = processCheckEntity.getTotalNum();
            if (processCheckEntity.getQualifiedScale().equals(new BigDecimal(100))) {
                passRateVO.setId(processCheckEntity.getId());
                passRateVO.setProcessId(processCheckEntity.getProcessId());
                passRateVO.setProcessName(processCheckEntity.getProcessName());
                passRateVO.setProcessTotalNum(totalNum);
                passRateVO.setQualifiedNum(totalNum);
                passRateVO.setConcession(BigDecimal.ZERO);
                passRateVO.setRebuild(BigDecimal.ZERO);
                passRateVO.setRework(BigDecimal.ZERO);
                passRateVO.setWorkWaste(BigDecimal.ZERO);
                passRateVO.setMaterialWaste(BigDecimal.ZERO);
                passRateVO.setQualifiedScale(new BigDecimal(100));
                passRateVO.setQualityLoss(BigDecimal.ZERO);
                passRateVOS.add(passRateVO);
                continue;
            }
            List checkedDisposeEntities = checkDisposeEntities.stream().filter(item -> item.getCheckCode().equals(processCheckEntity.getBillCode())).collect(Collectors.toList());
            for (DisposeEntity disposeEntity : checkedDisposeEntities) {
                passRateVO.setQualityLoss(disposeEntity.getFinancialLoss());
            }
            BigDecimal concession = new BigDecimal(checkedDisposeEntities.stream().filter(item -> item.getSchemeName().equals("\u8ba9\u6b65\u63a5\u6536")).mapToInt(DisposeEntity::getNoNum).sum());
            BigDecimal rebuild = new BigDecimal(checkedDisposeEntities.stream().filter(item -> item.getSchemeName().equals("\u8fd4\u4fee")).mapToInt(DisposeEntity::getNoNum).sum());
            BigDecimal rework = new BigDecimal(checkedDisposeEntities.stream().filter(item -> item.getSchemeName().equals("\u8fd4\u5de5")).mapToInt(DisposeEntity::getNoNum).sum());
            BigDecimal workWaste = new BigDecimal(checkedDisposeEntities.stream().filter(item -> item.getSchemeName().equals("\u5de5\u5e9f")).mapToInt(DisposeEntity::getNoNum).sum());
            BigDecimal materialWaste = new BigDecimal(checkedDisposeEntities.stream().filter(item -> item.getSchemeName().equals("\u6599\u5e9f")).mapToInt(DisposeEntity::getNoNum).sum());
            BigDecimal qualifiedNum = totalNum.subtract(concession).subtract(rebuild).subtract(rework).subtract(workWaste).subtract(materialWaste);
            passRateVO.setId(processCheckEntity.getId());
            passRateVO.setProcessId(processCheckEntity.getProcessId());
            passRateVO.setProcessName(processCheckEntity.getProcessName());
            passRateVO.setProcessTotalNum(totalNum);
            passRateVO.setQualifiedNum(qualifiedNum);
            passRateVO.setConcession(concession);
            passRateVO.setRebuild(rebuild);
            passRateVO.setRework(rework);
            passRateVO.setWorkWaste(workWaste);
            passRateVO.setMaterialWaste(materialWaste);
            passRateVO.setQualifiedScale(qualifiedNum.divide(totalNum, 8, 4).multiply(new BigDecimal(100)));
            passRateVOS.add(passRateVO);
        }
        List uniquePassRateVOS = passRateVOS.stream().collect(Collectors.toMap(PassRateVO::getProcessId, v -> v, (v1, v2) -> {
            v1.setProcessTotalNum(PassRateController.ensureNotNull(v1.getProcessTotalNum(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getProcessTotalNum(), BigDecimal.ZERO)));
            v1.setQualifiedNum(PassRateController.ensureNotNull(v1.getQualifiedNum(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getQualifiedNum(), BigDecimal.ZERO)));
            v1.setConcession(PassRateController.ensureNotNull(v1.getConcession(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getConcession(), BigDecimal.ZERO)));
            v1.setRebuild(PassRateController.ensureNotNull(v1.getRebuild(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getRebuild(), BigDecimal.ZERO)));
            v1.setRework(PassRateController.ensureNotNull(v1.getRework(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getRework(), BigDecimal.ZERO)));
            v1.setWorkWaste(PassRateController.ensureNotNull(v1.getWorkWaste(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getWorkWaste(), BigDecimal.ZERO)));
            v1.setMaterialWaste(PassRateController.ensureNotNull(v1.getMaterialWaste(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getMaterialWaste(), BigDecimal.ZERO)));
            v1.setQualityLoss(PassRateController.ensureNotNull(v1.getQualityLoss(), BigDecimal.ZERO).add(PassRateController.ensureNotNull(v2.getQualityLoss(), BigDecimal.ZERO)));
            BigDecimal qualifiedNum1 = v1.getProcessTotalNum().subtract(v1.getConcession()).subtract(v1.getRebuild()).subtract(v2.getRework()).subtract(v2.getWorkWaste()).subtract(v2.getMaterialWaste());
            v1.setQualifiedNum(qualifiedNum1);
            v1.setQualifiedScale(qualifiedNum1.divide(v1.getProcessTotalNum(), 8, 4).multiply(new BigDecimal(100)));
            return v1;
        })).values().stream().collect(Collectors.toList());
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        pageData.setRecords(uniquePassRateVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private static BigDecimal ensureNotNull(BigDecimal value, BigDecimal defaultValue) {
        return value != null ? value : defaultValue;
    }
}

