package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.bean.RegisterEntity;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.mapper.RegisterMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;

@Service("register") 
public class RegisterBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private RegisterMapper registerMapper;

	@Autowired
	private RecordServiceImpl recordService;

	@Autowired
	private RecordMapper recordMapper;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//查询 登记表实体
		try {
			RegisterEntity registerEntity = registerMapper.selectById(billId);

			logger.info("终审审核完回调-----registerEntity:{}",registerEntity);

			//构建 记录表实体
			RecordEntity recordEntity = new RecordEntity();
			recordEntity.setSourceId(registerEntity.getId()); //来源id
			recordEntity.setSourceBillCode(registerEntity.getBillCode()); //来源单据编号
			recordEntity.setOrgId(registerEntity.getOrgId());// 设备位置ID
			recordEntity.setOrgName(registerEntity.getOrgName());// 设备位置name
			recordEntity.setOrgCode(registerEntity.getOrgCode()); //设备位置名称
			recordEntity.setMaterialTypeId(registerEntity.getMaterialTypeId());//物料分类id
			recordEntity.setMaterialTypeCode(registerEntity.getMaterialTypeCode());
			recordEntity.setMaterialTypeName(registerEntity.getMaterialTypeName());
			recordEntity.setMaterialId(registerEntity.getMaterielId());//物料ID
			recordEntity.setMaterialCode(registerEntity.getMaterielCode());
			recordEntity.setMaterialName(registerEntity.getMaterielName());
			recordEntity.setSpec(registerEntity.getSpec());//规格
			recordEntity.setModel(registerEntity.getModel()); //型号
			recordEntity.setUnit(registerEntity.getUnit());//单位
			recordEntity.setRecordType(RecordTypeEnum.登记.getCode());
			recordEntity.setRecordDate(registerEntity.getPayDate());//操作日期  购买日期
			recordEntity.setNum(registerEntity.getNum()); //数量
			recordEntity.setState(1);//生效
			recordEntity.setEmployeeId(registerEntity.getEmployeeId());//经办人
			recordEntity.setEmployeeName(registerEntity.getEmployeeName());
			recordEntity.setPrice(registerEntity.getDetailPrice());//单价
			recordEntity.setMny(registerEntity.getPayPrice());//金额
			recordEntity.setSourceBillId(registerEntity.getId());
			recordService.saveOrUpdate(recordEntity);
		} catch (Exception e) {
			logger.error("e:{}",e);
			throw new RuntimeException(e);
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		try {
			LambdaQueryWrapper<RecordEntity> recordEntityWrapper = new LambdaQueryWrapper<>();
			recordEntityWrapper.eq(RecordEntity::getSourceBillId,billId);
			Integer count = recordMapper.selectCount(recordEntityWrapper);
			if(count>1){
				return CommonResponse.error("当前单子已存在下游数据，不能撤回");
			}else {
				return CommonResponse.success();
			}
		} catch (Exception e) {
			logger.error("e:{}",e);
			throw new RuntimeException(e);
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		try {
			recordService.delete(billId);
			//TODO
			return CommonResponse.success();
		} catch (Exception e) {
			logger.error("弃审后事件回调--- e,{}",e);
			throw new RuntimeException(e);
		}
	}

}
