package com.ejianc.business.jlprogress.progress.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
//import com.ejianc.business.jlprogress.progress.consumer.TransferVO;
//import com.ejianc.business.jlprogress.progress.bean.LightRuleEntity;
//import com.ejianc.business.jlprogress.progress.service.ILightRuleService;
//import com.ejianc.foundation.message.api.IPushMessageApi;
//import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class WarnFeignUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

//    @Value("${weChat.cgdd-agentid}")
//    private String cgddAgentid;
//
//    @Value("${weChat.cgdd-secret}")
//    private String cgddSecret;

    @Value("${common.env.base-host}")
    private String BaseHost;

//    @Autowired
//    private ILightRuleService lightRuleService;
//
//    @Autowired
//    private IPushMessageApi pushMessageApi;

    @Autowired
    private IZjkjProjectApi projectApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private DetailListUtil detailListUtil;

    public Map<Long, ProjectVO> getProjectMapByIds(List<Long> projectIds) {
        if(CollectionUtils.isEmpty(projectIds)){
            return new HashMap<>();
        }
        List<ProjectVO> projectList = this.queryProjectByIds(projectIds);
        Map<Long, ProjectVO> projectMap = projectList.stream().collect(Collectors.toMap(ProjectVO::getId, Function.identity()));
        return projectMap;
    }

    /**
     * 根据项目主键查询项目列表，之前接口返回较慢，超时
     * @param projectIds
     * @return
     */
    public List<ProjectVO> queryProjectByIds(List<Long> projectIds) {
        CommonResponse<JSONArray> resp = projectApi.queryProjectArray(projectIds);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectVO> result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectVO.class);
        return result;
    }

    /**
     * 根据条件查询中建科技下的所有项目，之前接口返回较慢，超时
     * @param param
     * @return
     */
    public List<ProjectVO> queryProjects(QueryParam param) {
        CommonResponse<JSONArray> resp = projectApi.queryArray(param);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectVO> result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectVO.class);
        return result;
    }

    /**
     * 查询当前组织下的所有启用和在建的项目，之前接口返回较慢，超时
     * @param orgId
     * @return
     */
    public List<ProjectVO> queryProjectsByOrgId(Long orgId) {
        CommonResponse<JSONArray> resp = projectApi.queryArrayByOrgId(orgId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectVO> result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectVO.class);
        return result;
    }

    /**
     * 根据id查询自定义档案
     * @param id
     * @return
     */
    public List<DefdocDetailVO> getDefDocListById(Long id){
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(id);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData();
    }

    /**
     * 根据集合和主键获取自定义档案明细
     * @param defList
     * @param id
     * @return
     */
    public DefdocDetailVO getDefDocDetail(List<DefdocDetailVO> defList, Long id) {
        if(CollectionUtils.isEmpty(defList) || id == null){
            return new DefdocDetailVO();
        }
        return defList.stream().filter(x->id.equals(x.getId())).findAny().orElse(new DefdocDetailVO());
    }

//    /**
//     * 提前查询项目Map和组织Map
//     * @param projectIds
//     * @return
//     */
//    public TransferVO getTransferVO(List<Long> projectIds) {
//        // 项目map
//        List<ProjectVO> projectList = this.queryProjectByIds(projectIds);
//        Map<Long, ProjectVO> projectMap = projectList.stream().collect(Collectors.toMap(ProjectVO::getId, Function.identity()));
//
//        Map<Long, OrgVO> orgMap = new HashMap<>();// 公司Map，key = id, value = vo
//        Map<Long, OrgVO> corpMap = new HashMap<>();// 分(子)公司Map，key = innerCode, value = vo
////        CommonResponse<OrgVO> rootResp = orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());// 获取根组织
//        CommonResponse<List<OrgVO>> rootResp = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
//
//        if(rootResp.isSuccess() && rootResp.getData() != null){
//            for(OrgVO root : rootResp.getData()){
//                CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(root.getId());// 获取根组织下子级
//                if(orgResp.isSuccess() && orgResp.getData() != null){
//                    List<OrgVO> orgList = orgResp.getData();
//                    orgMap.putAll(orgList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity())));
//                    corpMap.putAll(orgList.stream().filter(x-> x.getOrgType() == 2).collect(Collectors.toMap(OrgVO::getId, Function.identity())));
//                }
//            }
//        }
//        TransferVO transferVO = new TransferVO();
//        transferVO.setProjectMap(projectMap);
//        transferVO.setOrgMap(orgMap);
//        transferVO.setCorpMap(corpMap);
//        return transferVO;
//    }
//
//    /**
//     * 取最近组织亮灯规则
//     * @param typeList
//     * @return
//     */
//    public Map<String, LightRuleEntity> getLightRuleMapByTypes(List<Long> typeList, Map<Long, OrgVO> orgMap) {
//        if(CollectionUtils.isEmpty(typeList)){
//            return new HashMap<>();
//        }
//        QueryParam queryParam = new QueryParam();
//        //queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
//        //queryParam.getParams().put("industry_type_id", new Parameter(QueryParam.IN, typeList));
//        List<LightRuleEntity> lightRuleList = lightRuleService.queryList(queryParam);
//        detailListUtil.setDetailList(lightRuleList);
//
//        Map<Long, List<Long>> orgIdMap = new HashMap<>();// 父级下的子级
//        // 获取已创建亮灯规则组织本下Map，并排序，方便下级组织覆盖
//        List<Long> orgIds = lightRuleList.stream().map(LightRuleEntity::getOrgId).collect(Collectors.toList());
//        List<OrgVO> orgList = new ArrayList<>();
//        if(orgMap == null){
//            CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIds(orgIds);
//            if(orgResp.isSuccess() && orgResp.getData() != null){
//                orgList = orgResp.getData();
//            } else {
//                logger.error(orgResp.getMsg());
//            }
//        } else {
//            orgList = orgMap.values().stream().collect(Collectors.toList());
//        }
//        for(Long orgId : orgIds){
//            for(OrgVO org : orgList){
//                if(!orgIdMap.containsKey(orgId)){
//                    orgIdMap.put(orgId, new ArrayList<>());
//                }
//                if(org.getInnerCode().contains(String.valueOf(orgId))){
//                    orgIdMap.get(orgId).add(org.getId());
//                }
//            }
//        }
//
//        //升序排序
//        List<Map.Entry<Long, List<Long>>> list = new ArrayList(orgIdMap.entrySet());
//        Collections.sort(list,new Comparator<Map.Entry<Long, List<Long>>>() {
//            public int compare(Map.Entry<Long, List<Long>> o1, Map.Entry<Long, List<Long>> o2) {
//                Integer s1 = o1.getValue().size();
//                Integer s2 = o2.getValue().size();
//                return s1.compareTo(s2);
//            }
//        });
//
//        // 根据组织和行业类型赋值亮灯规则，取最近组织亮灯规则
//        Map<String, LightRuleEntity> lightRuleMap = new HashMap<>();// key-orgId|industryId，value-rule
//        for(Long orgId : orgIdMap.keySet()){
//            for(LightRuleEntity rule : lightRuleList){
//                if(rule.getOrgId().equals(orgId)){
//                    List<Long> childIds = orgIdMap.get(rule.getOrgId());
//                    for(Long childId : childIds) {
//                        lightRuleMap.put(childId + "|" + rule.getIndustryTypeId(), rule);
//                    }
//                }
//            }
//        }
//        return lightRuleMap;
//    }
//
//    /**
//     * 取最近组织亮灯规则
//     * @param typeList
//     * @return
//     */
//    public Map<String, LightRuleEntity> getLightRuleMapByTypes2(List<Long> typeList, Map<Long, OrgVO> orgMap) {
//        if(CollectionUtils.isEmpty(typeList)){
//            return new HashMap<>();
//        }
//        QueryParam queryParam = new QueryParam();
//        //queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
//        //queryParam.getParams().put("industry_type_id", new Parameter(QueryParam.IN, typeList));
//        List<LightRuleEntity> lightRuleList = lightRuleService.queryList(queryParam);
//        detailListUtil.setDetailList(lightRuleList);
//
//        Map<Long, List<Long>> orgIdMap = new HashMap<>();// 父级下的子级
//        // 获取已创建亮灯规则组织本下Map，并排序，方便下级组织覆盖
//        List<Long> orgIds = lightRuleList.stream().map(LightRuleEntity::getOrgId).collect(Collectors.toList());
//        List<OrgVO> orgList = new ArrayList<>();
//        if(orgMap == null){
//            CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentIds(orgIds);
//            if(orgResp.isSuccess() && orgResp.getData() != null){
//                orgList = orgResp.getData();
//            } else {
//                logger.error(orgResp.getMsg());
//            }
//        } else {
//            orgList = orgMap.values().stream().collect(Collectors.toList());
//        }
//        for(Long orgId : orgIds){
//            for(OrgVO org : orgList){
//                if(!orgIdMap.containsKey(orgId)){
//                    orgIdMap.put(orgId, new ArrayList<>());
//                }
//                if(org.getInnerCode().contains(String.valueOf(orgId))){
//                    orgIdMap.get(orgId).add(org.getId());
//                }
//            }
//        }
//
//        //升序排序
//        List<Map.Entry<Long, List<Long>>> list = new ArrayList(orgIdMap.entrySet());
//        Collections.sort(list,new Comparator<Map.Entry<Long, List<Long>>>() {
//            public int compare(Map.Entry<Long, List<Long>> o1, Map.Entry<Long, List<Long>> o2) {
//                Integer s1 = o1.getValue().size();
//                Integer s2 = o2.getValue().size();
//                return s1.compareTo(s2);
//            }
//        });
//
//        // 根据组织和行业类型赋值亮灯规则，取最近组织亮灯规则
//        Map<String, LightRuleEntity> lightRuleMap = new HashMap<>();// key-orgId|industryId，value-rule
//        for(Long orgId : orgIdMap.keySet()){
//            for(LightRuleEntity rule : lightRuleList){
//                if(rule.getOrgId().equals(orgId)){
//                    List<Long> childIds = orgIdMap.get(rule.getOrgId());
//                    for(Long childId : childIds) {
//                        lightRuleMap.put(childId + "|" + rule.getIndustryTypeId(), rule);
//                    }
//                }
//            }
//        }
//        return lightRuleMap;
//    }
//
//    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
//        this.sendMsg(messageType, user, msgType, subject, content, mobileUrl, null);
//    }
//
//    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl, String formurl) {
//        logger.info("发送消息开始！===========");
//        PushMsgParameter parameter = new PushMsgParameter();
//        List<String> channel = new ArrayList<>();
//        if (messageType.contains("sys")) {
//            // 系统消息
//            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
//        }
//        if (messageType.contains("smsg")) {
//            // 短信消息
//            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
//        }
//        if (messageType.contains("weChat")) {
//            // 系统消息
//            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
//        }
//        if (messageType.contains("dingding")) {
//            // 钉钉消息
//            channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
//        }
//        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");// 系统管理员特殊处理
//        String[] receivers = user.toArray(new String[user.size()]);
//        parameter.setReceivers(receivers);// 收信人
//        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
//        parameter.setMsgType(msgType);
//        parameter.setSubject(subject);// 标题
//        parameter.setContent(content);// 内容
//        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
//        parameter.setSendUserId(InvocationInfoProxy.getUserid());
//        if (messageType.contains("weChat")) {
//            JSONObject weixineeParams = new JSONObject();
//            weixineeParams.put("agentid", cgddAgentid);
//            weixineeParams.put("secret", cgddSecret);
////            weixineeParams.put("content", subject);
//            weixineeParams.put("msgtype", "textcard");
//            weixineeParams.put("title", "消息提醒");
//            weixineeParams.put("description", subject);
//            weixineeParams.put("url", mobileUrl);
//            weixineeParams.put("btntxt", "点击查看");
//
//            parameter.setWeixineeParams(weixineeParams);
//        }
//        if (messageType.contains("dingding")) {
//            JSONObject dingdingParams = new JSONObject();
//            dingdingParams.put("title", subject);
//            String ddcontent = subject + (",通知时间:"+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
//            dingdingParams.put("content", ddcontent);
//            dingdingParams.put("maurl", mobileUrl);
//            dingdingParams.put("pcurl", formurl);
//            parameter.setDingdingParams(dingdingParams);
//        }
//        try {
//            logger.info("发送信息{}", JSONObject.toJSONString(parameter));
//            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
//            if (result.isSuccess()) {
//                logger.error("消息发送成功---------------->" + result.getMsg());
//            } else {
//                logger.error("消息发送失败---------------->" + result.getMsg());
//            }
//        } catch (Exception e) {
//            logger.error("调用消息中心RPC服务异常--------------" + e);
//        }
//    }

    /**
     * 跨服务查询列表参照
     * @param url
     * @param queryParam
     * @return
     */
    public JSONArray queryList(String url, QueryParam queryParam) {
        JSONObject json = new JSONObject();
        try {
            String resp = HttpTookit.postByJson(BaseHost + url, JSONObject.toJSONString(queryParam));
            json = JSONObject.parseObject(resp);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        if(json.getInteger("code") != 0){
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject data = json.getJSONObject("data");
        if(data == null){
            return new JSONArray();
        }
        return data.getJSONArray("records");
    }
}
