package com.ejianc.business.jlprogress.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.vo.EntrustDetectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.EntrustDetectMapper;
import com.ejianc.business.jlprogress.quality.bean.EntrustDetectEntity;
import com.ejianc.business.jlprogress.quality.service.IEntrustDetectService;

import java.util.List;

/**
 * 质量检测-检测委托书
 * 
 * @author generator
 * 
 */
@Service("entrustDetectService")
public class EntrustDetectServiceImpl extends BaseServiceImpl<EntrustDetectMapper, EntrustDetectEntity> implements IEntrustDetectService{


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String INNER_BILL_CODE = "NJCWTS";//内部委托
    private static final String OUT_BILL_CODE = "WJCWTS";//外委


    @Autowired
    private SessionManager sessionManager;

    @Override
    public EntrustDetectVO saveOrUpdate(EntrustDetectVO saveOrUpdateVO) {
        EntrustDetectEntity entity = BeanMapper.map(saveOrUpdateVO, EntrustDetectEntity.class);
        if(StringUtils.isNotBlank(entity.getBillCode())){
            checkCode(entity);
        }else{
            BillCodeParam billCodeParam = BillCodeParam.build(entity.getEntrustType()==1?OUT_BILL_CODE:INNER_BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        EntrustDetectVO vo = BeanMapper.map(entity, EntrustDetectVO.class);
        return vo;
        }

        public void checkCode(EntrustDetectEntity entity) {
            QueryWrapper<EntrustDetectEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("bill_code", entity.getBillCode());
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("entrust_type", entity.getEntrustType());
            if(entity.getId() != null ){
                queryWrapper.ne("id", entity.getId());
            }
            List<EntrustDetectEntity> list = super.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                throw new BusinessException("委托检测书编号重复，请重新输入！");

            }
        }
}
