package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.finance.vo.ReimburseVO;
import com.ejianc.business.jlprogress.order.bean.OutStoreDetailEntity;
import com.ejianc.business.jlprogress.order.mapper.OutStoreDetailMapper;
import com.ejianc.business.jlprogress.order.service.IOutStoreDetailService;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.order.vo.OutStoreVO;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeDetailVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.OutStoreMapper;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.service.IOutStoreService;

import java.lang.annotation.Target;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单及运单-材料出库单-主表
 *
 * @author generator
 */
@Service("outStoreService")
public class OutStoreServiceImpl extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String CLCK_NUM_PARAM_CODE = "P-3HrsR50012";//【目标成本-现场施工费】管控【实际现场施工费】
    private static final String CLCK_MNY_PARAM_CODE = "P-4wl6550007";//【目标成本-现场施工费】管控【实际现场施工费】

    @Autowired
    private ITargetApi targetApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private OutStoreDetailMapper detailMapper;

    @Override
    public ParamsCheckVO checkParams(OutStoreVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【目标成本-现场施工费】管控【实际现场施工费】

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOS.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(OutStoreVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<OutStoreDetailVO> list = vo.getOutStoreDetailList();
        List<OutStoreDetailVO> resList = new ArrayList<>();
        resList = list.stream()
                // 过滤掉rowState为"del"的数据
                .filter(e -> !"del".equals(e.getRowState()))
                // 按照id进行分组，由于需要合并number和mny，这里需要使用Collectors.toMap来进行分组聚合
                .collect(Collectors.toMap(
                        OutStoreDetailVO::getMaterialId, // 获取key（id）
                        e -> e, // 获取value（整个Entity对象）
                        (e1, e2) -> { // 解决冲突的方法，即合并两个Entity实例
                            // 这里我们合并number和mny属性
                            e1.setMaterialNum(e1.getMaterialNum().add(e2.getMaterialNum()));
                            e1.setDetailStoreMny(e1.getDetailStoreMny().add(e2.getDetailStoreMny()));
                            return e1;
                        }
                )).values().stream()
                // 收集结果到一个新的List
                .collect(Collectors.toList());

        List<Long> MaterialIds = vo.getOutStoreDetailList().stream().map(OutStoreDetailVO::getMaterialId).collect(Collectors.toList());
        //1.查询目标成本 零件材料清单量
        CommonResponse<List<QueryTargetDataVO>> targetData = targetApi.getMaterialDataByMaterialIds(vo.getProjectId(), vo.getWbsId(), MaterialIds);
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标成本费用信息失败！");
        }
        //未编制目标成本或目标成本中没有零件材料清单量时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }

        // 项目+产品+物料确认目标成本值
        Map<String, QueryTargetDataVO> targetMap = targetDataList.stream().collect(Collectors.toMap(t -> t.getProjectId() + "-" + t.getProductId() + "-" + t.getMaterialId(), t -> t));

        // 查询项目+产品的所有出库量
        List<OutStoreDetailVO> detailList = detailMapper.getDetailByProjectAndWbs(vo.getProjectId(), vo.getWbsId(), vo.getId());
        Map<String, OutStoreDetailVO> totalMap = detailList.stream().collect(Collectors.toMap(detail -> detail.getProjectId() + "-" + detail.getWbsId() + "-" + detail.getMaterialId(), each -> each));

        CommonResponse<List<BillParamVO>> billParamNumByCode = paramConfigApi.getBillParamByCodeAndOrgId(CLCK_NUM_PARAM_CODE, vo.getOrgId());
        if (!billParamNumByCode.isSuccess() || null == billParamNumByCode.getData()) {
            logger.info(billParamNumByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> maxParamNumVOS = billParamNumByCode.getData();
        logger.info("【目标成本-零件材料清单量】管控【零件材料清单出库量】：" + JSONObject.toJSONString(maxParamNumVOS));
        for (BillParamVO maxParamVO : maxParamNumVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();// 高价
            List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型

            // 控制方式为none时不需要控制
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                continue;
            }
            BigDecimal roleValue = maxParamVO.getRoleValue().setScale(2, BigDecimal.ROUND_HALF_DOWN);
            for (OutStoreDetailVO detail : resList) {
                String key = vo.getProjectId() + "-" + vo.getWbsId() + "-" + detail.getMaterialId();
                QueryTargetDataVO target = targetMap.get(key);
                if (target == null) {
                    continue;
                }
                BigDecimal targetNum = target.getNum().setScale(2, BigDecimal.ROUND_HALF_DOWN);
                OutStoreDetailVO total = totalMap.get(key);
                BigDecimal num = detail.getMaterialNum().add(total == null ? BigDecimal.ZERO : total.getMaterialNum()).setScale(2, BigDecimal.ROUND_HALF_DOWN);

                if (target.getNum().multiply(roleValue.divide(BigDecimal.valueOf(100))).compareTo(num) < 0) {
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detail.getMaterialName() + " - " + detail.getSpec() + " 出库量超额预警");
                    paramsCheckDsVO.setWarnName("零件材料出库量超目标成本零件材料量");
                    StringBuffer stringBuffer = new StringBuffer();
                    String text = "超出数量：" + num + "-" + targetNum + "*" + roleValue + "=" + num.subtract(target.getNum().multiply(roleValue.divide(BigDecimal.valueOf(100)))).setScale(2, BigDecimal.ROUND_HALF_DOWN) + "吨";
                    String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                    stringBuffer.append("累计出库量：").append(num).append("吨")
                            .append("，目标成本量：").append(targetNum).append("吨")
                            .append("，管控比例：").append(roleValue).append("%，")
                            .append(redText);
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);
        }

        CommonResponse<List<BillParamVO>> billParamMnyByCode = paramConfigApi.getBillParamByCodeAndOrgId(CLCK_MNY_PARAM_CODE, vo.getOrgId());
        if (!billParamMnyByCode.isSuccess() || null == billParamMnyByCode.getData()) {
            logger.info(billParamMnyByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> maxParamMnyVOS = billParamMnyByCode.getData();
        logger.info("【目标成本-零件材料清单金额】管控【零件材料清单出库金额】：" + JSONObject.toJSONString(maxParamMnyVOS));
        for (BillParamVO maxParamVO : maxParamMnyVOS) {
            ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();// 高价
            List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
            paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型

            // 控制方式为none时不需要控制
            if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                continue;
            }
            BigDecimal roleValue = maxParamVO.getRoleValue().setScale(2, BigDecimal.ROUND_HALF_DOWN);

            for (OutStoreDetailVO detail : resList) {
                String key = vo.getProjectId() + "-" + vo.getWbsId() + "-" + detail.getMaterialId();
                QueryTargetDataVO target = targetMap.get(key);
                if (target == null) {
                    continue;
                }
                BigDecimal targetMny = target.getMny().setScale(2, BigDecimal.ROUND_HALF_DOWN);
                OutStoreDetailVO total = totalMap.get(key);
                BigDecimal mny = detail.getDetailStoreMny().add(total == null ? BigDecimal.ZERO : total.getDetailStoreMny()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                if (targetMny.multiply(roleValue.divide(BigDecimal.valueOf(100))).compareTo(mny) < 0) {
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detail.getMaterialName() + " - " + detail.getSpec() + " 出库金额超额预警");
                    paramsCheckDsVO.setWarnName("零件材料出库金额超目标成本零件材料金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    String text = "超出金额：" + mny + "-" + targetMny + "*" + roleValue + "=" + mny.subtract(targetMny.multiply(roleValue.divide(BigDecimal.valueOf(100)))).setScale(2, BigDecimal.ROUND_HALF_DOWN) + "元";
                    String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                    stringBuffer.append("累计出库金额：").append(mny).append("元")
                            .append("，目标成本金额：").append(targetMny).append("元")
                            .append("，管控比例：").append(roleValue).append("%，")
                            .append(redText);
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
            }
            paramsCheckVOMax.setDataSource(checkDsVOSMax);
            paramsCheckVOS.add(paramsCheckVOMax);
        }

        return paramsCheckVOS;
    }
}
