package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.vo.ProductOutRecordVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.ProductOutMapper;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.service.IProductOutService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单及运单-产品出库单-主表
 * 
 * @author generator
 * 
 */
@Service("productOutService")
public class ProductOutServiceImpl extends BaseServiceImpl<ProductOutMapper, ProductOutEntity> implements IProductOutService{

    @Override
    public ProductOutRecordVO queryProductOutRecord(Long contractId) {
        ProductOutRecordVO recordVO = new ProductOutRecordVO();
        LambdaQueryWrapper<ProductOutEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProductOutEntity::getContractId, contractId);
        queryWrapper.in(ProductOutEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ProductOutEntity> entities = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(entities)){
            recordVO.setProductOutVOList(BeanMapper.mapList(entities, ProductOutVO.class));
        }
        return recordVO;
    }

    @Override
    public Map<Long, ProductOutRecordVO> queryProductOutRecordByContractIdList(List<Long> ids) {
        LambdaQueryWrapper<ProductOutEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(ProductOutEntity::getContractId, ids);
        queryWrapper.in(ProductOutEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ProductOutEntity> entities = super.list(queryWrapper);
        Map<Long, ProductOutRecordVO> collectMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(entities) && entities.size() > 0){
            Map<Long, List<ProductOutEntity>> productOutMap  = entities.stream().collect(Collectors.groupingBy(ProductOutEntity::getContractId));
            for (Long contractId : productOutMap.keySet()) {
                ProductOutRecordVO productOutRecordVO = new ProductOutRecordVO();
                productOutRecordVO.setProductOutVOList(BeanMapper.mapList(productOutMap.get(contractId), ProductOutVO.class));
                collectMap.put(contractId, productOutRecordVO);
            }
        }
        return collectMap;
    }
}
