package com.ejianc.business.jlprogress.progress.service.impl;

import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.mapper.ExecPlanDetailMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 执行计划详情
 * 
 * @author generator
 * 
 */
@Service("execPlanDetailService")
public class ExecPlanDetailServiceImpl extends BaseServiceImpl<ExecPlanDetailMapper, ExecPlanDetailEntity> implements IExecPlanDetailService{

    @Override
    public Boolean writeBackFinishNum(String wbs, BigDecimal num, Boolean flag) {
        QueryParam param = new QueryParam();
        param.getParams().put("wbs", new Parameter(QueryParam.EQ, wbs));
        List<ExecPlanDetailEntity> list = super.queryList(param);
        for(ExecPlanDetailEntity vo : list){
            if(flag){
                vo.setFinishNum(ComputeUtil.safeAdd(vo.getFinishNum(), ComputeUtil.scale(num, 2)));
            } else {
                vo.setFinishNum(ComputeUtil.safeSub(vo.getFinishNum(), ComputeUtil.scale(num, 2)));
            }
            vo.setPercentComplete(ComputeUtil.bigDecimalPercent(vo.getFinishNum(), vo.getPlanNum(), 0).intValue());
        }
        if(CollectionUtil.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        return true;
    }
}
