package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.service.IPurchaseFeedbackService;
import com.ejianc.business.jlprogress.quality.vo.UnqualifiedReport;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@Controller
@RequestMapping("unqualifiedReport")
public class UnqualifiedReportController {
    @Autowired
    private IPurchaseFeedbackService service;

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        Page<UnqualifiedReport> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<UnqualifiedReport> RecordVOList = new ArrayList<>();
        if (param.getParams().containsKey("month")) {
            String month = (String) param.getParams().remove("month").getValue();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate currentMonth = LocalDate.parse(month + "-01", formatter);

            // 计算上月26日
            LocalDate startDate = currentMonth.minusMonths(1).withDayOfMonth(26);
            // 计算本月25日
            LocalDate endDate = currentMonth.withDayOfMonth(25);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

            param.getParams().put("feedbackDate", new Parameter("between", startDate.format(outputFormatter) + "," + endDate.format(outputFormatter)));
            QueryWrapper wrapper = changeToQueryWrapper(param);
            RecordVOList = service.queryUnqualifiedReport(page, wrapper);
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());

        return CommonResponse.success("查询列表数据成功！", res);
    }
}
