package com.ejianc.business.jlprogress.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.bean.AttendanceBindEntity;
import com.ejianc.business.jlprogress.labor.service.IAttendanceBindService;
import com.ejianc.business.jlprogress.labor.vo.AttendanceBindVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 考勤绑定关系
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("attendanceBind")
public class AttendanceBindController implements Serializable {
	private static final long serialVersionUID = -6954208506381134850L;
	private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Resource
	private IBillTypeApi billTypeApi;
	@Resource
	private IBillCodeApi billCodeApi;
	@Resource
	private IOrgApi iOrgApi;
	@Resource
	private IAttendanceBindService service;

	@Autowired
	private SessionManager sessionManager;


	/**
	 * 保存或更新
	 *
	 * @param saveOrUpdateVO 保存或更新vo
	 *
	 * @return {@link CommonResponse}<{@link AttendanceBindVO}>
	 */
	@PostMapping(value = "/saveOrUpdate")
	public CommonResponse<AttendanceBindVO> saveOrUpdate(@RequestBody AttendanceBindVO saveOrUpdateVO) {
		AttendanceBindEntity entity = BeanMapper.map(saveOrUpdateVO, AttendanceBindEntity.class);
		if (entity.getId() == null || entity.getId() == 0) {
			BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if (billCode.isSuccess()) {
				// entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			} else {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}
		service.saveOrUpdate(entity, false);
		AttendanceBindVO vo = BeanMapper.map(entity, AttendanceBindVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}


	/**
	 * 查询详情
	 *
	 * @param id id
	 *
	 * @return {@link CommonResponse}<{@link AttendanceBindVO}>
	 */
	@GetMapping(value = "/queryDetail")
	public CommonResponse<AttendanceBindVO> queryDetail(Long id) {
		AttendanceBindEntity entity = service.selectById(id);
		AttendanceBindVO vo = BeanMapper.map(entity, AttendanceBindVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}


	/**
	 * 批量删除单据
	 *
	 * @param vos vos
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	@PostMapping(value = "/delete")
	public CommonResponse<String> delete(@RequestBody List<AttendanceBindVO> vos) {
		if (ListUtil.isNotEmpty(vos)) {
			for (AttendanceBindVO vo : vos) {
				// 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
			}
		}
		service.removeByIds(vos.stream().map(AttendanceBindVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}


	/**
	 * 查询列表
	 *
	 * @param param 参数
	 *
	 * @return {@link CommonResponse}<{@link IPage}<{@link AttendanceBindVO}>>
	 */
	@PostMapping(value = "/queryList")
	public CommonResponse<IPage<AttendanceBindVO>> queryList(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
		UserContext userContextCache = sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		} else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if (5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if (CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if (CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<AttendanceBindEntity> page = service.queryPage(param, false);
		IPage<AttendanceBindVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AttendanceBindVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}


	/**
	 * 获取RPC数据
	 *
	 * @param resp      返回值
	 * @param isMustSuc 是否必须成功
	 * @param errMsg    失败提示
	 *
	 * @return {@link Object}
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if (isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}


	/**
	 * 参照
	 *
	 * @param pageNumber   页码
	 * @param pageSize     页面大小
	 * @param condition    条件
	 * @param searchObject 搜索对象
	 * @param searchText   搜索文本
	 *
	 * @return {@link CommonResponse}<{@link IPage}<{@link AttendanceBindVO}>>
	 */
	@GetMapping(value = "/refAttendanceBindData")
	public CommonResponse<IPage<AttendanceBindVO>> refAttendanceBindData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
		QueryParam param = new QueryParam();
		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
		}

		IPage<AttendanceBindEntity> page = service.queryPage(param, false);
		IPage<AttendanceBindVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AttendanceBindVO.class));

		return CommonResponse.success("查询参照数据成功！", pageData);
	}
}
