package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.vo.DeliveryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.ConnectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.DeliveryMapper;
import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单及运单-发货通知单-主表 
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{

    @Autowired
    private DeliveryMapper deliveryMapper;
    @Override
    public Integer selectCount(Long Id,Long contractId) {
        //根据合同id查询 合同累计发货次数
        LambdaQueryWrapper<DeliveryEntity> Wrapper = new LambdaQueryWrapper<>();
        Wrapper.eq(contractId!=null,DeliveryEntity::getContractId,contractId)
                .eq(DeliveryEntity::getDr,0);
        if(Id!=null){
            Wrapper.ne(DeliveryEntity::getId,Id);
        }
        Integer count = baseMapper.selectCount(Wrapper);

        return count;
    }

    @Override
    public DeliveryEntity selectNotActivated(Long Id,Long contractId) {
        List<Integer> list = new ArrayList<>();
        list.add(1);
        list.add(3);
        LambdaQueryWrapper<DeliveryEntity> Wrapper = new LambdaQueryWrapper<>();
        Wrapper.eq(contractId!=null,DeliveryEntity::getContractId,contractId)
                .eq(DeliveryEntity::getDr,0)
                .ne(DeliveryEntity::getId,Id) //排除本单据
                .notIn(DeliveryEntity::getBillState,list);

        DeliveryEntity one = this.getOne(Wrapper);
        return one;
    }

    @Override
    public List<DeliveryEntity> queryListWithCheckCount(QueryParam param) {
        Page<DeliveryEntity> page = new Page<>((long)param.getPageIndex(),(long)param.getPageSize());
        QueryWrapper<Object> wrapper = changeToQueryWrapper(param);
        List<DeliveryEntity> list = deliveryMapper.queryListWithCheckCount(page, wrapper);
        return list;
    }

    @Override
    public Map<Long, JSONObject> getDeliveryDataByContractIdList(List<Long> ids) {
        Map<Long, JSONObject> collectMap = new HashMap<>();
        List<DeliveryEntity> list = this.list(new LambdaQueryWrapper<DeliveryEntity>().in(DeliveryEntity::getBillState, Arrays.asList(1,3)).in(DeliveryEntity::getContractId, ids));
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Map<Long, List<DeliveryEntity>> deliveryDataMap  = list.stream().collect(Collectors.groupingBy(DeliveryEntity::getContractId));
            for (Long contractId : deliveryDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("deliveryNoticeList", deliveryDataMap.get(contractId));
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}
