package com.ejianc.business.jlprogress.order.service.impl;

import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.service.ISalesService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 订单及运单-销售订单主表
 * 
 * @author generator
 * 
 */
@Service("salesService")
public class SalesServiceImpl extends BaseServiceImpl<SalesMapper, SalesEntity> implements ISalesService{

    @Override
    public SalesListVO getContractSales(Long contractId) {
        QueryParam param = new QueryParam();
        //根据合同ID查询
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        //单据生效过滤
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        param.getOrderMap().put("orderDate", QueryParam.ASC);
        List<SalesEntity> salesList = super.queryList(param);
        List<SalesVO> list = BeanMapper.mapList(salesList, SalesVO.class);
        BigDecimal countMny = list.size() > 0 ? list.stream().filter(e -> null != e.getOrderMny()).map(SalesVO::getOrderMny).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
        SalesListVO salesListVO = new SalesListVO();
        salesListVO.setFirstOrderDate(CollectionUtils.isNotEmpty(salesList) && salesList.size() > 0 ? salesList.get(0).getOrderDate() : null);
        salesListVO.setCountMny(countMny);
        salesListVO.setSalesList(list);
        return salesListVO;
    }

    @Override
    public Map<Long, SalesListVO> getContractSalesByContractIdList(List<Long> contractIdList) {
        QueryParam param = new QueryParam();
        //根据合同ID查询
        param.getParams().put("contractId", new Parameter(QueryParam.IN, contractIdList));
        //单据生效过滤
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        param.getOrderMap().put("orderDate", QueryParam.ASC);
        List<SalesEntity> salesList = super.queryList(param);
        List<SalesVO> list = BeanMapper.mapList(salesList, SalesVO.class);
        Map<Long, SalesListVO> returnMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Map<Long, List<SalesVO>> collectMap = list.stream().collect(Collectors.groupingBy(SalesVO::getContractId));
            for (Long contractId : collectMap.keySet()) {
                List<SalesVO> salesVOList = collectMap.get(contractId);
                BigDecimal countMny = salesVOList.size() > 0 ? salesVOList.stream().filter(e -> null != e.getOrderMny()).map(SalesVO::getOrderMny).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                SalesListVO salesListVO = new SalesListVO();
                salesListVO.setFirstOrderDate(CollectionUtils.isNotEmpty(salesVOList) && salesVOList.size() > 0 ? salesVOList.get(0).getOrderDate() : null);
                salesListVO.setCountMny(countMny);
                salesListVO.setSalesList(salesVOList);
                salesListVO.setContractId(contractId);
                returnMap.put(contractId, salesListVO);
            }
        }
        return returnMap;
    }
}
