package com.ejianc.business.jlprogress.quality.controller;

import java.io.Serializable;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.asset.vo.RecordVO;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.vo.PriceVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmDetailEntity;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmDetailService;
import com.ejianc.business.jlprogress.quality.vo.OutPurchaseProductCountVO;
import com.ejianc.business.jlprogress.quality.vo.UnqualifiedReport;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmEntity;
import com.ejianc.business.jlprogress.quality.service.IOutsourceConfirmService;
import com.ejianc.business.jlprogress.quality.vo.OutsourceConfirmVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 质量检测-外协检验确认单-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outsourceConfirm")
public class OutsourceConfirmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "OUTSOURCE_CONFIRM_CODE";//此处需要根据实际修改

    @Autowired
    private IOutsourceConfirmService service;

    @Autowired
    private IOutsourceConfirmDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> saveOrUpdate(@RequestBody OutsourceConfirmVO saveOrUpdateVO) {
        OutsourceConfirmEntity entity = BeanMapper.map(saveOrUpdateVO, OutsourceConfirmEntity.class);
        LambdaQueryWrapper<OutsourceConfirmEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OutsourceConfirmEntity::getBillCode,saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(OutsourceConfirmEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(OutsourceConfirmEntity::getId,saveOrUpdateVO.getId());
        }
        List<OutsourceConfirmEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("单据编码已存在！");
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        OutsourceConfirmVO vo = BeanMapper.map(entity, OutsourceConfirmVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutsourceConfirmVO> queryDetail(Long id) {
    	OutsourceConfirmEntity entity = service.selectById(id);
    	OutsourceConfirmVO vo = BeanMapper.map(entity, OutsourceConfirmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutsourceConfirmVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutsourceConfirmVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutsourceConfirmVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        //外购确认单号、供货单位、采购员、产品类别、产品名称
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);
        IPage<OutsourceConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutsourceConfirmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        //外购确认单号、供货单位、采购员、产品类别、产品名称
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("productName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<OutsourceConfirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<OutsourceConfirmVO> resDatas = BeanMapper.mapList(list, OutsourceConfirmVO.class);
        for (OutsourceConfirmVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("OutsourceConfirm-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refOutsourceConfirmData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutsourceConfirmVO>> refOutsourceConfirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutsourceConfirmEntity> page = service.queryPage(param,false);
        IPage<OutsourceConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutsourceConfirmVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 外协采购产品统计
     * @param param
     * @return
     */
    @RequestMapping(value = "/outPurchaseProductCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutPurchaseProductCountVO>> outPurchaseProductCount(@RequestBody QueryParam param) {
        //获取年月
        if (param.getParams().get("month") == null){
            return CommonResponse.success();
        }
        String monthStr = param.getParams().get("month").getValue().toString();
        //分别获取年、月
        int year = Integer.parseInt(monthStr.substring(0, 4));
        int month = Integer.parseInt(monthStr.substring(5));
        // 构建上个月的第26日的日期
        LocalDate lastMonth26th = LocalDate.of(year, month-1, 26);
        // 构建本月的第25日的日期
        LocalDate thisMonth25th = LocalDate.of(year, month, 25);

        String between = lastMonth26th +","+thisMonth25th;
        param.getParams().put("confirmDate", new Parameter(QueryParam.BETWEEN, between));
        param.getParams().remove("month");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        QueryWrapper wrapper = changeToQueryWrapper(param);

        List<OutPurchaseProductCountVO> outPurchaseProductCount = service.getOutPurchaseProductCount(wrapper);

        Page<RecordVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        IPage<OutPurchaseProductCountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(outPurchaseProductCount);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/outPurchaseProductCountExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void outPurchaseProductCountExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String monthStr = param.getParams().get("month").getValue().toString();
        //分别获取年、月
        int year = Integer.parseInt(monthStr.substring(0, 4));
        int month = Integer.parseInt(monthStr.substring(5));
        // 构建上个月的第26日的日期
        LocalDate lastMonth26th = LocalDate.of(year, month-1, 26);
        // 构建本月的第25日的日期
        LocalDate thisMonth25th = LocalDate.of(year, month, 25);

        String between = lastMonth26th +","+thisMonth25th;
        param.getParams().put("confirmDate", new Parameter(QueryParam.BETWEEN, between));
        param.getParams().remove("month");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        QueryWrapper wrapper = changeToQueryWrapper(param);

        List<OutPurchaseProductCountVO> outPurchaseProductCount = service.getOutPurchaseProductCount(wrapper);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", outPurchaseProductCount);
        ExcelExport.getInstance().export("OutPurchaseProductCount-export.xlsx", beans, response);
    }
}
