package com.ejianc.business.jlprogress.quality.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.jlprogress.quality.bean.SupplyConfirmDetailEntity;
import com.ejianc.business.jlprogress.quality.service.*;
import com.ejianc.business.jlprogress.quality.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.SupplyConfirmEntity;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;
import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * 质量检测-物资供货确认单-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("supplyConfirm")
public class SupplyConfirmController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPLY_CONFIRM_CODE";//此处需要根据实际修改

    @Autowired
    private ISupplyConfirmService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISupplyDetailService supplyDetailService;

    @Autowired
    private IDetectReportDetailService reportDetailService;

    @Autowired
    private IDisposeService disposeService;

    @Autowired
    private IMatCheckDetailService matCheckDetailService;

    @Autowired
    private IPurchaseFeedbackService purchaseFeedbackService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplyConfirmVO> saveOrUpdate(@RequestBody SupplyConfirmVO saveOrUpdateVO) {
        SupplyConfirmEntity entity = BeanMapper.map(saveOrUpdateVO, SupplyConfirmEntity.class);

        if (StringUtils.isEmpty(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        QueryWrapper<SupplyConfirmEntity> wrapper = new QueryWrapper<SupplyConfirmEntity>();
        wrapper.eq("bill_code", entity.getBillCode());
        wrapper.ne("id", entity.getId());
        SupplyConfirmEntity selectEntity = service.getOne(wrapper);
        if (selectEntity != null) {
            return CommonResponse.error("确认编码重复，保存失败！");
        }
        service.saveOrUpdate(entity, false);
        SupplyConfirmVO vo = BeanMapper.map(entity, SupplyConfirmVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplyConfirmVO> queryDetail(Long id) {
        SupplyConfirmEntity entity = service.selectById(id);
        SupplyConfirmVO vo = BeanMapper.map(entity, SupplyConfirmVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplyConfirmVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplyConfirmVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SupplyConfirmVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplyConfirmVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("supplyCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SupplyConfirmEntity> page = service.queryPage(param, false);
        IPage<SupplyConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplyConfirmVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SupplyConfirmEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SupplyConfirmVO> resDatas = BeanMapper.mapList(list, SupplyConfirmVO.class);
        for (SupplyConfirmVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("SupplyConfirm-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSupplyConfirmData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplyConfirmVO>> refSupplyConfirmData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplyConfirmEntity> page = service.queryPage(param, false);
        IPage<SupplyConfirmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplyConfirmVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/materialPurchaseList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> materialPurchaseList(@RequestBody QueryParam param) {

        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            // 获取上个月的日期
            Month lastMonth = date.minusMonths(1).getMonth();
            Month month = date.getMonth();
            int year = date.minusMonths(1).getYear();

            // 获取上个月的26日
            startOfMonth = LocalDate.of(year, lastMonth, 26).toString();
            // 获取本月的25日
            endOfMonth = LocalDate.of(year, month, 25).toString();
            param.getParams().remove("month");
            //这个写法。。。。。
            param.getParams().put("confirmDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<WorkTimeReport> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<MaterialPurchaseVO> list=null;
        if (param.getParams().containsKey("confirmDate")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = service.materialPurchaseList(page, wrapper);
        }
//        List<MaterialPurchaseVO> list = service.materialPurchaseList();

        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
}
