package com.ejianc.business.jlprogress.progress.bean;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.vo.YearPlanDetailVO;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 年计划详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_year_plan_detail")
public class YearPlanDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;


    @TableField(value="task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value="node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value="employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value="employee_name")
    private String employeeName; // 负责人名称
    @TableField(value="plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value="unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value="resource_name")
    private String resourceName; // 资源名称
    @TableField(value="type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value="type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value="need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value="plan_state")
    private Integer planState; // 任务标识
    @TableField(value="source_bid")
    private Long sourceBid; // 执行计划明细主键
    @TableField(value="source_id")
    private Long sourceId; // 执行计划单据主键

    @TableField(exist=false)
    private List<YearPlanDetailEntity> children = new ArrayList<>();// 子任务

    @TableField(value="predict_finish")
    private Date predictFinish; // 预测完成日期

    public Date getPredictFinish() {
        return predictFinish;
    }

    public void setPredictFinish(Date predictFinish) {
        this.predictFinish = predictFinish;
    }

    public List<YearPlanDetailEntity> getChildren() {
        return children;
    }

    public void setChildren(List<YearPlanDetailEntity> children) {
        this.children = children;
    }


    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }


    /**
     * entity to vo
     */
    public static YearPlanDetailVO convertEntityToVo(YearPlanDetailEntity entity) {
        YearPlanDetailVO progressDetailVo = new YearPlanDetailVO();
        progressDetailVo.setUid(entity.getId().toString());
        progressDetailVo.setManual(entity.getManual());
        progressDetailVo.setActualDuration(entity.getActualDuration());
        progressDetailVo.setDuration(entity.getDuration());
        progressDetailVo.setPercentComplete(entity.getPercentComplete());
        progressDetailVo.setDepartment(entity.getDepartment());
        progressDetailVo.setProjectUID(entity.getProjectId());
        progressDetailVo.setMilestone(entity.getMilestone());
        progressDetailVo.setFinish(entity.getFinish());
        progressDetailVo.setConstraintType(entity.getConstraintType());
        progressDetailVo.setPrincipal(entity.getPrincipal());
        progressDetailVo.setParentTaskUID(entity.getParentId() + "");
        progressDetailVo.setWbs(entity.getWbs());
        if (StringUtils.isNotBlank(entity.getAssignments())) {
            progressDetailVo.setAssignments(JSON.parseArray(entity.getAssignments()));
        }
        progressDetailVo.setStart(entity.getStart());
        progressDetailVo.setOutlineLevel(entity.getOutlineLevel());
        progressDetailVo.setOutlineNumber(entity.getOutlineNumber());
        progressDetailVo.setCritical(entity.getCritical());
        progressDetailVo.setNote(entity.getNotes());
        progressDetailVo.setSummary(entity.getSummary());
        progressDetailVo.setActualFinish(entity.getActualFinish());
        progressDetailVo.setName(entity.getName());
        progressDetailVo.setId(entity.getTid());
        progressDetailVo.setCode(entity.getCode());
        progressDetailVo.setStructCode(entity.getStructCode());
        progressDetailVo.setWeight(entity.getWeight());
        progressDetailVo.setFixedDate(entity.getFixedDate());
        progressDetailVo.setWork(entity.getWork());
        progressDetailVo.setConstraintDate(entity.getConstraintDate());
        if(StringUtils.isNotBlank(entity.getPredecessorLink())) {
            progressDetailVo.setPredecessorLink(JSON.parseArray(entity.getPredecessorLink()));
        }
        progressDetailVo.setPriority(entity.getPriority());
        progressDetailVo.setActualStart(entity.getActualStart());

        progressDetailVo.setTaskLine(entity.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailVo.setNodeLevel(entity.getNodeLevel()); // 节点级别
        progressDetailVo.setEmployeeId(entity.getEmployeeId()); // 负责人主键
        progressDetailVo.setEmployeeName(entity.getEmployeeName()); // 负责人名称
        progressDetailVo.setPlanNum(entity.getPlanNum()); // 工程量
        progressDetailVo.setUnit(entity.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailVo.setResourceName(entity.getResourceName()); // 资源名称
        progressDetailVo.setType(entity.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailVo.setTypeUnit(entity.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailVo.setNeedNum(entity.getNeedNum()); // 需求量
        progressDetailVo.setPlanState(entity.getPlanState()); //任务标识
        progressDetailVo.setSourceId(entity.getSourceId()); //主表主键
        progressDetailVo.setSourceBid(entity.getSourceBid()); //子表主键
        progressDetailVo.setPredictFinish(entity.getPredictFinish());// 预测完成时间
        progressDetailVo.setWbsParent(entity.getWbsParent());
        progressDetailVo.setUnitName(entity.getUnitName());
        return progressDetailVo;
    }

    /**
     * vo to entity
     */
    public static YearPlanDetailEntity convertVoToEntity(YearPlanDetailVO vo) {
        YearPlanDetailEntity progressDetailEntity = new YearPlanDetailEntity();
        if(StringUtils.isNotBlank(vo.getUid())) {
            progressDetailEntity.setId(Long.parseLong(vo.getUid()));
        }
        progressDetailEntity.setManual(vo.getManual());
        progressDetailEntity.setActualDuration(vo.getActualDuration());
        progressDetailEntity.setDuration(vo.getDuration());
        progressDetailEntity.setPercentComplete(vo.getPercentComplete());
        progressDetailEntity.setDepartment(vo.getDepartment());
        progressDetailEntity.setProjectId(vo.getProjectUID());
        progressDetailEntity.setMilestone(vo.getMilestone());
        progressDetailEntity.setFinish(vo.getFinish());
        progressDetailEntity.setConstraintType(vo.getConstraintType());
        progressDetailEntity.setPrincipal(vo.getPrincipal());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            progressDetailEntity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        progressDetailEntity.setWbs(vo.getWbs());
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            progressDetailEntity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        progressDetailEntity.setStart(vo.getStart());
        progressDetailEntity.setOutlineLevel(vo.getOutlineLevel());
        progressDetailEntity.setOutlineNumber(vo.getOutlineNumber());
        progressDetailEntity.setCritical(vo.getCritical());
        progressDetailEntity.setNotes(vo.getNote());
        progressDetailEntity.setSummary(vo.getSummary());
        progressDetailEntity.setActualFinish(vo.getActualFinish());
        progressDetailEntity.setName(vo.getName());
        progressDetailEntity.setTid(vo.getId());
        progressDetailEntity.setCode(vo.getCode());
        progressDetailEntity.setStructCode(vo.getStructCode());
        progressDetailEntity.setWeight(vo.getWeight());
        progressDetailEntity.setFixedDate(vo.getFixedDate());
        progressDetailEntity.setWork(vo.getWork());
        progressDetailEntity.setConstraintDate(vo.getConstraintDate());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            progressDetailEntity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        progressDetailEntity.setPriority(vo.getPriority());
        progressDetailEntity.setActualStart(vo.getActualStart());

        progressDetailEntity.setTaskLine(vo.getTaskLine()); // 任务条线(手续线、设计线、建造线、招采线)
        progressDetailEntity.setNodeLevel(vo.getNodeLevel()); // 节点级别
        progressDetailEntity.setEmployeeId(vo.getEmployeeId()); // 负责人主键
        progressDetailEntity.setEmployeeName(vo.getEmployeeName()); // 负责人名称
        progressDetailEntity.setPlanNum(vo.getPlanNum()); // 工程量
        progressDetailEntity.setUnit(vo.getUnit()); // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
        progressDetailEntity.setResourceName(vo.getResourceName()); // 资源名称
        progressDetailEntity.setType(vo.getType()); // 资源类型(劳动力、材料、机械)
        progressDetailEntity.setTypeUnit(vo.getTypeUnit()); // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
        progressDetailEntity.setNeedNum(vo.getNeedNum()); // 需求量
        progressDetailEntity.setPlanState(vo.getPlanState()); //任务标识
        progressDetailEntity.setSourceId(vo.getSourceId()); //主表主键
        progressDetailEntity.setSourceBid(vo.getSourceBid()); //子表主键
        progressDetailEntity.setPredictFinish(DateUtil.setHours(vo.getPredictFinish(), 17));// 预测完成时间
        progressDetailEntity.setWbsParent(vo.getWbsParent());
        progressDetailEntity.setUnitName(vo.getUnitName());
        return progressDetailEntity;
    }
    
}
