package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.FinishedCheckMapper;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;

import java.util.List;

/**
 * 质量检测-成品检测记录
 * 
 * @author generator
 * 
 */
@Service("finishedCheckService")
public class FinishedCheckServiceImpl extends BaseServiceImpl<FinishedCheckMapper, FinishedCheckEntity> implements IFinishedCheckService{

    @Autowired
    private IDayFillService fillService;

    @Override
    public Boolean validateFill(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        List<DayFillEntity> list = fillService.queryList(param);
        if(CollectionUtil.isNotEmpty(list)){
            throw new BusinessException("存在未生效计划反馈，不允许操作！");
        }
        return true;
    }
}
