package com.ejianc.business.jlprogress.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.asset.bean.HandleDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 浦江设备管理-处置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asset_handle")
public class HandleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 设备位置ID
    @TableField(value="org_code")
    private String orgCode; // 设备位置code
    @TableField(value="org_name")
    private String orgName; // 设备位置名称
    @TableField(value="handle_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 处置日期
    @TableField(value="handle_mny")
    private BigDecimal handleMny; // 处置资金
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="handleDetailService", pidName = "handleId")
    private List<HandleDetailEntity> handleDetailList = new ArrayList<>(); // 浦江设备管理-处置详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<HandleDetailEntity> getHandleDetailList() {
        return handleDetailList;
    }

    public void setHandleDetailList(List<HandleDetailEntity> handleDetailList) {
        this.handleDetailList = handleDetailList;
    }
}
