package com.ejianc.business.jlprogress.order.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.ProductOutRecordVO;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/api/orderApi/")
public class OrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalesService salesService;
    @Autowired
    private IProductOutService productOutService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryService deliveryService;


    /**
     * 获取合同登记下游业务 开票记录、回款记录信息
     */
    @GetMapping(value = "getOrderDataByContractId")
    CommonResponse<JSONObject> getOrderDataByContractId(@RequestParam Long contractId) {
        JSONObject returnObject = new JSONObject();

        logger.info("接收参数-contractId-{}", contractId);
        SalesListVO salesListVO = salesService.getContractSales(contractId);
        logger.info("获取到销售订单信息-" + JSONObject.toJSONString(salesListVO));
        returnObject.put("firstOrderDate", salesListVO.getFirstOrderDate());
        returnObject.put("salesList", salesListVO.getSalesList());

        ProductOutRecordVO productOutRecordVO = productOutService.queryProductOutRecord(contractId);
        logger.info("获取到发货记录信息-" + JSONObject.toJSONString(productOutRecordVO));
        returnObject.put("productOutVOList", productOutRecordVO.getProductOutVOList());
        if (null != productOutRecordVO && CollectionUtils.isNotEmpty(productOutRecordVO.getProductOutVOList()) && productOutRecordVO.getProductOutVOList().size() > 0) {
            returnObject.put("productOutState", "已发货");
        } else {
            returnObject.put("productOutState", "未发货");
        }

        JSONObject checkData = checkService.getCheckDataByContractId(contractId);
        returnObject.put("checkList", checkData.get("checkList"));
        returnObject.put("checkState", checkData.get("checkState"));

        return CommonResponse.success(returnObject);
    }

    /**
     * 获取合同登记下游业务 开票记录、回款记录信息、发货通知单
     */
    @PostMapping(value = "getOrderDataByContractIdList")
    CommonResponse<JSONObject> getOrderDataByContractIdList(@RequestBody List<Long> ids) {
        JSONObject returnObject = new JSONObject();

        logger.info("接收参数-ids-{}", JSONObject.toJSONString(ids));
        //销售订单
        Map<Long, SalesListVO> contractSalesMap = salesService.getContractSalesByContractIdList(ids);
        //产品出库单
        Map<Long, ProductOutRecordVO> productOutRecordMap = productOutService.queryProductOutRecordByContractIdList(ids);
        //验收单
        Map<Long, JSONObject> checkDataMap = checkService.getCheckDataByContractIdList(ids);
        //发货通知单
        Map<Long, JSONObject> deliveryDataMap = deliveryService.getDeliveryDataByContractIdList(ids);

        for (Long contractId : ids) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("contractId", contractId);
            if (contractSalesMap.containsKey(contractId)) {
                dataObject.put("firstOrderDate", contractSalesMap.get(contractId).getFirstOrderDate());
                dataObject.put("salesList", contractSalesMap.get(contractId).getSalesList());
            }
            if (productOutRecordMap.containsKey(contractId)) {
                dataObject.put("productOutVOList", productOutRecordMap.get(contractId).getProductOutVOList());
                dataObject.put("productOutState", "已发货");
            }
            if (checkDataMap.containsKey(contractId)) {
                dataObject.put("checkList", checkDataMap.get(contractId).get("checkList"));
                dataObject.put("checkState", checkDataMap.get(contractId).get("checkState"));
            }
            if (deliveryDataMap.containsKey(contractId)) {
                dataObject.put("deliveryNoticeList", deliveryDataMap.get(contractId).get("deliveryNoticeList"));
            }
            returnObject.put(contractId.toString(), dataObject);
        }
        logger.info("获得合同下订单信息-returnObject-{}", JSONObject.toJSONString(returnObject));

        return CommonResponse.success(returnObject);
    }

    @PostMapping(value = "getSalesByContractIds")
    CommonResponse<Map<Long, SalesListVO>> getSalesByContractIds(@RequestBody List<Long> ids) {
        logger.info("执行");
        logger.info(salesService.getContractSalesByContractIdList(ids).get(0).getContractId().toString());
        return CommonResponse.success(salesService.getContractSalesByContractIdList(ids));
    }
}
