package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Arrays;
import java.util.Map;

@Service("sales")
public class SalesBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private ISalesService service;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private SalesMapper mapper;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写项目信息-项目阶段
        SalesEntity entity = service.getById(billId);

        LambdaQueryWrapper<SalesEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SalesEntity::getProjectId, entity.getProjectId());
        lambdaQueryWrapper.in(SalesEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(SalesEntity::getId, billId);

        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.生产阶段.getCode(), entity.getProjectId(), entity.getId(), service.list(lambdaQueryWrapper).size() > 0 ? true : false, true);
        // 回写合同客户
        mapper.changeContractCustomer(entity.getContractId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCustomerCode());
        // 回写项目客户
        mapper.changeProjectCustomer(entity.getProjectId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCustomerCode());

        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return bpmBackCheck(billId, state, billTypeCode);
    }


    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        //回写项目信息-项目阶段
        SalesEntity entity = service.getById(billId);

        LambdaQueryWrapper<SalesEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SalesEntity::getProjectId, entity.getProjectId());
        lambdaQueryWrapper.in(SalesEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(SalesEntity::getId, billId);

        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.生产阶段.getCode(), entity.getProjectId(), entity.getId(), service.list(lambdaQueryWrapper).size() > 0 ? true : false, false);
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }

}
