package com.ejianc.business.jlprogress.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanChangeEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanDetailChangeEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.CommonHelper;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanChangeMapper;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanDetailChangeMapper;
import com.ejianc.business.jlprogress.progress.service.*;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanChangeVO;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 总计划变更
 *
 * @author generator
 */
@Service("totalPlanChangeService")
public class TotalPlanChangeServiceImpl extends BaseServiceImpl<TotalPlanChangeMapper, TotalPlanChangeEntity> implements ITotalPlanChangeService {


    @Autowired
    private TotalPlanChangeMapper changeMapper;
    @Autowired
    private TotalPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private ITotalPlanDetailChangeService detailChangeService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ITotalPlanDetailService totalPlanDetailService;
//    @Autowired
//    private IYearPlanService yearPlanService;
//    @Autowired
//    private IMonthPlanService monthPlanService;
//    @Autowired
//    private IWeekPlanService weekPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<TotalPlanChangeVO> saveOrUpdate(TotalPlanChangeVO saveOrUpdateVO) {
//        checkBill(saveOrUpdateVO.getProjectId());
        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanChangeEntity progressEntity = null;
        // 判断是否发生变更时间
        Integer changeType = CommonHelper.tansferChange(saveOrUpdateVO.getTasks());
        saveOrUpdateVO.setChangeType(changeType);
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, TotalPlanChangeEntity.class);
            changeMapper.updateById(progressEntity);

            //子表
            List<TotalPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<TotalPlanDetailChangeVO> saveVOList = new ArrayList<TotalPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if (saveOrUpdateVO.getImportFlag()) {
                    detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }
                for (TotalPlanDetailChangeVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        TotalPlanDetailChangeEntity progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.insert(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        TotalPlanDetailChangeEntity progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.updateById(progressDetailEntity);
                    }
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            //子表删除
            List<TotalPlanDetailChangeVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (TotalPlanDetailChangeVO progressDetailVo : delDetailList) {
                    detailChangeMapper.deleteById(progressDetailVo.getUid());
                }
            }

        } else { //新增
            TotalPlanEntity totalPlanEntity = totalPlanService.selectById(saveOrUpdateVO.getTotalId());
            if (totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING) {
                throw new BusinessException("存在变更中单据，不允许保存!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, TotalPlanChangeEntity.class);
            progressEntity.setId(masterPkId);
            changeMapper.insert(progressEntity);

            //子表
            List<TotalPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<TotalPlanDetailChangeVO> saveVOList = new ArrayList<TotalPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<TotalPlanDetailChangeEntity> planEntityList = new ArrayList<>();
                for (TotalPlanDetailChangeVO progressDetailVo : saveVOList) {
                    TotalPlanDetailChangeEntity progressDetailEntity = TotalPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
//                    progressDetailEntity.setId(null);
//                    detailChangeMapper.insert(progressDetailEntity);
                    planEntityList.add(progressDetailEntity);
                }
                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }
            LambdaUpdateWrapper<TotalPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(TotalPlanEntity::getChangeId, progressEntity.getId());
            updateWrapper.set(TotalPlanEntity::getChangeStatus, PlanConstant.CHANGE_ING);
            updateWrapper.set(TotalPlanEntity::getChangeCode, progressEntity.getBillCode());
            updateWrapper.eq(TotalPlanEntity::getId, progressEntity.getTotalId());
            totalPlanService.update(updateWrapper);
        }
        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public TotalPlanChangeVO queryDetail(Long id) {
        TotalPlanChangeEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<TotalPlanDetailChangeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<TotalPlanDetailChangeEntity> progressDetailList = detailChangeService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        TotalPlanChangeVO progressVo = BeanMapper.map(progressEntity, TotalPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<TotalPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (TotalPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                TotalPlanDetailChangeVO changeVO = TotalPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public TotalPlanChangeVO queryDetailChange(Long id) {
        TotalPlanEntity progressEntity = totalPlanService.selectById(id);
        TotalPlanChangeVO vo = BeanMapper.map(progressEntity, TotalPlanChangeVO.class);
        //查询子表
        QueryWrapper<TotalPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<TotalPlanDetailEntity> progressDetailList = totalPlanDetailService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<TotalPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (TotalPlanDetailEntity progressDetailEntity : progressDetailList) {
                TotalPlanDetailChangeEntity changeDetailEntity = BeanMapper.map(progressDetailEntity, TotalPlanDetailChangeEntity.class);
                changeDetailEntity.setTotalId(changeDetailEntity.getProgressId());
                changeDetailEntity.setTotalBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                changeDetailEntity.setLastStart(DateUtil.setHours(progressDetailEntity.getStart(), 8));
                changeDetailEntity.setLastFinish(DateUtil.setHours(progressDetailEntity.getFinish(), 17));
                TotalPlanDetailChangeVO changeVO = TotalPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setTotalId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(vo.getChangeVersion() + 1);
        vo.setChangeType(PlanConstant.CHANGE_TYPE_NO);
        return vo;
    }

    @Override
    public void deleteTotalPlan(List<TotalPlanChangeVO> vos) {
        for (TotalPlanChangeVO vo : vos) {
            TotalPlanChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<TotalPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(TotalPlanEntity::getChangeStatus, PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(TotalPlanEntity::getChangeStatus, PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(TotalPlanEntity::getId, changeEntity.getTotalId());
            totalPlanService.update(updateWrapper);
            super.removeById(vo, false);
            detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<TotalPlanChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<TotalPlanChangeEntity> changeEntities = baseMapper.selectList(new QueryWrapper<TotalPlanChangeEntity>()
                .eq("total_id", id)
                .in("bill_state", billStatus).orderByDesc("approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<TotalPlanChangeVO> changeVos = BeanMapper.mapList(changeEntities, TotalPlanChangeVO.class);
            for (TotalPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(TotalPlanChangeVO vo) {
        Long projectId = vo.getProjectId();
        List<Long> ids = vo.getIds();
        LambdaQueryWrapper<TotalPlanDetailEntity> ylambd = new LambdaQueryWrapper<>();
        // 默认查询本下，解决父级删除和新增下级，只变更本计划数据，校验不通过的问题
        ylambd.and(x->x.in(TotalPlanDetailEntity::getId, ids).or().in(TotalPlanDetailEntity::getParentId, ids));
        List<TotalPlanDetailEntity> list = totalPlanDetailService.list(ylambd);
        Boolean isDel = true;// 默认删除
        if ("addLower".equals(vo.getDelFlag())){
            isDel = null;// 新增下级
        }
        return commonHelper.transferDelIds(list, projectId, PlanConstant.TOTAL_PLAN, isDel);
    }

//    private void checkBill(Long project) {
//        LambdaQueryWrapper<YearPlanEntity> ylambd = new LambdaQueryWrapper<>();
//        ylambd.eq(YearPlanEntity::getProjectId, project);
//        List<YearPlanEntity> list1 = yearPlanService.list(ylambd);
//        for (YearPlanEntity ype : list1) {
//            if (ype.getBillState() != 1 && ype.getBillState() != 3) {
//                throw new BusinessException("下游存在未生效年计划单据，不允许保存!");
//            }
//            if (ype.getChangeStatus() == PlanConstant.CHANGE_ING) {
//                throw new BusinessException("下游存在变更中年计划单据，不允许保存!");
//            }
//        }
//        LambdaQueryWrapper<MonthPlanEntity> mlambd = new LambdaQueryWrapper<>();
//        mlambd.eq(MonthPlanEntity::getProjectId, project);
//        List<MonthPlanEntity> list2 = monthPlanService.list(mlambd);
//        for (MonthPlanEntity ype : list2) {
//            if (ype.getBillState() != 1 && ype.getBillState() != 3) {
//                throw new BusinessException("下游存在未生效月计划单据，不允许保存!");
//            }
//            if (ype.getChangeStatus() == PlanConstant.CHANGE_ING) {
//                throw new BusinessException("下游存在变更中月计划单据，不允许保存!");
//            }
//        }
//        LambdaQueryWrapper<WeekPlanEntity> wlambd = new LambdaQueryWrapper<>();
//        wlambd.eq(WeekPlanEntity::getProjectId, project);
//        List<WeekPlanEntity> list3 = weekPlanService.list(wlambd);
//        for (WeekPlanEntity ype : list3) {
//            if (ype.getBillState() != 1 && ype.getBillState() != 3) {
//                throw new BusinessException("下游存在未生效周计划单据，不允许保存!");
//            }
//            if (ype.getChangeStatus() == PlanConstant.CHANGE_ING) {
//                throw new BusinessException("下游存在变更中周计划单据，不允许保存!");
//            }
//        }
//    }
}
