package com.ejianc.business.jlprogress.progress.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * @author yqls
 * @date 2021-05-24 18:23:16
 */
@Component
public class DetailListUtil<T> {

    public List<T> setDetailList(List<T> list) {
		if(list != null && list.size() > 0) {
            list.forEach(entity->{
                Class<?> mainClass = entity.getClass();
                Field[] fields = mainClass.getDeclaredFields();
				/** 查找字表字段 可能有多个子表*/
                for (Field field : fields) {
                    if(field.isAnnotationPresent(SubEntity.class)){
                        SubEntity subEntity = field.getAnnotation(SubEntity.class);
                        String serviceName = subEntity.serviceName();
                        String fieldName = field.getName();
                        if(StringUtils.isBlank(serviceName)){
                            throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                        }
                        BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                        if(subService==null){
                            throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                        }
                        try {
                            Method m =  mainClass.getMethod("getId",  null);
                            /** 获取子表数据 */
                            Long id = (Long)m.invoke(entity, null);
                            QueryParam queryParam = new QueryParam();
                            queryParam.getParams().put(subEntity.pidName(), new Parameter(QueryParam.EQ, id));
                            queryParam.getOrderMap().put("id",QueryParam.ASC);
                            List<BaseEntity> subList = subService.queryList(queryParam,false);

                            if(!ListUtil.isEmpty(subList)){
                                Class[] cArg = new Class[1];
                                cArg[0] = field.getType();
                                Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
                                setSubList.invoke(entity,subList);
                            }
                        } catch (NoSuchMethodException e) {
                            throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                        } catch (IllegalAccessException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                        } catch (InvocationTargetException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                        }

                    }
                }
            });
		}
		return list;
    }

    public static <T> List<T> getLeafList(List<T> list) {
        List<T> result = new ArrayList<>();
        getLeafList(result, list);
        return result;
    }

    private static <T> void getLeafList(List<T> result, List<T> list) {
        for (T vo : list) {
            List<T> children = getChilerenValue(vo, "children");
            if (CollectionUtils.isNotEmpty(children)){
                getLeafList(result, children);
            } else {
                result.add(vo);
            }
        }
    }

    private static <T> List<T> getChilerenValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                return (List<T>) m.invoke(t, (Object[]) null);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }
}
