package com.ejianc.business.jlprogress.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.quality.bean.OutsourceConfirmDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 质量检测-外协检验确认单-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_outsource_confirm")
public class OutsourceConfirmEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 外购确认单号
    @TableField(value="confirm_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confirmDate; // 确认日期
    @TableField(value="unit_id")
    private Long unitId; // 供货单位
    @TableField(value="unit_name")
    private String unitName; // 供货单位名称
    @TableField(value="production_memo")
    private String productionMemo; // 生产厂家
    @TableField(value="supply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date supplyDate; // 供货日期
    @TableField(value="purchase_id")
    private Long purchaseId; // 采购员
    @TableField(value="purchase_name")
    private String purchaseName; // 采购员名称
    @TableField(value="org_id")
    private Long orgId; // 上报部门
    @TableField(value="org_code")
    private String orgCode; // 上报部门code
    @TableField(value="org_name")
    private String orgName; // 上报部门名称
    @TableField(value="unit")
    private String unit; // 数量单位
    @TableField(value="product_type_id")
    private Long productTypeId; // 产品类别ID
    @TableField(value="product_type_code")
    private String productTypeCode; // 产品类别code
    @TableField(value="product_type_name")
    private String productTypeName; // 产品类别名称
    @TableField(value="product_name")
    private String productName; // 产品名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="texture")
    private String texture; // 材质
    @TableField(value="tested_num")
    private BigDecimal testedNum; // 受检总数
    @TableField(value="qualified_num")
    private BigDecimal qualifiedNum; // 合格数
    @TableField(value="random_num")
    private BigDecimal randomNum; // 抽检总数
    @TableField(value="random_qualified_num")
    private BigDecimal randomQualifiedNum; // 抽检合格数
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="outsourceConfirmDetailService", pidName = "confirmId")
    private List<OutsourceConfirmDetailEntity> outsourceConfirmDetailList = new ArrayList<>(); // 质量检测-外协检验确认单-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getProductionMemo() {
        return productionMemo;
    }

    public void setProductionMemo(String productionMemo) {
        this.productionMemo = productionMemo;
    }
    public Date getSupplyDate() {
        return supplyDate;
    }

    public void setSupplyDate(Date supplyDate) {
        this.supplyDate = supplyDate;
    }
    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getProductTypeId() {
        return productTypeId;
    }

    public void setProductTypeId(Long productTypeId) {
        this.productTypeId = productTypeId;
    }
    public String getProductTypeCode() {
        return productTypeCode;
    }

    public void setProductTypeCode(String productTypeCode) {
        this.productTypeCode = productTypeCode;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }
    public BigDecimal getTestedNum() {
        return testedNum;
    }

    public void setTestedNum(BigDecimal testedNum) {
        this.testedNum = testedNum;
    }
    public BigDecimal getQualifiedNum() {
        return qualifiedNum;
    }

    public void setQualifiedNum(BigDecimal qualifiedNum) {
        this.qualifiedNum = qualifiedNum;
    }
    public BigDecimal getRandomNum() {
        return randomNum;
    }

    public void setRandomNum(BigDecimal randomNum) {
        this.randomNum = randomNum;
    }
    public BigDecimal getRandomQualifiedNum() {
        return randomQualifiedNum;
    }

    public void setRandomQualifiedNum(BigDecimal randomQualifiedNum) {
        this.randomQualifiedNum = randomQualifiedNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<OutsourceConfirmDetailEntity> getOutsourceConfirmDetailList() {
        return outsourceConfirmDetailList;
    }

    public void setOutsourceConfirmDetailList(List<OutsourceConfirmDetailEntity> outsourceConfirmDetailList) {
        this.outsourceConfirmDetailList = outsourceConfirmDetailList;
    }
}
