/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlprogress.labor.bean.ProjectTeamEntity;
import com.ejianc.business.jlprogress.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.jlprogress.labor.mapper.ProjectTeamMapper;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.service.IWorkerEnterService;
import com.ejianc.business.jlprogress.labor.vo.ProjectTeamVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTeamService")
public class ProjectTeamServiceImpl
extends BaseServiceImpl<ProjectTeamMapper, ProjectTeamEntity>
implements IProjectTeamService {
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IWorkerEnterService enterService;

    @Override
    public ProjectTeamVO insertOrUpdate(ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamEntity entity = (ProjectTeamEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectTeamEntity.class));
        boolean updateFlag = false;
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
        } else {
            ProjectTeamEntity entity1 = (ProjectTeamEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (!entity.getName().equals(entity1.getName())) {
                updateFlag = true;
            }
        }
        if (entity.getSourceFlag() == null) {
            entity.setSourceFlag(0);
        }
        LambdaQueryWrapper wrapperByParentId = new LambdaQueryWrapper();
        wrapperByParentId.eq(entity.getId() != null, ProjectTeamEntity::getParentId, (Object)entity.getId());
        wrapperByParentId.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        int count = super.count((Wrapper)wrapperByParentId);
        if (count > 0) {
            entity.setIsLeaf(false);
        } else {
            entity.setIsLeaf(true);
        }
        entity.setInnerCode(entity.getParentId() + "|" + entity.getId());
        super.saveOrUpdate((Object)entity, false);
        Long parentId = entity.getParentId();
        if (parentId != null) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ProjectTeamEntity::getIsLeaf, (Object)false);
            wrapper.eq(BaseEntity::getId, (Object)parentId);
            super.update((Wrapper)wrapper);
        }
        if (updateFlag) {
            this.updateWorkerTeamNameByTeamIdOrWorkerId(entity.getId(), null);
        }
        ProjectTeamVO vo = (ProjectTeamVO)BeanMapper.map((Object)((Object)entity), ProjectTeamVO.class);
        return vo;
    }

    @Override
    public List<String> insertBatch(List<ProjectTeamVO> voList) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(voList)) {
            Long projectId = voList.get(0).getProjectId();
            if (null != projectId) {
                CommonResponse projectDetail = this.projectApi.getProjectArchiveById(projectId);
                if (!projectDetail.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                ProjectArchiveVO project = (ProjectArchiveVO)projectDetail.getData();
                QueryWrapper queryProject = new QueryWrapper();
                queryProject.eq((Object)"project_id", (Object)project.getId());
                queryProject.isNull((Object)"parent_id");
                ProjectTeamEntity projectTeamEntity = (ProjectTeamEntity)((Object)super.getOne((Wrapper)queryProject));
                ArrayList<ProjectTeamEntity> saveEntity = new ArrayList<ProjectTeamEntity>();
                for (ProjectTeamVO vo : voList) {
                    LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                    lambda.eq(ProjectTeamEntity::getSourceOrgTeamId, (Object)vo.getSourceOrgTeamId());
                    lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    lambda.eq(ProjectTeamEntity::getSourceFlag, (Object)TeamSourceFlagEnum.\u516c\u53f8.getStatus());
                    lambda.eq(ProjectTeamEntity::getProjectId, (Object)project.getId());
                    int count = super.count((Wrapper)lambda);
                    if (count > 0) {
                        errorMsg.add("\u5f53\u524d" + vo.getName() + "\u5df2\u5b58\u5728");
                        continue;
                    }
                    ProjectTeamEntity entity = (ProjectTeamEntity)((Object)BeanMapper.map((Object)vo, ProjectTeamEntity.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) {
                        errorMsg.add("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setId(IdWorker.getId());
                    entity.setProjectId(project.getId());
                    entity.setProjectName(project.getName());
                    entity.setOrgId(project.getProjectDepartmentId());
                    entity.setParentOrgId(project.getOrgId());
                    entity.setParentOrgName(project.getOrgName());
                    entity.setCode((String)billCode.getData());
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"source_org_team_id", (Object)entity.getSourceParentId());
                    queryWrapper.eq((Object)"project_id", (Object)project.getId());
                    ProjectTeamEntity one = (ProjectTeamEntity)((Object)super.getOne((Wrapper)queryWrapper));
                    if (one != null) {
                        entity.setParentId(one.getId());
                        one.setIsLeaf(false);
                        super.saveOrUpdate((Object)one);
                        entity.setInnerCode(one.getInnerCode() + "|" + entity.getId());
                    } else {
                        entity.setParentId(projectTeamEntity.getId());
                        entity.setInnerCode(projectTeamEntity.getInnerCode() + "|" + entity.getId());
                    }
                    QueryWrapper childQuery = new QueryWrapper();
                    childQuery.eq((Object)"source_parent_id", (Object)entity.getSourceOrgTeamId());
                    childQuery.eq((Object)"project_id", (Object)project.getId());
                    List list = super.list((Wrapper)childQuery);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (ProjectTeamEntity upEntity : list) {
                            upEntity.setParentId(entity.getId());
                            upEntity.setInnerCode(entity.getInnerCode() + "|" + upEntity.getId());
                        }
                        super.saveOrUpdateBatch((Collection)list);
                        entity.setIsLeaf(false);
                    } else {
                        entity.setIsLeaf(true);
                    }
                    entity.setTenantId(InvocationInfoProxy.getTenantid());
                    super.saveOrUpdate((Object)entity);
                    saveEntity.add(entity);
                }
            } else {
                errorMsg.add("\u5f53\u524d\u9879\u76ee\u4e3a\u7a7a");
            }
        } else {
            errorMsg.add("\u5f53\u524d\u4e3a\u7a7a");
        }
        return errorMsg;
    }

    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        Integer integer = this.recordService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        Integer integer1 = this.enterService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        return integer + integer1;
    }
}

