/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.IncomeContractVO;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warn/"})
public class WarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SALES_WARN_NAME = "\u9500\u552e\u8ba2\u5355\u672a\u5236\u5355";
    private static final String PLAN_WARN_NAME = "\u8ba1\u5212\u901a\u77e5\u5355\u672a\u5236\u5355";
    private static final String YEAR_PLAN_WARN_NAME = "\u8ba1\u5212\u5206\u89e3\u672a\u5236\u5355";
    private static final String SALES_REPORT_URL = "/ejc-jlprogress-frontend/#/sales";
    private static final String PLAN_REPORT_URL = "/ejc-jlprogress-frontend/#/plan";
    private static final String YEAR_PLAN_REPORT_URL = "/ejc-jlprogress-frontend/#/planResolve";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ISalesService salesService;
    @Autowired
    private SalesMapper salesMapper;
    @Autowired
    private TotalPlanMapper totalPlanMapper;
    @Autowired
    private ITotalPlanService totalPlanService;

    @PostMapping(value={"salesWarn"})
    public CommonResponse<String> salesWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<IncomeContractVO> recordVOList = this.salesMapper.getNoSales();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u9500\u552e\u8ba2\u5355\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u9500\u552e\u8ba2\u5355\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("\u9500\u552e\u8ba2\u5355");
            vo.setPcUrl(SALES_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"planWarn"})
    public CommonResponse<String> planWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<IncomeContractVO> recordVOList = this.salesMapper.getNoPlan();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u8ba1\u5212\u901a\u77e5\u5355\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u8ba1\u5212\u901a\u77e5\u5355\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("\u8ba1\u5212\u901a\u77e5\u5355");
            vo.setPcUrl(PLAN_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"totalPlanWarn"})
    public CommonResponse<String> totalPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ProjectArchiveVO> projectList = this.totalPlanMapper.getNoPlan();
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ProjectArchiveVO project : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(project.getName());
            vo.setPcTitle("\u8ba1\u5212\u901a\u77e5\u5355");
            vo.setPcUrl(PLAN_REPORT_URL);
            vo.setOrgId(project.getOrgId());
            vo.setOrgName(project.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", project.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"yearPlanWarn"})
    public CommonResponse<String> yearPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<TotalPlanEntity> projectList = this.totalPlanService.getNoTotalPlan();
        if (CollectionUtils.isEmpty(projectList)) {
            this.logger.error("\u6267\u884c\u8ba1\u5212\u5206\u89e3\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u8ba1\u5212\u5206\u89e3\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(projectList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (TotalPlanEntity totalPlanEntity : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(totalPlanEntity.getProjectName());
            vo.setPcTitle("\u8ba1\u5212\u5206\u89e3");
            vo.setPcUrl(YEAR_PLAN_REPORT_URL);
            vo.setOrgId(totalPlanEntity.getParentOrgId());
            vo.setOrgName(totalPlanEntity.getParentOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", totalPlanEntity.getProjectName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }
}

