/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.mapper.CheckMapper;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.vo.CheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String YF_MNY_PARAM_CODE = "P-3h98630005";
    @Autowired
    private ITargetApi targetApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private CheckMapper checkMapper;

    @Override
    public ParamsCheckVO checkParams(CheckVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(CheckVO vo) {
        CommonResponse billParamByCode;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getTransportMny();
        CommonResponse targetData = this.targetApi.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u8fd0\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u8fd0\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.checkMapper.getMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(YF_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u8fd0\u8d39\u3011\u7ba1\u63a7\u3010\u5b9e\u9645\u8fd0\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8fd0\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u9879\u76ee\u8fd0\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u8fd0\u8d39\u91d1\u989d\uff1a").append(totalMnyStr).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u8fd0\u8d39\u91d1\u989d\uff1a").append(targetMnyStr).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public JSONObject getCheckDataByContractId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CheckEntity::getContractId, (Object)contractId);
        queryWrapper.in(CheckEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        jsonObject.put("checkList", (Object)list);
        jsonObject.put("checkState", (Object)(CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0 ? "\u5df2\u9a8c\u6536" : "\u672a\u9a8c\u6536"));
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> getCheckDataByContractIdList(List<Long> ids) {
        HashMap<Long, JSONObject> collectMap = new HashMap<Long, JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(CheckEntity::getContractId, ids);
        queryWrapper.in(CheckEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<CheckEntity>> checkDataMap = list.stream().collect(Collectors.groupingBy(CheckEntity::getContractId));
            for (Long contractId : checkDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("checkList", checkDataMap.get(contractId));
                jsonObject.put("checkState", (Object)(CollectionUtils.isNotEmpty((Collection)checkDataMap.get(contractId)) && checkDataMap.get(contractId).size() > 0 ? "\u5df2\u9a8c\u6536" : "\u672a\u9a8c\u6536"));
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}

