/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import PluSoft.Data.Project;
import PluSoft.Utils.Convert;
import PluSoft.Utils.DateUtil;
import PluSoft.Utils.IDCompare;
import PluSoft.Utils.JSON;
import PluSoft.Utils.StringUtil;
import PluSoft.Utils.Tree;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlusProjectUtil {
    public static final List<String> customize_cloum = new ArrayList<String>();

    public static HashMap Read(MultipartFile file, List<String> cloums) throws Exception {
        customize_cloum.clear();
        for (String cloum : cloums) {
            customize_cloum.add(cloum);
        }
        HashMap map = PlusProjectUtil.Read(file, false);
        customize_cloum.clear();
        return map;
    }

    public static String Write(Map dataProject, List<String> cloums) throws ParseException {
        customize_cloum.clear();
        for (String cloum : cloums) {
            customize_cloum.add(cloum);
        }
        String file = PlusProjectUtil.WriteXml(dataProject);
        customize_cloum.clear();
        return file;
    }

    public static String WriteXml(Map dataProject) throws ParseException {
        int i;
        HashMap asi;
        ArrayList tasks = (ArrayList)dataProject.get("Tasks");
        PlusProjectUtil.syncTreeNodes(tasks, 1, "", "children");
        tasks = Tree.ToTable((List)tasks, (String)"-1", (String)"children", (String)"UID", (String)"ParentTaskUID");
        dataProject.put("Tasks", tasks);
        ArrayList Assignments = new ArrayList();
        for (Object task_o : tasks) {
            ArrayList ass;
            asi = (HashMap)task_o;
            int duration = Convert.toInt(asi.get("Duration"));
            asi.put("Duration", duration * 8);
            ArrayList PredecessorLink = (ArrayList)asi.get("PredecessorLink");
            if (PredecessorLink != null) {
                int k = PredecessorLink.size();
                for (int j = 0; j < k; ++j) {
                    Map link = (Map)PredecessorLink.get(j);
                    int linkLag = Convert.toInt(link.get("LinkLag"));
                    if (linkLag == 0) continue;
                    link.put("LinkLag", Convert.toInt((Object)(linkLag * 4800)));
                }
            }
            if ((ass = (ArrayList)asi.get("Assignments")) == null) continue;
            Assignments.addAll(ass);
        }
        ArrayList resources = (ArrayList)dataProject.get("Resources");
        if (resources != null) {
            for (i = resources.size() - 1; i >= 0; --i) {
                asi = (HashMap)resources.get(i);
                asi.put("MaxUnits", Convert.toInt(asi.get("MaxUnits")));
            }
        }
        if (Assignments != null) {
            for (i = Assignments.size() - 1; i >= 0; --i) {
                asi = (HashMap)Assignments.get(i);
                asi.put("Units", Convert.toInt(asi.get("Units")));
            }
        }
        return PlusProjectUtil.MSProjectWrite(dataProject);
    }

    public static String MSProjectWrite(Map dataProject) throws ParseException {
        return PlusProjectUtil.ExportToXMLFile(dataProject);
    }

    public static String ExportToXMLFile(Map hs) throws ParseException {
        return PlusProjectUtil.ToXML(hs);
    }

    public static String ToXML(Map hs) throws ParseException {
        HashMap ass_m;
        Map pTask;
        HashMap pl;
        ArrayList plList;
        HashMap UIDTasks;
        HashMap<String, Integer> a;
        HashMap value;
        ArrayList wktmList;
        HashMap resourceMaps;
        ArrayList<HashMap> marks;
        HashMap ca;
        ArrayList OutlineCodes;
        ArrayList eaList = (ArrayList)hs.get("ExtendedAttributes");
        if (eaList == null) {
            eaList = new ArrayList();
            hs.put("ExtendedAttributes", eaList);
        }
        HashMap<String, Object> eaText = new HashMap<String, Object>();
        eaText.put("FieldID", 188743731);
        eaText.put("FieldName", "GUID");
        eaText.put("Alias", hs.get("UID"));
        eaList.add(eaText);
        ArrayList tasks = (ArrayList)hs.get("Tasks");
        for (Object task_o : tasks) {
            HashMap task = (HashMap)task_o;
            OutlineCodes = (ArrayList)task.get("ExtendedAttribute");
            if (OutlineCodes == null) {
                OutlineCodes = new ArrayList();
                task.put("ExtendedAttribute", OutlineCodes);
            }
            ca = new HashMap();
            ca.put("FieldID", 188743731);
            ca.put("Value", task.get("UID"));
            OutlineCodes.add(ca);
        }
        if (hs.get("CreationDate") == null) {
            hs.put("CreationDate", new Date());
        }
        if (hs.get("WeekStartDay") == null) {
            hs.put("WeekStartDay", 0);
        }
        if (hs.get("DefaultStartTime") == null) {
            hs.put("DefaultStartTime", "08:00:00");
        }
        if (hs.get("DefaultFinishTime") == null) {
            hs.put("DefaultFinishTime", "17:00:00");
        }
        if (hs.get("MinutesPerDay") == null) {
            hs.put("MinutesPerDay", 480);
        }
        if (hs.get("MinutesPerWeek") == null) {
            hs.put("MinutesPerWeek", 2400);
        }
        if (hs.get("DaysPerMonth") == null) {
            hs.put("DaysPerMonth", 20);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" standalone=\"yes\"?><Project xmlns=\"http://schemas.microsoft.com/project\">");
        sb.append("<SaveVersion>1000</SaveVersion>");
        sb.append("<UID>" + hs.get("UID") + "</UID>");
        sb.append("<Author>" + hs.get("Author") + "</Author>");
        sb.append("<Name>" + PlusProjectUtil.ToCDATAString(hs.get("Name")) + "</Name>");
        sb.append("<StartDate>" + PlusProjectUtil.ToDateTimeString(hs.get("StartDate"), true) + "</StartDate>");
        sb.append("<FinishDate>" + PlusProjectUtil.ToDateTimeString(hs.get("FinishDate"), false) + "</FinishDate>");
        sb.append("<CreationDate>" + PlusProjectUtil.ToDateTimeString(hs.get("CreationDate")) + "</CreationDate>");
        sb.append("<CalendarUID>" + hs.get("CalendarUID") + "</CalendarUID>");
        sb.append("<WeekStartDay>" + hs.get("WeekStartDay") + "</WeekStartDay>");
        sb.append("<DefaultStartTime>" + hs.get("DefaultStartTime") + "</DefaultStartTime>");
        sb.append("<DefaultFinishTime>" + hs.get("DefaultFinishTime") + "</DefaultFinishTime>");
        sb.append("<MinutesPerDay>" + hs.get("MinutesPerDay") + "</MinutesPerDay>");
        sb.append("<MinutesPerWeek>" + hs.get("MinutesPerWeek") + "</MinutesPerWeek>");
        sb.append("<DaysPerMonth>" + hs.get("DaysPerMonth") + "</DaysPerMonth>");
        sb.append("<ProjectExternallyEdited>0</ProjectExternallyEdited>");
        sb.append("<Calendars>");
        ArrayList calendarList = (ArrayList)hs.get("Calendars");
        if (calendarList == null || calendarList.size() == 0) {
            calendarList = PlusProjectUtil.GetDefaultCalendars();
            hs.put("Calendars", calendarList);
            hs.put("CalendarUID", "1");
        }
        for (Object ca_o : calendarList) {
            ca = (HashMap)ca_o;
            String caName = PlusProjectUtil.ToCDATAString(ca.get("Name"));
            if (StringUtil.isNullOrEmpty((Object)caName)) {
                caName = "Calendar" + ca.get("UID");
            }
            sb.append("<Calendar>");
            sb.append("<UID>" + ca.get("UID") + "</UID>");
            sb.append("<Name>" + caName + "</Name>");
            sb.append("<IsBaseCalendar>" + ca.get("IsBaseCalendar") + "</IsBaseCalendar>");
            sb.append("<BaseCalendarUID>" + ca.get("BaseCalendarUID") + "</BaseCalendarUID>");
            ArrayList weekdayList = (ArrayList)ca.get("WeekDays");
            marks = (ArrayList)ca.get("Exceptions");
            if (marks == null) {
                marks = new ArrayList<HashMap>();
            }
            if (weekdayList != null) {
                sb.append("<WeekDays>");
                for (Object e : weekdayList) {
                    resourceMaps = (HashMap)e;
                    if (resourceMaps.get("DayType").toString().equals("0")) {
                        marks.add(resourceMaps);
                        continue;
                    }
                    sb.append("<WeekDay>");
                    sb.append("<DayType>" + resourceMaps.get("DayType") + "</DayType>");
                    sb.append("<DayWorking>" + resourceMaps.get("DayWorking") + "</DayWorking>");
                    wktmList = (ArrayList)resourceMaps.get("WorkingTimes");
                    if (wktmList != null) {
                        sb.append("<WorkingTimes>");
                        for (Object wktm_o : wktmList) {
                            HashMap wktm = (HashMap)wktm_o;
                            sb.append("<WorkingTime>");
                            sb.append("<FromTime>" + wktm.get("FromTime") + "</FromTime>");
                            sb.append("<ToTime>" + wktm.get("ToTime") + "</ToTime>");
                            sb.append("</WorkingTime>");
                        }
                        sb.append("</WorkingTimes>");
                    }
                    if (resourceMaps.get("DayWorking").toString().equals("1") && wktmList == null) {
                        sb.append("<WorkingTimes><WorkingTime><FromTime>08:00:00</FromTime><ToTime>12:00:00</ToTime></WorkingTime><WorkingTime><FromTime>13:00:00</FromTime><ToTime>17:00:00</ToTime></WorkingTime></WorkingTimes>");
                    }
                    sb.append("</WeekDay>");
                }
                sb.append("</WeekDays>");
            }
            if (marks != null) {
                sb.append("<Exceptions>");
                for (Object e : marks) {
                    resourceMaps = (HashMap)e;
                    sb.append("<Exception>");
                    sb.append("<EnteredByOccurrences>0</EnteredByOccurrences>");
                    sb.append("<Occurrences>1</Occurrences>");
                    sb.append("<Type>1</Type>");
                    sb.append("<DayWorking>" + resourceMaps.get("DayWorking") + "</DayWorking>");
                    sb.append("<Name>" + resourceMaps.get("Name") + "</Name>");
                    sb.append("<TimePeriod>");
                    value = (HashMap)resourceMaps.get("TimePeriod");
                    sb.append("<FromDate>" + PlusProjectUtil.ToDateTimeString(value.get("FromDate")) + "</FromDate>");
                    sb.append("<ToDate>" + PlusProjectUtil.ToDateTimeString(value.get("ToDate")) + "</ToDate>");
                    sb.append("</TimePeriod>");
                    wktmList = (ArrayList)resourceMaps.get("WorkingTimes");
                    if (wktmList == null) {
                        if ("1".equals(resourceMaps.get("DayWorking").toString())) {
                            sb.append("<WorkingTimes><WorkingTime><FromTime>08:00:00</FromTime><ToTime>12:00:00</ToTime></WorkingTime><WorkingTime><FromTime>13:00:00</FromTime><ToTime>17:00:00</ToTime></WorkingTime></WorkingTimes>");
                        }
                    } else {
                        sb.append("<WorkingTimes>");
                        for (Object wktm_o : wktmList) {
                            a = (HashMap)wktm_o;
                            sb.append("<WorkingTime>");
                            sb.append("<FromTime>" + a.get("FromTime") + "</FromTime>");
                            sb.append("<ToTime>" + a.get("ToTime") + "</ToTime>");
                            sb.append("</WorkingTime>");
                        }
                        sb.append("</WorkingTimes>");
                    }
                    sb.append("</Exception>");
                }
                sb.append("</Exceptions>");
            }
            sb.append("</Calendar>");
        }
        sb.append("</Calendars>");
        ArrayList ExtendedAttributes = (ArrayList)hs.get("ExtendedAttributes");
        if (ExtendedAttributes != null) {
            sb.append("<ExtendedAttributes>");
            for (Object ea_o : ExtendedAttributes) {
                HashMap ea = (HashMap)ea_o;
                sb.append("<ExtendedAttribute>");
                sb.append("<FieldID>" + ea.get("FieldID") + "</FieldID>");
                sb.append("<FieldName>" + ea.get("FieldName") + "</FieldName>");
                if (ea.get("Ltuid") != null) {
                    sb.append("<Ltuid>" + ea.get("Ltuid") + "</Ltuid>");
                }
                if (ea.get("Alias") != null) {
                    sb.append("<Alias>" + ea.get("Alias") + "</Alias>");
                }
                if (ea.get("Guid") != null) {
                    sb.append("<Guid>" + ea.get("Guid") + "</Guid>");
                }
                sb.append("</ExtendedAttribute>");
            }
            sb.append("</ExtendedAttributes>");
        }
        if ((OutlineCodes = (ArrayList)hs.get("OutlineCodes")) != null) {
            sb.append("<OutlineCodes>");
            for (Object oc_o : OutlineCodes) {
                ArrayList Values2;
                UIDTasks = (HashMap)oc_o;
                sb.append("<OutlineCode>");
                if (UIDTasks.get("Guid") != null) {
                    sb.append("<Guid>" + UIDTasks.get("Guid") + "</Guid>");
                }
                if ((marks = (ArrayList<HashMap>)UIDTasks.get("Masks")) != null) {
                    sb.append("<Masks>");
                    for (Object e : marks) {
                        resourceMaps = (HashMap)e;
                        sb.append("<Mask>");
                        sb.append("<Level>" + resourceMaps.get("Level") + "</Level>");
                        sb.append("<Type>" + resourceMaps.get("Type") + "</Type>");
                        sb.append("<Length>" + resourceMaps.get("Length") + "</Length>");
                        sb.append("<Separator>" + resourceMaps.get("Separator") + "</Separator>");
                        sb.append("</Mask>");
                    }
                    sb.append("</Masks>");
                }
                if ((Values2 = (ArrayList)UIDTasks.get("Values")) != null) {
                    sb.append("<Values>");
                    for (Object v_o : Values2) {
                        value = (HashMap)v_o;
                        sb.append("<Value>");
                        sb.append("<ValueID>" + value.get("ValueID") + "</ValueID>");
                        sb.append("<FieldGUID>" + value.get("FieldGUID") + "</FieldGUID>");
                        sb.append("<ParentValueID>" + value.get("ParentValueID") + "</ParentValueID>");
                        sb.append("<Type>" + value.get("Type") + "</Type>");
                        sb.append("<Value>" + value.get("Value") + "</Value>");
                        sb.append("</Value>");
                    }
                    sb.append("</Values>");
                }
                sb.append("</OutlineCode>");
            }
            sb.append("</OutlineCodes>");
        }
        ArrayList Assignments = new ArrayList();
        ArrayList taskList = (ArrayList)hs.get("Tasks");
        UIDTasks = new HashMap();
        HashMap NewUIDTasks = new HashMap();
        int maxTaskUID = 1;
        for (Object v_o : taskList) {
            value = (HashMap)v_o;
            if (value.get("UID") == null) continue;
            UIDTasks.put(value.get("UID").toString(), value);
            value.put("UID", maxTaskUID++);
            NewUIDTasks.put(value.get("UID"), value);
        }
        int TaskID = 1;
        sb.append("<Tasks>");
        for (Object task_o : taskList) {
            HashMap task = (HashMap)task_o;
            sb.append("<Task>");
            sb.append("<IsNull>0</IsNull>");
            sb.append("<UID>" + task.get("UID") + "</UID>");
            sb.append("<ID>" + TaskID++ + "</ID>");
            sb.append("<Name>" + PlusProjectUtil.ToCDATAString(task.get("Name")) + "</Name>");
            sb.append("<Type>" + (task.get("Type") == null ? Integer.valueOf(1) : task.get("Type")) + "</Type>");
            sb.append("<OutlineNumber>" + task.get("OutlineNumber") + "</OutlineNumber>");
            sb.append("<OutlineLevel>" + task.get("OutlineLevel") + "</OutlineLevel>");
            sb.append("<CalendarUID>" + hs.get("CalendarUID") + "</CalendarUID>");
            if (task.get("Priority") != null) {
                sb.append("<Priority>" + task.get("Priority") + "</Priority>");
            }
            sb.append("<Start>" + PlusProjectUtil.ToDateTimeString(task.get("Start")) + "</Start>");
            sb.append("<Finish>" + PlusProjectUtil.ToDateTimeString(task.get("Finish")) + "</Finish>");
            sb.append("<Duration>PT" + Convert.toInt(task.get("Duration")) + "H0M0S</Duration>");
            if (task.get("Work") != null) {
                sb.append("<Work>PT" + Convert.toInt(task.get("Work")) + "H0M0S</Work>");
            }
            sb.append("<Estimated>" + (task.get("Estimated") == null ? Integer.valueOf(0) : task.get("Estimated")) + "</Estimated>");
            sb.append("<PercentComplete>" + task.get("PercentComplete") + "</PercentComplete>");
            sb.append("<Milestone>" + (task.get("Milestone") == null ? Integer.valueOf(0) : task.get("Milestone")) + "</Milestone>");
            for (String cloum : customize_cloum) {
                if (task.get(cloum) == null) continue;
                sb.append("<" + cloum + ">" + task.get(cloum) + "</" + cloum + ">");
            }
            if (task.get("Summary") != null) {
                sb.append("<Summary>" + task.get("Summary") + "</Summary>");
            }
            if (task.get("Critical") != null) {
                sb.append("<Critical>" + task.get("Critical") + "</Critical>");
            }
            if (task.get("HyperLink") != null) {
                sb.append("<HyperLink>" + PlusProjectUtil.ToCDATAString(task.get("HyperLink")) + "</HyperLink>");
            }
            if (task.get("HyperLinkAddress") != null) {
                sb.append("<HyperLinkAddress>" + PlusProjectUtil.ToCDATAString(task.get("HyperLinkAddress")) + "</HyperLinkAddress>");
            }
            if (task.get("Notes") != null) {
                sb.append("<Notes>" + task.get("Notes") + "</Notes>");
            }
            if (task.get("ConstraintType") != null) {
                sb.append("<ConstraintType>" + task.get("ConstraintType") + "</ConstraintType>");
            }
            if (task.get("ConstraintDate") != null) {
                sb.append("<ConstraintDate>" + PlusProjectUtil.ToDateTimeString(task.get("ConstraintDate")) + "</ConstraintDate>");
            }
            if (task.get("Manual") != null) {
                sb.append("<Manual>" + task.get("Manual") + "</Manual>");
                if (task.get("Manual").toString().equals("1")) {
                    if (task.get("ManualStart") == null) {
                        task.put("ManualStart", task.get("Start"));
                    }
                    if (task.get("ManualFinish") == null) {
                        task.put("ManualFinish", task.get("Finish"));
                    }
                    if (task.get("ManualDuration") == null) {
                        task.put("ManualDuration", task.get("Duration"));
                    }
                }
            }
            if (task.get("ManualStart") != null) {
                sb.append("<ManualStart>" + PlusProjectUtil.ToDateTimeString(task.get("ManualStart"), "08:00:00") + "</ManualStart>");
            }
            if (task.get("ManualFinish") != null) {
                sb.append("<ManualFinish>" + PlusProjectUtil.ToDateTimeString(task.get("ManualFinish"), "17:00:00") + "</ManualFinish>");
            }
            if (task.get("ManualDuration") != null) {
                sb.append("<ManualDuration>PT" + Convert.toInt(task.get("ManualDuration")) + "H0M0S</ManualDuration>");
            }
            sb.append("<FixedCostAccrual>3</FixedCostAccrual>");
            task.get("BaseLine");
            if (task.get("PredecessorLink") != null) {
                plList = new ArrayList();
                if (task.get("PredecessorLink").getClass().getName() != "java.util.ArrayList") {
                    plList.add(task.get("PredecessorLink"));
                } else {
                    plList = (ArrayList)task.get("PredecessorLink");
                }
                for (Object pl_o : plList) {
                    pl = (HashMap)pl_o;
                    if (pl.get("PredecessorUID") == null || (pTask = (Map)UIDTasks.get(pl.get("PredecessorUID").toString())) == null) continue;
                    pl.put("PredecessorUID", pTask.get("UID"));
                    sb.append("<PredecessorLink>");
                    sb.append("<CrossProject>0</CrossProject>");
                    sb.append("<PredecessorUID>" + pl.get("PredecessorUID") + "</PredecessorUID>");
                    sb.append("<Type>" + pl.get("Type") + "</Type>");
                    sb.append("<LinkLag>" + pl.get("LinkLag") + "</LinkLag>");
                    sb.append("<LagFormat>" + pl.get("LagFormat") + "</LagFormat>");
                    sb.append("</PredecessorLink>");
                }
            }
            if ((plList = (ArrayList)task.get("ExtendedAttribute")) != null) {
                for (Object pl_o : plList) {
                    pl = (HashMap)pl_o;
                    sb.append("<ExtendedAttribute>");
                    sb.append("<FieldID>" + pl.get("FieldID") + "</FieldID>");
                    sb.append("<Value>" + pl.get("Value") + "</Value>");
                    if (pl.get("ValueGUID") != null) {
                        sb.append("<ValueGUID>" + pl.get("ValueGUID") + "</ValueGUID>");
                    }
                    sb.append("</ExtendedAttribute>");
                }
            }
            sb.append("</Task>");
            ArrayList ass = (ArrayList)task.get("Assignments");
            if (ass != null && ass.size() > 0) {
                for (Object e : ass) {
                    ass_m = (HashMap)e;
                    ass_m.put("TaskUID", task.get("UID"));
                }
                Assignments.addAll(ass);
                continue;
            }
            ass = new ArrayList();
            a = new HashMap<String, Integer>();
            a.put("ResourceUID", -65535);
            a.put("TaskUID", (Integer)task.get("UID"));
            a.put("Units", 100);
            ass.add(a);
            Assignments.addAll(ass);
        }
        sb.append("</Tasks>");
        resourceMaps = new HashMap();
        int resourceUID = 1;
        wktmList = (ArrayList)hs.get("Resources");
        if (wktmList == null) {
            wktmList = new ArrayList();
        }
        sb.append("<Resources>");
        for (Object wktm_o : wktmList) {
            a = (HashMap<String, Integer>)wktm_o;
            int reUID = resourceUID++;
            resourceMaps.put(a.get("UID"), reUID);
            sb.append("<Resource>");
            sb.append("<UID>" + reUID + "</UID>");
            sb.append("<Type>" + a.get("Type") + "</Type>");
            sb.append("<Name>" + PlusProjectUtil.ToCDATAString(a.get("Name")) + "</Name>");
            sb.append("</Resource>");
        }
        sb.append("</Resources>");
        plList = (ArrayList)hs.get("Assignments");
        if (plList != null) {
            for (Object pl_o : plList) {
                pl = (HashMap)pl_o;
                pTask = (Map)UIDTasks.get(pl.get("TaskUID"));
                pl.put("TaskUID", pTask.get("UID"));
            }
            Assignments.addAll(plList);
        }
        sb.append("<Assignments>");
        int assUID = 1;
        for (Object e : Assignments) {
            int Summary;
            ass_m = (HashMap)e;
            Map task = (Map)NewUIDTasks.get(ass_m.get("TaskUID"));
            if (task == null || (Summary = Convert.toInt(task.get("Summary")).intValue()) == 1) continue;
            String reUID = ass_m.get("ResourceUID").toString();
            String reUID2 = resourceMaps.get(reUID) != null ? resourceMaps.get(reUID).toString() : reUID;
            sb.append("<Assignment>");
            sb.append("<UID>" + assUID + "</UID>");
            sb.append("<TaskUID>" + ass_m.get("TaskUID") + "</TaskUID>");
            sb.append("<ResourceUID>" + reUID2 + "</ResourceUID>");
            double percent = Convert.toInt(task.get("PercentComplete")).intValue();
            double work = Convert.toInt(task.get("Duration")).intValue();
            double actualWork = percent / 100.0 * work;
            sb.append("<Work>PT" + Convert.toInt((Object)work) + "H0M0S</Work>");
            int hours = (int)actualWork;
            int minutes = (int)((actualWork - (double)hours) * 60.0);
            sb.append("<ActualWork>PT");
            sb.append(hours + "H");
            sb.append(minutes + "M");
            sb.append("0S</ActualWork>");
            double remainintWrok = work - actualWork;
            hours = (int)remainintWrok;
            minutes = (int)((remainintWrok - (double)hours) * 60.0);
            sb.append("<RemainingWork>PT");
            sb.append(hours + "H");
            sb.append(minutes + "M");
            sb.append("0S</RemainingWork>");
            sb.append("<Units>1</Units>");
            if (percent > 0.0) {
                sb.append("<ActualStart>" + PlusProjectUtil.ToDateTimeString(task.get("Start")) + "</ActualStart>");
            }
            sb.append("<Start>" + PlusProjectUtil.ToDateTimeString(task.get("Start"), "08:00:00") + "</Start>");
            sb.append("<TimephasedData>");
            sb.append("<Type>1</Type>");
            sb.append("<UID>" + assUID + "</UID>");
            sb.append("<Start>" + PlusProjectUtil.ToDateTimeString(task.get("Start")) + "</Start>");
            sb.append("<Finish>" + PlusProjectUtil.ToDateTimeString(task.get("Finish")) + "</Finish>");
            sb.append("<Unit>1</Unit>");
            sb.append("<Value>PT" + task.get("Duration") + "H0M0S</Value>");
            sb.append("</TimephasedData>");
            sb.append("</Assignment>");
            ++assUID;
        }
        sb.append("</Assignments>");
        sb.append("</Project>");
        return sb.toString();
    }

    protected static ArrayList GetDefaultCalendars() {
        return (ArrayList)JSON.Decode((String)"[{UID: 1,IsBaseCalendar: 1,BaseCalendarUID:-1,Name: '',WeekDays: [{DayType: 1,DayWorking: 0},{DayType: 2,DayWorking: 1},{DayType: 3,DayWorking: 1},{DayType: 4,DayWorking: 1},{DayType: 5,DayWorking: 1},{DayType: 6,DayWorking: 1},{DayType: 7,DayWorking: 0}],Exceptions:[]}]");
    }

    private static String ToDateTimeString(Object o) throws ParseException {
        if (o == null) {
            return "";
        }
        if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        }
        Date date = (Date)o;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd\u554aHH:mm:ss");
        String str = df.format(date);
        str = str.replace("\u554a", "T");
        return str;
    }

    private static String ToDateTimeString(Object o, boolean clearTime) throws ParseException {
        if (o == null) {
            return "";
        }
        if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        }
        Date date = (Date)o;
        date = clearTime ? DateUtil.clearTime((Date)date) : DateUtil.createDate((int)DateUtil.getYear((Date)date), (int)DateUtil.getMonth((Date)date), (int)DateUtil.getDate((Date)date), (int)23, (int)59, (int)59);
        return PlusProjectUtil.ToDateTimeString(date);
    }

    private static String ToDateTimeString(Object o, String time) throws ParseException {
        if (o == null) {
            return "";
        }
        if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        }
        Date date = (Date)o;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd\u554a");
        String str = df.format(date);
        str = str.replace("\u554a", "T");
        str = str + time;
        return str;
    }

    private static String ToCDATAString(Object o) {
        String s = Convert.toString((Object)o);
        if (s.indexOf("<") != -1 || s.indexOf(">") != -1 || s.indexOf("&") != -1) {
            s = "<![CDATA[" + s + "]]>";
        }
        return s;
    }

    private static void syncTreeNodes(ArrayList nodes, int outlineLevel, String outlineNumber, String childrenField) {
        int l = nodes.size();
        for (int i = 0; i < l; ++i) {
            HashMap node = (HashMap)nodes.get(i);
            node.put("OutlineLevel", outlineLevel);
            node.put("OutlineNumber", outlineNumber + (i + 1));
            ArrayList childNodes = (ArrayList)node.get(childrenField);
            if (childNodes == null || childNodes.size() <= 0) continue;
            PlusProjectUtil.syncTreeNodes(childNodes, outlineLevel + 1, node.get("OutlineNumber").toString() + ".", childrenField);
        }
    }

    private static int ConvertTime(String time) {
        String[] _time = time.split(":");
        return PlusProjectUtil.ConvertTime(Convert.toInt((Object)_time[0]), Convert.toInt((Object)_time[1]), Convert.toInt((Object)_time[2]));
    }

    private static int ConvertTime(int hours, int minutes, int seconds) {
        int sec = hours * 3600;
        sec += minutes * 60;
        return sec += seconds;
    }

    public static HashMap Read(MultipartFile file, boolean autoOrder) throws Exception {
        ArrayList Assignments;
        HashMap dataProject = PlusProjectUtil.MSProjectRead(file);
        int defaultStartTime = PlusProjectUtil.ConvertTime(dataProject.get("DefaultStartTime").toString());
        int defaultFinishTime = PlusProjectUtil.ConvertTime(dataProject.get("DefaultFinishTime").toString());
        int MinutesPerDay = dataProject.get("MinutesPerDay") != null ? Convert.toInt(dataProject.get("MinutesPerDay")) : 480;
        int HoursPerDay = MinutesPerDay / 60;
        HashMap<String, HashMap> hashedTasks = new HashMap<String, HashMap>();
        ArrayList tasks = (ArrayList)dataProject.get("Tasks");
        int i = 0;
        for (int j = 0; j < tasks.size(); ++j) {
            int Summary;
            int PercentComplete;
            ArrayList PredecessorLink;
            Date constraint;
            HashMap task = (HashMap)tasks.get(j);
            hashedTasks.put(task.get("UID").toString(), task);
            i = Convert.toInt(task.get("Duration"));
            i = i > 0 && i < HoursPerDay ? 1 : (i /= HoursPerDay);
            task.put("Duration", i);
            if (i != 0) {
                Date start = (Date)task.get("Start");
                constraint = (Date)task.get("Finish");
                if (start != null) {
                    if (PlusProjectUtil.ConvertTime(start.getHours(), start.getMinutes(), start.getSeconds()) >= defaultFinishTime) {
                        start.setDate(start.getDate() + 1);
                    }
                    task.put("Start", DateUtil.clearTime((Date)start));
                }
                if (constraint != null) {
                    if (PlusProjectUtil.ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) <= defaultStartTime) {
                        constraint.setDate(constraint.getDate() - 1);
                    }
                    task.put("Finish", DateUtil.createDate((int)DateUtil.getYear((Date)constraint), (int)DateUtil.getMonth((Date)constraint), (int)DateUtil.getDate((Date)constraint), (int)23, (int)59, (int)59));
                }
            }
            if (task.get("ConstraintType") != null && task.get("ConstraintDate") != null) {
                i = Convert.toInt(task.get("ConstraintType"));
                constraint = (Date)task.get("ConstraintDate");
                if (i != 3 && i != 6 && i != 7) {
                    if (PlusProjectUtil.ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) >= defaultFinishTime) {
                        constraint.setDate(constraint.getDate() + 1);
                    }
                    task.put("ConstraintDate", DateUtil.clearTime((Date)constraint));
                } else {
                    if (PlusProjectUtil.ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) <= defaultStartTime) {
                        constraint.setDate(constraint.getDate() - 1);
                    }
                    task.put("ConstraintDate", DateUtil.createDate((int)DateUtil.getYear((Date)constraint), (int)DateUtil.getMonth((Date)constraint), (int)DateUtil.getDate((Date)constraint), (int)23, (int)59, (int)59));
                }
            }
            if ((PredecessorLink = (ArrayList)task.get("PredecessorLink")) != null) {
                PercentComplete = PredecessorLink.size();
                for (Summary = 0; Summary < PercentComplete; ++Summary) {
                    Map link = (Map)PredecessorLink.get(Summary);
                    int linkLag = Convert.toInt(link.get("LinkLag"));
                    if (linkLag == 0) continue;
                    link.put("LinkLag", Convert.toInt((Object)(linkLag / 4800)));
                }
            }
            if ((Summary = Convert.toInt(task.get("Summary")).intValue()) == 0 && (PercentComplete = Convert.toInt(task.get("PercentComplete")).intValue()) > 0) {
                task.put("ConstraintType", 4);
                task.put("ConstraintDate", task.get("Start"));
            }
            if (Summary != 0 || Convert.toInt(task.get("Manual")) != 1) continue;
            task.put("ConstraintType", 2);
            task.put("ConstraintDate", task.get("Start"));
        }
        ArrayList calendars = (ArrayList)dataProject.get("Calendars");
        for (i = calendars.size() - 1; i >= 0; --i) {
            Map c = (Map)calendars.get(i);
            if (!c.get("IsBaseCalendar").toString().equals("0")) continue;
            calendars.remove(i);
        }
        HashMap<String, HashMap> hashedResource = new HashMap<String, HashMap>();
        ArrayList resources = (ArrayList)dataProject.get("Resources");
        if (resources != null) {
            for (i = resources.size() - 1; i >= 0; --i) {
                HashMap re = (HashMap)resources.get(i);
                hashedResource.put(re.get("UID").toString(), re);
                re.put("MaxUnits", Convert.toInt(re.get("MaxUnits")));
            }
        }
        if ((Assignments = (ArrayList)dataProject.get("Assignments")) != null) {
            for (i = Assignments.size() - 1; i >= 0; --i) {
                HashMap task;
                HashMap align = (HashMap)Assignments.get(i);
                align.put("Units", Convert.toInt(align.get("Units")));
                String taskUID = align.get("TaskUID").toString();
                String resourceUID = align.get("ResourceUID").toString();
                HashMap re = (HashMap)hashedResource.get(resourceUID);
                if (re == null || (task = (HashMap)hashedTasks.get(taskUID)) == null) continue;
                ArrayList<HashMap> ass = (ArrayList<HashMap>)task.get("Assignments");
                if (ass == null) {
                    ass = new ArrayList<HashMap>();
                    task.put("Assignments", ass);
                }
                ass.add(align);
            }
            dataProject.remove("Assignments");
        }
        tasks = PlusProjectUtil.ToTaskTree(tasks, "children");
        dataProject.put("Tasks", tasks);
        Project project = new Project();
        project.Logic = true;
        project.Load((Map)dataProject);
        if (autoOrder) {
            project.OrderProjectByStart();
        }
        return dataProject;
    }

    public static HashMap MSProjectRead(MultipartFile file) throws Exception {
        HashMap dataProject = PlusProjectUtil.ImportFile(file);
        PlusProjectUtil.checkProject(dataProject);
        return dataProject;
    }

    private static ArrayList ToTaskTree(ArrayList tasks, String nodesField) {
        if (tasks.size() > 0 && ((Map)tasks.get(0)).containsKey("ID")) {
            IDCompare idCompare = new IDCompare();
            Collections.sort(tasks, idCompare);
        }
        HashMap TaskRoot = new HashMap();
        TaskRoot.put(nodesField, new ArrayList());
        int i = 0;
        for (i = tasks.size(); i < i; ++i) {
            Map task = (Map)tasks.get(i);
            task.remove(nodesField);
        }
        HashMap<String, Map> ONashedTasks = new HashMap<String, Map>();
        int l = tasks.size();
        for (i = 0; i < l; ++i) {
            ArrayList<Map> Nodes;
            Map task = (Map)tasks.get(i);
            task.put("_state", "added");
            String OutlineNumber = task.get("OutlineNumber").toString();
            String OutlineLevel = task.get("OutlineLevel").toString();
            int lastIndex = OutlineNumber.lastIndexOf(".");
            String parentOutlineNumber = lastIndex >= 0 ? OutlineNumber.substring(0, lastIndex) : "";
            HashMap parentTask = (HashMap)ONashedTasks.get(parentOutlineNumber);
            if (parentTask == null) {
                parentTask = TaskRoot;
            }
            if ((Nodes = (ArrayList<Map>)parentTask.get(nodesField)) == null) {
                Nodes = new ArrayList<Map>();
                parentTask.put(nodesField, Nodes);
            }
            Nodes.add(task);
            ONashedTasks.put(OutlineNumber, task);
        }
        return (ArrayList)TaskRoot.get(nodesField);
    }

    private static void checkProject(HashMap project) {
        if (project.get("FinishDate") == null) {
            Date date = (Date)project.get("StartDate");
            date = new Date(date.getTime());
            date.setDate(date.getDate() + 30);
            project.put("FinishDate", date);
        }
        if (project.get("DefaultStartTime") == null) {
            project.put("DefaultStartTime", "08:00:00");
        }
        if (project.get("DefaultFinishTime") == null) {
            project.put("DefaultFinishTime", "17:00:00");
        }
        if (project.get("MinutesPerDay") == null) {
            project.put("MinutesPerDay", 480);
        }
        if (project.get("MinutesPerWeek") == null) {
            project.put("MinutesPerWeek", 2400);
        }
        if (project.get("DaysPerMonth") == null) {
            project.put("DaysPerMonth", 20);
        }
        if (project.get("WeekStartDay") == null) {
            project.put("WeekStartDay", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap ImportFile(MultipartFile file) throws Exception {
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        domfac.setExpandEntityReferences(false);
        DocumentBuilder dombuilder = domfac.newDocumentBuilder();
        InputStream is = null;
        Document doc = null;
        try {
            is = file.getInputStream();
            doc = dombuilder.parse(is);
        }
        catch (Exception var14) {
            var14.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException var13) {
                    var13.printStackTrace();
                }
            }
        }
        return (HashMap)PlusProjectUtil.XML2OBJ(doc);
    }

    private static Object XML2OBJ(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        HashMap project = PlusProjectUtil.getObjectFromXML(root);
        ArrayList list = (ArrayList)project.get("ExtendedAttributes");
        if (list == null) {
            return project;
        }
        for (Object obj : list) {
            HashMap o = (HashMap)obj;
            if (!o.get("FieldID").toString().equals("188743731")) continue;
            project.put("UID", o.get("Alias"));
            break;
        }
        return project;
    }

    private static HashMap getObjectFromXML(Element root) throws Exception {
        ArrayList list;
        NodeList lst = root.getChildNodes();
        HashMap<String, Object> hs = new HashMap<String, Object>();
        if (lst == null) {
            return null;
        }
        for (int it = 0; it < lst.getLength(); ++it) {
            Node nd = lst.item(it);
            NodeList tmp = nd.getChildNodes();
            String name = nd.getNodeName();
            String value = null;
            if (tmp != null && tmp.item(0) != null) {
                value = tmp.item(0).getNodeValue();
            }
            if (name.equals("UID") || name.equals("Author") || name.equals("Name") || name.equals("CalendarUID") || name.equals("DefaultStartTime") || name.equals("DefaultFinishTime")) {
                hs.put(name, value);
            }
            if (name.equals("MinutesPerDay") || name.equals("MinutesPerWeek") || name.equals("DaysPerMonth") || name.equals("WeekStartDay")) {
                hs.put(name, PlusProjectUtil.toInt(value));
            }
            if (name.equals("CreationDate") || name.equals("LastSaved") || name.equals("StartDate") || name.equals("FinishDate")) {
                hs.put(name, PlusProjectUtil.parseDate(value));
            }
            if (name.equals("Calendars")) {
                hs.put(name, PlusProjectUtil.getCalendars(nd));
            }
            if (name.equals("Assignments")) {
                hs.put(name, PlusProjectUtil.getAssignments(nd));
            }
            if (name.equals("Resources")) {
                hs.put(name, PlusProjectUtil.getResources(nd));
            }
            if (name.equals("Tasks")) {
                hs.put(name, PlusProjectUtil.getTasks(nd));
            }
            if (name.equals("ExtendedAttributes")) {
                hs.put("ExtendedAttributes", PlusProjectUtil.getNodesList(nd));
            }
            if (!name.equals("OutlineCodes")) continue;
            list = new ArrayList();
            NodeList node_list = nd.getChildNodes();
            for (int i = 0; i < node_list.getLength(); ++i) {
                NodeList child = node_list.item(i).getChildNodes();
                if (child.getLength() <= 0) continue;
                HashMap<String, ArrayList> o = new HashMap<String, ArrayList>();
                for (int j = 0; j < child.getLength(); ++j) {
                    Node _node = child.item(j);
                    String nodeName = _node.getNodeName();
                    PlusProjectUtil.putNodeValue(o, _node);
                    if (nodeName.equals("Masks")) {
                        o.put("Masks", PlusProjectUtil.getNodesList(_node));
                    }
                    if (!nodeName.equals("Values")) continue;
                    o.put("Values", PlusProjectUtil.getNodesList(_node));
                }
                list.add(o);
            }
            hs.put("OutlineCodes", list);
        }
        ArrayList calendars = (ArrayList)hs.get("Calendars");
        int l = calendars.size();
        for (int i = 0; i < l; ++i) {
            HashMap calendar = (HashMap)calendars.get(i);
            ArrayList WeekDays = (ArrayList)calendar.get("WeekDays");
            if (WeekDays == null) continue;
            list = (ArrayList)calendar.get("Exceptions");
            if (list == null) {
                list = new ArrayList();
                calendar.put("Exceptions", list);
            }
            for (int j = WeekDays.size() - 1; j >= 0; --j) {
                HashMap weekday = (HashMap)WeekDays.get(j);
                if (weekday.get("DayType") != null && !weekday.get("DayType").toString().equals("0")) continue;
                WeekDays.remove(weekday);
            }
        }
        if (calendars != null && calendars.size() > 0 && (hs.get("CalendarUID") == null || hs.get("CalendarUID").toString().equals("null"))) {
            hs.put("CalendarUID", ((Map)calendars.get(0)).get("UID"));
        }
        return hs;
    }

    private static String putNodeValue(Map o, Node nd) {
        String name = nd.getNodeName();
        String text = null;
        NodeList tmp2 = nd.getChildNodes();
        if (tmp2 != null && tmp2.item(0) != null) {
            text = tmp2.item(0).getNodeValue();
        }
        if (name != null && !name.equals("#text")) {
            o.put(name, text);
        }
        return name;
    }

    private static ArrayList getNodesList(Node nd) {
        ArrayList list = new ArrayList();
        NodeList node_list = nd.getChildNodes();
        for (int i = 0; i < node_list.getLength(); ++i) {
            NodeList child = node_list.item(i).getChildNodes();
            if (child.getLength() <= 0) continue;
            HashMap o = new HashMap();
            for (int j = 0; j < child.getLength(); ++j) {
                PlusProjectUtil.putNodeValue(o, child.item(j));
            }
            list.add(o);
        }
        return list;
    }

    private static Object getTasks(Node nd) throws Exception {
        ArrayList<Object> list;
        String name;
        int j;
        HashMap hs;
        ArrayList<HashMap> lst = new ArrayList<HashMap>();
        NodeList task_list = nd.getChildNodes();
        for (int i = 0; i < task_list.getLength(); ++i) {
            NodeList task_child = task_list.item(i).getChildNodes();
            hs = new HashMap();
            if (task_child.getLength() <= 0) continue;
            for (j = 0; j < task_child.getLength(); ++j) {
                Node taskNode = task_child.item(j);
                name = taskNode.getNodeName();
                String value = null;
                NodeList tmp = taskNode.getChildNodes();
                if (tmp != null && tmp.item(0) != null) {
                    value = tmp.item(0).getNodeValue();
                }
                for (String cloum : customize_cloum) {
                    if (!name.equals(cloum)) continue;
                    hs.put(name, value);
                }
                if (name.equals("UID") || name.equals("Name") || name.equals("OutlineNumber") || name.equals("Hyperlink") || name.equals("HyperlinkAddress") || name.equals("Notes") || name.equals("WBS")) {
                    hs.put(name, value);
                }
                if (name.equals("ID") || name.equals("Manual") || name.equals("Type") || name.equals("OutlineLevel") || name.equals("DurationFormat") || name.equals("PercentComplete") || name.equals("ConstraintType") || name.equals("Milestone") || name.equals("Summary") || name.equals("Critical") || name.equals("Priority") || name.equals("Estimated") || name.equals("IsSubproject") || name.equals("IsSubprojectReadOnly") || name.equals("IsNull")) {
                    hs.put(name, PlusProjectUtil.toInt(value));
                }
                if (name.equals("Duration") || name.equals("Work") || name.equals("ActualDuration")) {
                    hs.put(name, PlusProjectUtil.getDuration(value));
                }
                if (name.equals("CreateDate") || name.equals("Start") || name.equals("Finish") || name.equals("ConstraintDate") || name.equals("ActualStart") || name.equals("ActualFinish")) {
                    hs.put(name, PlusProjectUtil.parseDate(value));
                }
                if (name.equals("PredecessorLink")) {
                    if (hs.containsKey(name)) {
                        ((ArrayList)hs.get(name)).add(PlusProjectUtil.getPredecessorLink(task_child.item(j)));
                    } else {
                        list = new ArrayList();
                        list.add(PlusProjectUtil.getPredecessorLink(task_child.item(j)));
                        hs.put(name, list);
                    }
                }
                if (!name.equals("ExtendedAttribute")) continue;
                list = (ArrayList<Object>)hs.get("ExtendedAttribute");
                if (list == null) {
                    list = new ArrayList<Object>();
                    hs.put("ExtendedAttribute", list);
                }
                NodeList node_list = taskNode.getChildNodes();
                HashMap<String, String> o = new HashMap<String, String>();
                for (int jj = 0; jj < node_list.getLength(); ++jj) {
                    String _name;
                    Node _node = node_list.item(jj);
                    String text = null;
                    NodeList tmp2 = _node.getChildNodes();
                    if (tmp != null && tmp2.item(0) != null) {
                        text = tmp2.item(0).getNodeValue();
                    }
                    if ((_name = _node.getNodeName()) == null || _name.equals("#text")) continue;
                    o.put(_node.getNodeName(), text);
                }
                if (o.get("FieldID").toString().equals("188743731")) {
                    hs.put("GUID", o.get("Value").toString());
                }
                list.add(o);
            }
            if (hs.get("UID").toString().equals("0") || hs.get("OutlineLevel") == null || hs.get("IsNull").toString().equals("1")) continue;
            lst.add(hs);
        }
        HashMap preTask = null;
        for (int i = 0; i < lst.size(); ++i) {
            hs = (HashMap)lst.get(i);
            if (preTask == null) {
                hs.put("OutlineNumber", "1");
            } else {
                String outlineNumber;
                int count;
                j = (Integer)preTask.get("OutlineLevel");
                int outlineLevel = (Integer)hs.get("OutlineLevel");
                name = preTask.get("OutlineNumber").toString();
                String[] ss = name.split("\\.");
                ArrayList<String> ls = new ArrayList<String>();
                for (count = 0; count < ss.length; ++count) {
                    ls.add(ss[count]);
                }
                if (outlineLevel > j) {
                    hs.put("OutlineNumber", preTask.get("OutlineNumber").toString() + ".1");
                } else if (outlineLevel == j) {
                    count = Convert.toInt(ls.get(ls.size() - 1));
                    ls.set(ls.size() - 1, Convert.toString((Object)(count + 1)));
                    outlineNumber = StringUtil.join(ls, (String)".");
                    hs.put("OutlineNumber", outlineNumber);
                } else if (outlineLevel < j) {
                    list = new ArrayList<Object>();
                    for (count = 0; count < outlineLevel; ++count) {
                        list.add((String)ls.get(count));
                    }
                    count = Convert.toInt(list.get(list.size() - 1));
                    list.set(list.size() - 1, Convert.toString((Object)(count + 1)));
                    outlineNumber = StringUtil.join(list, (String)".");
                    hs.put("OutlineNumber", outlineNumber);
                }
            }
            preTask = hs;
        }
        return lst;
    }

    private static String getDuration(String value) {
        String[] res3;
        double s;
        String[] res2;
        double m;
        if (StringUtil.isNullOrEmpty((Object)value)) {
            return "0";
        }
        if (value.equals("PTnullH0M0S")) {
            return "0";
        }
        String str = value.substring(2);
        String[] res = str.split("H");
        double h = Double.parseDouble(res[0]);
        String v = String.valueOf(h + (m = Double.parseDouble((res2 = res[1].split("M"))[0])) / 60.0 + (s = Double.parseDouble((res3 = res2[1].split("S"))[0])) / 60.0 / 60.0);
        if (v.equals("0.0")) {
            v = "0";
        }
        int n = StringUtil.toInt((String)v);
        v = Convert.toString((Object)n);
        return v;
    }

    private static Date parseDate(Object value) throws Exception {
        if (value != null && !value.toString().equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date date = df.parse(value.toString());
            return date;
        }
        return null;
    }

    private static Object getPredecessorLink(Node nd) {
        HashMap<String, Object> hs = new HashMap<String, Object>();
        NodeList child = nd.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node _node = child.item(i);
            String name = _node.getNodeName();
            String value = null;
            NodeList tmp = _node.getChildNodes();
            if (tmp != null && tmp.item(0) != null) {
                value = tmp.item(0).getNodeValue();
            }
            if (name.equals("PredecessorUID")) {
                hs.put(name, value);
            }
            if (!name.equals("Type") && !name.equals("LinkLag") && !name.equals("LagFormat")) continue;
            hs.put(name, PlusProjectUtil.toInt(value));
        }
        return hs;
    }

    private static Object getResources(Node nd) {
        ArrayList lst = new ArrayList();
        NodeList resource_list = nd.getChildNodes();
        for (int i = 0; i < resource_list.getLength(); ++i) {
            NodeList child = resource_list.item(i).getChildNodes();
            HashMap<String, Object> hs = new HashMap<String, Object>();
            if (child.getLength() <= 0) continue;
            for (int j = 0; j < child.getLength(); ++j) {
                Node _node = child.item(j);
                String name = _node.getNodeName();
                String value = null;
                NodeList tmp = _node.getChildNodes();
                if (tmp != null && tmp.item(0) != null) {
                    value = tmp.item(0).getNodeValue();
                }
                if (StringUtil.isNullOrEmpty(value)) continue;
                if (name.equals("UID") || name.equals("Name")) {
                    hs.put(name, value);
                }
                if (!name.equals("Type") && !name.equals("MaxUnits") && !name.equals("Cost")) continue;
                hs.put(name, StringUtil.toInt((String)value));
            }
            if (hs.get("UID").toString().equals("0")) continue;
            lst.add(hs);
        }
        return lst;
    }

    private static Object getAssignments(Node nd) {
        ArrayList lst = new ArrayList();
        if (nd == null) {
            return null;
        }
        NodeList assigment_list = nd.getChildNodes();
        for (int i = 0; i < assigment_list.getLength(); ++i) {
            NodeList child = assigment_list.item(i).getChildNodes();
            HashMap<String, Object> hs = new HashMap<String, Object>();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    NodeList tmp;
                    String name = child.item(j).getNodeName();
                    if (name.equals("TaskUID")) {
                        tmp = child.item(j).getChildNodes();
                        hs.put(name, tmp.item(0).getNodeValue());
                        continue;
                    }
                    if (name.equals("ResourceUID")) {
                        tmp = child.item(j).getChildNodes();
                        hs.put(name, tmp.item(0).getNodeValue());
                        continue;
                    }
                    if (!name.equals("Units") && !name.equals("Cost")) continue;
                    tmp = child.item(j).getChildNodes();
                    hs.put(name, PlusProjectUtil.toInt(tmp.item(0).getNodeValue()));
                }
            }
            if (hs.size() <= 0 || hs.get("ResourceUID").equals("-65535")) continue;
            lst.add(hs);
        }
        return lst;
    }

    private static Object getCalendars(Node nd) throws Exception {
        ArrayList lst = new ArrayList();
        NodeList calendar_list = nd.getChildNodes();
        for (int i = 0; i < calendar_list.getLength(); ++i) {
            NodeList child = calendar_list.item(i).getChildNodes();
            HashMap<String, Object> hs = new HashMap<String, Object>();
            if (child.getLength() <= 0) continue;
            for (int j = 0; j < child.getLength(); ++j) {
                Node _node = child.item(j);
                String name = _node.getNodeName();
                String value = null;
                NodeList tmp = _node.getChildNodes();
                if (tmp != null && tmp.item(0) != null) {
                    value = tmp.item(0).getNodeValue();
                }
                if (name.equals("UID") || name.equals("Name") || name.equals("BaseCalendarUID")) {
                    hs.put(name, value);
                }
                if (name.equals("IsBaseCalendar")) {
                    hs.put(name, PlusProjectUtil.toInt(value));
                }
                if (name.equals("WeekDays")) {
                    hs.put(name, PlusProjectUtil.getWeekDays(_node));
                }
                if (!name.equals("Exceptions")) continue;
                hs.put(name, PlusProjectUtil.getExceptions(_node));
            }
            lst.add(hs);
        }
        return lst;
    }

    private static ArrayList getExceptions(Node nd) throws Exception {
        ArrayList lst = new ArrayList();
        NodeList exception_list = nd.getChildNodes();
        for (int i = 0; i < exception_list.getLength(); ++i) {
            NodeList child = exception_list.item(i).getChildNodes();
            HashMap<String, Object> hs = new HashMap<String, Object>();
            if (child.getLength() <= 0) continue;
            for (int j = 0; j < child.getLength(); ++j) {
                Node _node = child.item(j);
                String name = _node.getNodeName();
                String value = null;
                NodeList tmp = _node.getChildNodes();
                if (tmp != null && tmp.item(0) != null) {
                    value = tmp.item(0).getNodeValue();
                }
                if (name.equals("Name")) {
                    hs.put(name, value);
                }
                if (name.equals("DayWorking") || name.equals("DayType")) {
                    hs.put(name, PlusProjectUtil.toInt(value));
                }
                if (name.equals("TimePeriod")) {
                    hs.put(name, PlusProjectUtil.getTimePeriod(_node));
                }
                if (!name.equals("WorkingTimes")) continue;
                hs.put(name, PlusProjectUtil.getWorkingTimes(_node));
            }
            hs.put("DayType", 0);
            lst.add(hs);
        }
        return lst;
    }

    private static Object getTimePeriod(Node nd) throws Exception {
        HashMap<String, Date> hs = new HashMap<String, Date>();
        NodeList child_list = nd.getChildNodes();
        for (int i = 0; i < child_list.getLength(); ++i) {
            String value;
            NodeList tmp;
            String name = child_list.item(i).getNodeName();
            if (name.equals("FromDate")) {
                tmp = child_list.item(i).getChildNodes();
                value = tmp.item(0).getNodeValue();
                hs.put(name, PlusProjectUtil.parseDate(value));
                continue;
            }
            if (!name.equals("ToDate")) continue;
            tmp = child_list.item(i).getChildNodes();
            value = tmp.item(0).getNodeValue();
            hs.put(name, PlusProjectUtil.parseDate(value));
        }
        return hs;
    }

    private static Object getWeekDays(Node nd) throws Exception {
        String[] fid = new String[]{"DayType", "DayWorking"};
        ArrayList lst = new ArrayList();
        NodeList weekday_list = nd.getChildNodes();
        for (int i = 0; i < weekday_list.getLength(); ++i) {
            NodeList child = weekday_list.item(i).getChildNodes();
            HashMap<String, Object> hs = new HashMap<String, Object>();
            if (child.getLength() <= 0) continue;
            for (int j = 0; j < child.getLength(); ++j) {
                String name = child.item(j).getNodeName();
                for (int k = 0; k < fid.length; ++k) {
                    if (!name.equals(fid[k])) continue;
                    NodeList tmp = child.item(j).getChildNodes();
                    String value = tmp.item(0).getNodeValue();
                    hs.put(name, PlusProjectUtil.toInt(value));
                    break;
                }
                if (name.equals("WorkingTimes")) {
                    hs.put(name, PlusProjectUtil.getWorkingTimes(child.item(j)));
                }
                if (!name.equals("TimePeriod")) continue;
                hs.put(name, PlusProjectUtil.getTimePeriod(child.item(j)));
            }
            lst.add(hs);
        }
        return lst;
    }

    private static Object getWorkingTimes(Node nd) {
        String[] fid = new String[]{"FromTime", "ToTime"};
        ArrayList lst = new ArrayList();
        NodeList workingtime_list = nd.getChildNodes();
        for (int i = 0; i < workingtime_list.getLength(); ++i) {
            NodeList child = workingtime_list.item(i).getChildNodes();
            HashMap<String, String> hs = new HashMap<String, String>();
            if (child.getLength() <= 0) continue;
            block1: for (int j = 0; j < child.getLength(); ++j) {
                String name = child.item(j).getNodeName();
                for (int k = 0; k < fid.length; ++k) {
                    if (!name.equals(fid[k])) continue;
                    NodeList tmp = child.item(j).getChildNodes();
                    String value = tmp.item(0).getNodeValue();
                    hs.put(name, value);
                    continue block1;
                }
            }
            lst.add(hs);
        }
        return lst;
    }

    private static int toInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (!o.toString().equals("null") && !o.toString().equals("")) {
            int i;
            boolean var1 = false;
            try {
                i = Convert.toInt((Object)o.toString());
            }
            catch (Exception var3) {
                i = 0;
            }
            return i;
        }
        return 0;
    }
}

