/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.DurationUtil;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.vo.BaseDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.support.idworker.util.IdWorker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TreeHelper2 {
    public static <T extends BaseDetailVO> List<T> list2Tree(List<T> list) {
        ArrayList resp = new ArrayList();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, BaseDetailVO> listMap = new HashMap<String, BaseDetailVO>();
        for (BaseDetailVO detail : list) {
            listMap.put(detail.getUid().toString(), detail);
        }
        for (int i = 0; i < list.size(); ++i) {
            BaseDetailVO detail;
            detail = (BaseDetailVO)list.get(i);
            String parentId = StringUtils.isNotBlank((CharSequence)detail.getParentTaskUID()) ? detail.getParentTaskUID() : "";
            BaseDetailVO parent = (BaseDetailVO)listMap.get(parentId);
            if (parent != null) {
                List<BaseDetailVO> child = TreeHelper2.getChilerenValue(parent, "children");
                if (child != null) {
                    child.add(detail);
                    continue;
                }
                ArrayList<BaseDetailVO> children = new ArrayList<BaseDetailVO>();
                children.add(detail);
                TreeHelper2.setChilerenValue(parent, "children", children);
                continue;
            }
            rootItems.add(detail.getUid().toString());
        }
        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }
        return resp;
    }

    public static <T extends BaseDetailVO> List<T> tree2List(List<T> tree) {
        return TreeHelper2.tree2List(tree, false);
    }

    public static <T extends BaseDetailVO> List<T> tree2List(List<T> tree, Boolean importFlag) {
        List copy = (List)Utils.deepCopy(tree);
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        ArrayList list = new ArrayList();
        TreeHelper2.getPkMap(pkMap, copy, importFlag != null ? importFlag : false);
        TreeHelper2.tree2List(pkMap, list, copy, (String)null);
        return list;
    }

    public static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree) {
        List copy = (List)Utils.deepCopy(tree);
        TreeHelper2.getPkMap(pkMap, copy, false);
        TreeHelper2.tree2List(pkMap, list, copy, (String)null);
    }

    public static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree, Boolean importFlag) {
        List copy = (List)Utils.deepCopy(tree);
        TreeHelper2.getPkMap(pkMap, copy, importFlag != null ? importFlag : false);
        TreeHelper2.tree2List(pkMap, list, copy, (String)null);
    }

    private static <T extends BaseDetailVO> void getPkMap(Map<String, Long> pkMap, List<T> tree, Boolean importFlag) {
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            BaseDetailVO vo = (BaseDetailVO)tree.get(i);
            Long pkId = IdWorker.getId();
            if (!"added".equals(vo.get_state()) && !importFlag.booleanValue()) {
                pkId = Long.valueOf(vo.getUid());
            }
            pkMap.put(vo.getUid(), pkId);
            List<BaseDetailVO> children = TreeHelper2.getChilerenValue(vo, "children");
            if (children == null || children.size() <= 0) continue;
            TreeHelper2.getPkMap(pkMap, children, importFlag);
        }
    }

    private static <T extends BaseDetailVO> void tree2List(Map<String, Long> pkMap, List<T> list, List<T> tree, String parentCode) {
        List codeSet = tree.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getCode())).map(BaseDetailVO::getCode).collect(Collectors.toList());
        int len = tree.size();
        for (int i = 0; i < len; ++i) {
            List<BaseDetailVO> children;
            BaseDetailVO vo = (BaseDetailVO)tree.get(i);
            if (pkMap.containsKey(vo.getUid())) {
                vo.setUid(pkMap.get(vo.getUid()).toString());
            }
            if (StringUtils.isEmpty((CharSequence)vo.getCode())) {
                String code = String.valueOf(vo.getId());
                if (codeSet.contains(code)) {
                    Integer maxCode = codeSet.stream().filter(x -> TreeHelper2.isInteger(x)).map(x -> Integer.valueOf(x)).max(Integer::compare).orElse(0);
                    code = String.valueOf(maxCode + 1);
                }
                codeSet.add(code);
                vo.setCode(code);
            } else {
                Long count = codeSet.stream().filter(x -> x.equals(vo.getCode())).count();
                if (count > 1L) {
                    throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff01");
                }
            }
            vo.setStructCode(parentCode != null ? parentCode + "@@" + vo.getCode() : vo.getCode());
            if (StringUtils.isNotBlank((CharSequence)vo.getParentTaskUID()) && pkMap.containsKey(vo.getParentTaskUID())) {
                vo.setParentTaskUID(pkMap.get(vo.getParentTaskUID()) + "");
            }
            vo.setStart(DateUtil.setHours(vo.getStart(), 8));
            vo.setFinish(DateUtil.setHours(vo.getFinish(), 17));
            if (vo.getConstraintDate() != null) {
                vo.setConstraintDate(DurationUtil.getConstraintDate(vo.getStart(), vo.getFinish(), vo.getConstraintType()));
            }
            if (vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
                for (int j = 0; j < vo.getPredecessorLink().size(); ++j) {
                    String TaskUID;
                    JSONObject predecessorLinkObj = vo.getPredecessorLink().getJSONObject(j);
                    String PredecessorUID = predecessorLinkObj.getString("PredecessorUID");
                    if (pkMap.containsKey(PredecessorUID)) {
                        predecessorLinkObj.put("PredecessorUID", (Object)pkMap.get(PredecessorUID));
                    }
                    if (!pkMap.containsKey(TaskUID = predecessorLinkObj.getString("TaskUID"))) continue;
                    predecessorLinkObj.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            if (vo.getAssignments() != null && vo.getAssignments().size() > 0) {
                for (int j = 0; j < vo.getAssignments().size(); ++j) {
                    JSONObject assignmentsObj = vo.getAssignments().getJSONObject(j);
                    String TaskUID = assignmentsObj.getString("TaskUID");
                    if (!pkMap.containsKey(TaskUID)) continue;
                    assignmentsObj.put("TaskUID", (Object)pkMap.get(TaskUID));
                }
            }
            if ((children = TreeHelper2.getChilerenValue(vo, "children")) != null && children.size() > 0) {
                TreeHelper2.tree2List(pkMap, list, children, vo.getStructCode());
            }
            TreeHelper2.setChilerenValue(vo, "children", null);
            list.add(vo);
        }
    }

    private static <T extends BaseDetailVO> List<T> getChilerenValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return (List)m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }

    private static <T extends BaseDetailVO> void setChilerenValue(T t, String code, List<T> value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), List.class);
            try {
                subPid.invoke(t, value);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eset\u65b9\u6cd5\uff01");
        }
    }

    public static List<Map> listMap2Tree(List<Map> list) {
        ArrayList<Map> resp = new ArrayList<Map>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, Map> listMap = new HashMap<String, Map>();
        for (Map vo : list) {
            listMap.put(vo.get("UID").toString(), vo);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map vo;
            vo = list.get(i);
            if (vo.get("children") == null || ((List)vo.get("children")).size() <= 0) {
                vo.remove("children");
            }
            for (Object key : vo.keySet()) {
                if (!(vo.get(key) instanceof JSONArray)) continue;
                vo.put(key, JSONObject.parseArray((String)vo.get(key).toString(), Map.class));
            }
            String parentId = vo.get("ParentTaskUID") != null ? vo.get("ParentTaskUID").toString() : "";
            Map parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List child = (List)parent.get("children");
                if (child != null) {
                    child.add(vo);
                    continue;
                }
                ArrayList<Map> children = new ArrayList<Map>();
                children.add(vo);
                parent.put("children", children);
                continue;
            }
            rootItems.add(vo.get("UID").toString());
        }
        for (String rootId : rootItems) {
            resp.add((Map)listMap.get(rootId));
        }
        return resp;
    }

    public static List<Map> listMap2Tree2(List<Map> list) {
        ArrayList<Map> resp = new ArrayList<Map>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, Map> listMap = new HashMap<String, Map>();
        for (Map vo : list) {
            listMap.put(vo.get("id").toString(), vo);
        }
        for (int i = 0; i < list.size(); ++i) {
            String parentId;
            Map parent;
            Map vo;
            vo = list.get(i);
            if (vo.get("children") == null || ((List)vo.get("children")).size() <= 0) {
                vo.remove("children");
            }
            if ((parent = (Map)listMap.get(parentId = vo.get("parentId") != null ? vo.get("parentId").toString() : "")) != null) {
                List child = (List)parent.get("children");
                if (child != null) {
                    child.add(vo);
                    continue;
                }
                ArrayList<Map> children = new ArrayList<Map>();
                children.add(vo);
                parent.put("children", children);
                continue;
            }
            rootItems.add(vo.get("id").toString());
        }
        for (String rootId : rootItems) {
            resp.add((Map)listMap.get(rootId));
        }
        return resp;
    }

    public static List<Map> getAllChildList(List<Map> tree, String parentCode) {
        ArrayList<Map> resp = new ArrayList<Map>();
        for (Map vo : tree) {
            List children = (List)vo.get("children");
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            if (parentCode.equals(vo.get("structCode"))) {
                ArrayList<Map> list = new ArrayList<Map>();
                TreeHelper2.treeMap2List(list, (List)Utils.deepCopy((Object)children));
                resp.addAll(list);
                continue;
            }
            resp.addAll(TreeHelper2.getAllChildList(children, parentCode));
        }
        return resp;
    }

    private static void treeMap2List(List<Map> list, List<Map> tree) {
        for (Map vo : tree) {
            List children = (List)vo.get("children");
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                TreeHelper2.treeMap2List(list, children);
            }
            vo.put("children", children);
            list.add(vo);
        }
    }

    public static <T extends BaseDetailVO> void resetOutlineNumber(List<T> tree, String outlineNumber) {
        Integer num = 0;
        for (BaseDetailVO item : tree) {
            List<BaseDetailVO> child;
            Integer n;
            Integer n2;
            if (StringUtils.isEmpty((CharSequence)outlineNumber)) {
                item.setOutlineNumber(String.valueOf(num + 1));
                n2 = num;
                n = num = Integer.valueOf(num + 1);
            } else {
                item.setOutlineNumber(outlineNumber + "." + (num + 1));
                n2 = num;
                n = num = Integer.valueOf(num + 1);
            }
            if (!CollectionUtils.isNotEmpty(child = TreeHelper2.getChilerenValue(item, "children"))) continue;
            TreeHelper2.resetOutlineNumber(child, item.getOutlineNumber());
        }
    }

    public static <T extends BaseDetailVO> List<T> entrySort(List<T> list) {
        String regex = "[-.#@,\uff0c;\uff1b\u3001]";
        list.sort((o1, o2) -> {
            String[] sufArrs;
            String[] preArrs = o1.getOutlineNumber().split(regex);
            int len = preArrs.length > (sufArrs = o2.getOutlineNumber().split(regex)).length ? preArrs.length : sufArrs.length;
            for (int i = 0; i < len; ++i) {
                int preNum = 0;
                int sufNum = 0;
                if (i < preArrs.length) {
                    preNum = Integer.parseInt(preArrs[i]);
                }
                if (i < sufArrs.length) {
                    sufNum = Integer.parseInt(sufArrs[i]);
                }
                if (preNum > sufNum) {
                    return 1;
                }
                if (preNum >= sufNum) continue;
                return -1;
            }
            return 0;
        });
        return list;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            TreeHelper2.key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            TreeHelper2.key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            TreeHelper2.key2Value(map, "unit", PlanConstant.UNIT);
            TreeHelper2.key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            TreeHelper2.key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private static Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    public static void main(String[] args) {
        String ass = "[{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"5\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"4\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"3\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"2\",\"Cost\":0,\"Units\":1},{\"TaskUID\":1553032783452967225,\"ResourceUID\":\"1\",\"Cost\":0,\"Units\":1}]";
        JSONArray jsonArray = JSONArray.parseArray((String)ass);
        System.out.println(jsonArray.toJSONString());
        System.out.println(JSONObject.toJSONString((Object)JSONObject.parseArray((String)jsonArray.toString(), Map.class)));
    }
}

