package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlprogress.labor.bean.*;
import com.ejianc.business.jlprogress.labor.mapper.WorkerEnterRecordMapper;
import com.ejianc.business.jlprogress.labor.service.*;
import com.ejianc.business.jlprogress.labor.vo.WorkerEnterChangeVO;
import com.ejianc.business.jlprogress.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.WorkerEnterChangeMapper;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 劳务实名制-劳务进场单-变更
 * 
 * @author generator
 * 
 */
@Service("workerEnterChangeService")
public class WorkerEnterChangeServiceImpl extends BaseServiceImpl<WorkerEnterChangeMapper, WorkerEnterChangeEntity> implements IWorkerEnterChangeService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENTER_BILL_TYPE = "EJCBT202405000066";//劳务进场 billType
    private static final String CHANGE_BILL_TYPE = "EJCBT202405000067";//劳务进场单-变更 billType
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";// 身份证信息正面 sourceType
    private static final String IDBACK_TYPE = "idCardBack";// 身份证信息反面sourceType
    private static final String FACE_TYPE = "face";// 人脸 sourceType ORDER_TYPE
    @Autowired
    private WorkerEnterChangeMapper mapper;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private WorkerEnterRecordMapper workerEnterRecordMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IWorkerExitService workerExitService;
    @Autowired
    private IWorkerExitDetailService workerExitDetailService;

    @Override
    public WorkerEnterChangeEntity getUnFinishedChange(Long workerEnterId) {
        QueryWrapper<WorkerEnterChangeEntity> query = new QueryWrapper<>();
        query.eq("worker_enter_id", workerEnterId);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return mapper.selectOne(query);
    }


    @Override
    public WorkerEnterChangeEntity saveOrUpdateChange(WorkerEnterChangeEntity saveEntity) {
        super.saveOrUpdate(saveEntity, false);
        WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(saveEntity.getWorkerEnterId());
        if (1 != workerEnterEntity.getChangeState()) {
            workerEnterEntity.setChangeState(WorkerEnterVO.CHANGE_STATE_CHANGING);
            workerEnterEntity.setCurChangingId(saveEntity.getId());
            workerEnterService.saveOrUpdate(workerEnterEntity, false);
        }
        return saveEntity;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<WorkerEnterChangeEntity> changeList = mapper.selectBatchIds(changeIds);
        List<Long> workerEnterIds = changeList.stream().map(WorkerEnterChangeEntity::getWorkerEnterId).collect(Collectors.toList());

        QueryWrapper<WorkerEnterEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", workerEnterIds);
        List<WorkerEnterEntity> workerEnterList = workerEnterService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<WorkerEnterRecordEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, worker_enter_id as planId");
        query.in("worker_enter_id", workerEnterIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("worker_enter_id");

        List<Map<String, Object>> queryResult = workerEnterRecordMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));

        for (WorkerEnterEntity workerEnterEntity : workerEnterList) {
            workerEnterEntity.setChangeState((null != hisCountNumMap.get(workerEnterEntity.getId()) && hisCountNumMap.get(workerEnterEntity.getId()) > 0) ? 2 : 0); //未变更
            workerEnterEntity.setCurChangingId(null);
        }

        workerEnterService.saveOrUpdateBatch(workerEnterList, workerEnterList.size());
        // 删除附件
//		deleteAttachment(changeIds);
        super.removeByIds(changeList.stream().map(WorkerEnterChangeEntity::getId).collect(Collectors.toList()), false);
    }


    private void deleteAttachment(List<Long> changeIds) {
        for (Long changeId : changeIds) {
            CommonResponse<String> r1 = attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, IDCARD_SOURCE_TYPE);
            if (!r1.isSuccess()) {
                throw new BusinessException("删除身份证信息面附件失败");
            }
            CommonResponse<String> r2 = attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, IDBACK_TYPE);
            if (!r2.isSuccess()) {
                throw new BusinessException("删除身份证国徽面附件失败");
            }
            CommonResponse<String> r3 = attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, FACE_TYPE);
            if (!r3.isSuccess()) {
                throw new BusinessException("删除人脸附件失败");
            }
        }
    }


    @Override
    public void checkExit(WorkerEnterChangeVO workerEnterChangeVO) {
        LambdaQueryWrapper<WorkRecordEntity> query = Wrappers.lambdaQuery();
        query.eq(WorkRecordEntity::getSourceFlag, 1);
        query.eq(WorkRecordEntity::getSourceId, workerEnterChangeVO.getWorkerEnterId());
        query.eq(WorkRecordEntity::getProjectId, workerEnterChangeVO.getProjectId());
        query.eq(WorkRecordEntity::getLastFlag, 1);
        WorkRecordEntity workRecordEntity = workRecordService.getOne(query);

        if (null != workRecordEntity) {
            LambdaQueryWrapper<WorkerExitDetailEntity> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(WorkerExitDetailEntity::getWorkerId, workRecordEntity.getWorkerId());
            WorkerExitDetailEntity exitDetail = workerExitDetailService.getOne(wrapper);
            if (exitDetail != null) {
                WorkerExitEntity exit = workerExitService.getById(exitDetail.getWokerExitId());
                if (exit != null && exit.getBillState() != 1 && exit.getBillState() != 3) {
                    throw new BusinessException("存在未生效的退场单不能变更");
                }
            }
        }

    }
}
