package com.ejianc.business.jlprogress.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.WorktimeSetMapper;
import com.ejianc.business.jlprogress.labor.bean.WorktimeSetEntity;
import com.ejianc.business.jlprogress.labor.service.IWorktimeSetService;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 劳务实名制-考勤设置
 * 
 * @author generator
 * 
 */
@Service("worktimeSetService")
public class WorktimeSetServiceImpl extends BaseServiceImpl<WorktimeSetMapper, WorktimeSetEntity> implements IWorktimeSetService{
    private static final String QR_CODE_LOGIN_URL = "ejc-jlprogress-mobile/#/qrCodeLogin";
    private static final String CODE = "Weixin";
    private static final String SCOPE = "snsapi_base";
    private static final String STATE = "123";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Resource
    private IThirdSystemApi thirdSystemApi;

    /**
     * 考勤二维码
     *
     * @param id 考勤设置id
     *
     * @return {@link JSONObject}
     */
    @Override
    public JSONObject getQrCode(Long id) throws UnsupportedEncodingException {
        Assert.notNull(id, "考勤设置id不能为空！");
        WorktimeSetEntity entity = super.selectById(id);
        Assert.notNull(entity, "考勤设置信息不能为空！");

        JSONObject resp = new JSONObject();
        String sb = "?worktimeSetId=" + id +
                "&tenantId=" + entity.getTenantId() +
                "&projectId=" + entity.getProjectId() +
                "&projectName=" + entity.getProjectName();

        String redirectUri = BaseHost + QR_CODE_LOGIN_URL + sb;
        String redirectUrl = URLEncoder.encode(redirectUri, "UTF-8");

        CommonResponse<ThirdSystemVO> thirdSystemResponse = thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("获取微信公众号配置数据失败，失败原因：" + thirdSystemResponse.getMsg());
        }
        Assert.notNull(thirdSystemResponse.getData(), "获取微信公众号配置数据不能为空！");

        ThirdSystemVO thirdSystemVO = thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject(configInfo);
        String appId = configJson.getString("appid");

        String openWeixin = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
        openWeixin = openWeixin.replace("APPID", appId)
                .replace("REDIRECT_URI", redirectUrl)
                .replace("SCOPE", SCOPE)
                .replace("STATE", STATE);

        resp.put("mobileH5Url", openWeixin);
        resp.put("mobileWxUrl", openWeixin);
        return resp;
    }
}
