package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.order.bean.StoreEntity;
import com.ejianc.business.jlprogress.order.service.IStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.PriceMapper;
import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.service.IPriceService;

import java.util.List;

/**
 * 订单及运单-材料价格-主表
 * 
 * @author generator
 * 
 */
@Service("priceService")
public class PriceServiceImpl extends BaseServiceImpl<PriceMapper, PriceEntity> implements IPriceService{

    @Autowired
    private IStoreService storeService;
    @Autowired
    private PriceMapper priceMapper;
    @Override
    public StoreEntity getByStoreName(String storeName) {
        LambdaQueryWrapper<StoreEntity> storeEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        storeEntityLambdaQueryWrapper.eq(StoreEntity::getStoreName, storeName);
        StoreEntity store = storeService.getOne(storeEntityLambdaQueryWrapper);
        return store;
    }

    @Override
    public List<StoreEntity> queryStoreByStoreNames(List<String> storeNames) {
        List<StoreEntity> storeEntities = priceMapper.queryStoreByStoreNames(storeNames);
        return storeEntities;
    }
}
