package com.ejianc.business.jlprogress.progress.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.utils.SeparatorUtil;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.business.jlprogress.progress.utils.DetailListUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.JsonUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 执行计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("execPlan")
public class ExecPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectArchiveApi projectApi;

    @Autowired
    private IShareProjectWbsApi wbsApi;

    @Autowired
    private IExecPlanService service;

    @Autowired
    private IExecPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExecPlanVO> saveOrUpdate(@RequestBody ExecPlanVO saveOrUpdateVO) {
    	ExecPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetail(Long id) {
    	ExecPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecPlanVO> vos) {
        List<Long> ids = vos.stream().map(ExecPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.remove(new QueryWrapper<ExecPlanDetailEntity>().in("progress_id", ids));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        // 带出客户名称
        QueryParam queryParam = new QueryParam();
        Set<Long> ids = page.getRecords().stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toSet());
        if(CollectionUtils.isNotEmpty(ids)){
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        } else {
            queryParam.getParams().put("id", new Parameter(QueryParam.EQ, -1));
        }
        CommonResponse<Page<ProjectArchiveVO>> resp = projectApi.queryProjectArchivePage(queryParam);
        if(!resp.isSuccess()){
            return CommonResponse.error(resp.getMsg());
        }
        Map<Long, ProjectArchiveVO> map = resp.getData().getRecords().stream().collect(Collectors.toMap(x->x.getId(), x->x));
        List<ExecPlanVO> records = BeanMapper.mapList(page.getRecords(), ExecPlanVO.class);
        records.forEach(vo->{
            if(map.containsKey(vo.getProjectId())){
                vo.setCustomName(map.get(vo.getProjectId()).getCustomName());
            }
        });
  		pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExecPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExecPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> refExecPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExecPlanEntity> page = service.queryPage(param,false);
        IPage<ExecPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 执行计划明细参照
     * @param projectId 项目主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划，默认向上兼容，即为3时，查询"1,2,3"
     *                  ，参照哪级计划传哪个，一般不会参照周计划
     * @param startDate 到天即可，会处理成当天00:00:00
     * @param endDate   到天即可，会处理成当天23:59:59
     * @return
     */
    @RequestMapping(value = "/refExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanDetail(@RequestParam("projectId") Long projectId,
                                                        @RequestParam(value = "planState", required = false) Integer planState,
                                                        @RequestParam(value = "startDate", required = false) Date startDate,
                                                        @RequestParam(value = "endDate", required = false) Date endDate) {
        ExecPlanVO vo = service.queryRefDetail(projectId, planState, startDate, endDate);
        return CommonResponse.success("查询清单参照成功！", vo);
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    /**
     * @param vo id 执行计划主键
     * @param vo planState 1-总计划、2-年计划、3-月计划、4-周计划，默认总计划
     * @param vo startDate 到天即可，会处理成当天00:00:00，默认总计划计划开始时间
     * @param vo endDate   到天即可，会处理成当天23:59:59，默认总计划计划结束时间
     * @return
     */
    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    /**
     * 推送执行计划
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlan(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlan(id, planState);
        return CommonResponse.success("推送执行计划成功！", vo);
    }

    /**
     * 推送执行计划回退
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    @RequestMapping(value = "/pushExecPlanRollBack", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlanRollBack(@RequestParam("id") Long id, @RequestParam("planState") Integer planState) {
        ExecPlanEntity vo = service.pushExecPlanRollBack(id, planState);
        return CommonResponse.success("推送执行计划回退成功！", vo);
    }

    /**
     * @Description validateProject 校验项目下是否存在未生效单据
     * @param projectId 项目ID
     * @param billId 单据主键
     */
    @RequestMapping(value = "/validateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam("projectId") Long projectId,
                                                  @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateProject(projectId, billId);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description validateProject 校验项目下是否存在未生效单据
     */
    @RequestMapping(value = "/initTable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> initTable() {
        String msg = service.initTable();
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @选择执行计划节点参照
     * @param projectId 项目主键
     * @return ExecPlanVO
     */
    @RequestMapping(value = "/referExecPlanDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value = "projectId") Long projectId,
                                                          @RequestParam("fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        ExecPlanEntity entity = service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if(entity.getId() == null){
            throw new BusinessException("未查询到执行计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);

        // 过滤后置任务已开始的任务
        List<ExecPlanDetailEntity> actualList = detailList.stream().filter(x->x.getActualStart() != null).collect(Collectors.toList());
        Map<Long, ExecPlanDetailEntity> preMap = new HashMap<>();
        for(ExecPlanDetailEntity actual : actualList){
            List<ExecPlanDetailEntity> preList = TreeUtils.getPreLinkList(detailList, actual.getStructCode());
            if(CollectionUtils.isEmpty(preList)){
                continue;
            }
            preMap.putAll(preList.stream().collect(Collectors.toMap(x->x.getId(), x->x)));
        }

        // 符合条件的末级及其所有上级
        List<ExecPlanDetailEntity> leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x->new Integer(1).equals(x.getFinishState()) &&
                StringUtils.isNotEmpty(x.getEmployeeId()) && x.getEmployeeId().contains(String.valueOf(fillUserId))).collect(Collectors.toList());
        leafList = leafList.stream().filter(x->!preMap.containsKey(x.getId())).collect(Collectors.toList());
        Set<String> structCodes = leafList.stream().flatMap(x->SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List<ExecPlanDetailEntity> result = detailList.stream().filter(x->structCodes.contains(x.getStructCode())).collect(Collectors.toList());

        // 转换VO
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(result)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询做过总计划且责任人是自己的项目
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/projectListRefer")
    @ResponseBody
    public CommonResponse<JSONObject> projectListRefe(
            @RequestParam(defaultValue = "1") Integer pageNumber, @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        // 只查询做过总计划且责任人是自己的项目
        List<ExecPlanEntity> list = service.list();
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> execIds = list.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter(QueryParam.IN, execIds));
            detailParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
            List<ExecPlanDetailEntity> detailList = detailService.queryList(detailParam);
            Set<Long> ids = detailList.stream().map(x->x.getProgressId()).collect(Collectors.toSet());
            if(CollectionUtils.isNotEmpty(ids)){
                list = list.stream().filter(x->ids.contains(x.getId())).collect(Collectors.toList());
            } else {
                list = new ArrayList<>();
            }
        }
        Set<Long> ids = list.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toSet());
        if(CollectionUtils.isNotEmpty(ids)){
            param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        } else {
            param.getParams().put("id", new Parameter(QueryParam.EQ, -1));
        }

//        // 查询本下所有启用、在建的项目
//        param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1,2,3)));
        CommonResponse<Page<ProjectArchiveVO>> resp = projectApi.queryProjectArchivePage(param);
        if(!resp.isSuccess()){
            return CommonResponse.error(resp.getMsg());
        }
        Page<ProjectArchiveVO> page = resp.getData();
        IPage<ProjectArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(page.getRecords());
        return CommonResponse.success("项目参照查询成功！", JSONObject.parseObject(JSON.toJSONString(pageData)));
    }

    /**
     * 总计划根据选择wbs带出本上
     * projectId 必输
     * fillUserId 必输
     */
    @RequestMapping(value = "/getWbsListById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getWbsListById(@RequestParam(value = "projectId") Long projectId,
            @RequestParam("wbsId") Long wbsId) {
        CommonResponse<List<ProjectWbsVO>> resp = wbsApi.queryByProjectId(projectId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectWbsVO> wbsList = resp.getData();
        ProjectWbsVO entity = wbsList.stream().filter(x->wbsId.equals(x.getId())).findFirst().orElse(null);
        if(entity == null){
            return CommonResponse.success("未查询到该WBS！", new ArrayList<>());
        }
        // 本上
        List<String> innerCodes = SeparatorUtil.substringPre(entity.getInnerCode(), ",");
        List<ProjectWbsVO> result = wbsList.stream().filter(x->innerCodes.contains(x.getInnerCode())).collect(Collectors.toList());
        List<Map<String, Object>> map = ResultAsTree.createTreeData(BeanMapper.mapList(result, Map.class));
        return CommonResponse.success("查询详情数据成功！", map);
    }

    /**
     * 任务分解选择执行计划参照
     * projectId 必输
     * fillUserId 必输
     */
    @RequestMapping(value = "/referExecDetailWbs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecDetailWbs(@RequestParam(value = "projectId") Long projectId,
            @RequestParam("fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        ExecPlanEntity entity = service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if(entity.getId() == null){
            throw new BusinessException("未查询到总计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);

        Map<Long, ExecPlanDetailEntity> detailMap = detailList.stream().filter(x->StringUtils.isNotEmpty(x.getWbs())).collect(Collectors.toMap(x->Long.valueOf(x.getWbs()), x->x));
        List<ExecPlanDetailEntity> total = detailList.stream().filter(x->StringUtils.isNotEmpty(x.getEmployeeId()) &&
                x.getEmployeeId().contains(String.valueOf(fillUserId)) && PlanConstant.TOTAL_PLAN.equals(x.getPlanState())).collect(Collectors.toList());
        List<Long> wbsIds = total.stream().filter(x->StringUtils.isNotEmpty(x.getWbs())).map(x->Long.valueOf(x.getWbs())).collect(Collectors.toList());

        CommonResponse<List<ProjectWbsVO>> resp = wbsApi.queryByProjectId(projectId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<ProjectWbsVO> wbsList = resp.getData();
        // 责任人是自己及其上级和下级
        List<String> codes = wbsList.stream().filter(x->wbsIds.contains(x.getId())).map(x->x.getInnerCode()).collect(Collectors.toList());
        Set<String> innerCodes = codes.stream().flatMap(x->SeparatorUtil.substringPre(x, ",").stream()).collect(Collectors.toSet());
        Set<ProjectWbsVO> vos = wbsList.stream().filter(x->innerCodes.contains(x.getInnerCode())).collect(Collectors.toSet());// 本上
        for(ProjectWbsVO detail : wbsList){
            for(String code : codes){
                if(detail.getInnerCode().startsWith(code)){
                    vos.add(detail);// 本下
                }
            }
        }
        List<ExecPlanDetailEntity> result = new ArrayList<>();
        for(ProjectWbsVO wbs : vos){
            ExecPlanDetailEntity vo = new ExecPlanDetailEntity();
            vo.setCode(wbs.getCode());
            vo.setDuration(1);
            if(detailMap.containsKey(wbs.getId())){
                vo = detailMap.get(wbs.getId());
            }
            if(!PlanConstant.TOTAL_PLAN.equals(vo.getPlanState())){
                vo.setPlanState(null);
                vo.setPredictFinish(null);
                vo.setFixedDate(0);
            }
            vo.setId(wbs.getId());
            vo.setParentId(wbs.getParentId());
            vo.setName(wbs.getName());
            vo.setNodeLevel(wbs.getWbsType());
            vo.setProgressId(entity.getId());
            vo.setWbs(wbs.getId().toString());
            vo.setWbsParent(null != wbs.getParentId() ? wbs.getParentId().toString() : null);
            vo.setOutlineNumber(null != wbs.getParentId() ? wbs.getCode() : "0");
            result.add(vo);
        }
        // 转换VO
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(result)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            detailVOList = TreeHelper2.entrySort(detailVOList);
            List<ExecPlanDetailVO> tree = TreeHelper2.list2Tree(detailVOList);
            TreeHelper2.resetOutlineNumber(tree,  null);
            vo.setProgressDetailList(tree);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 任务反馈选择执行计划参照
     * projectId 必输
     * fillUserId 必输
     */
    @RequestMapping(value = "/referExecDetailWbsFill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecDetailWbsFill(@RequestParam(value = "projectId") Long projectId,
            @RequestParam("fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        ExecPlanEntity entity = service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if(entity.getId() == null){
            throw new BusinessException("未查询到总计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);

        // 符合条件的末级及其所有上级
        List<ExecPlanDetailEntity> leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x->StringUtils.isNotEmpty(x.getEmployeeId()) && x.getEmployeeId().contains(String.valueOf(fillUserId))).collect(Collectors.toList());
        Set<String> structCodes = leafList.stream().flatMap(x->SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List<ExecPlanDetailEntity> result = detailList.stream().filter(x->structCodes.contains(x.getStructCode())).collect(Collectors.toList());

        // 停用过滤及名称取最新替换
        CommonResponse<List<ProjectWbsVO>> resp = wbsApi.queryByProjectId(projectId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        Map<String, ProjectWbsVO> map = resp.getData().stream().collect(Collectors.toMap(x->String.valueOf(x.getId()), x->x));
        result = result.stream().filter(x->map.keySet().contains(x.getWbs())).map(x->{
            x.setName(map.get(x.getWbs()).getName());
            return x;
        }).collect(Collectors.toList());

        // 转换VO
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(result)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description 导出
     * @param projectId
     * @Return void
     */
    @RequestMapping(value = "/excelExportDetail", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetail(@RequestBody Long projectId, HttpServletResponse response) {
        QueryWrapper<ExecPlanEntity> ew = new QueryWrapper<>();
        ew.eq("project_id", projectId);
        ExecPlanEntity entity = service.getOne(ew);
        if(entity == null){
            throw new BusinessException("未查询到项目下的总计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> dw = new QueryWrapper<>();
        dw.eq("progress_id", entity.getId());
        dw.orderByAsc("tid");
        List<ExecPlanDetailEntity> list = detailService.list(dw);
        List<ExecPlanDetailEntity> tree = TreeUtils.listToTree(list);
        TreeUtils.resetOutlineNumber(tree,  null);
        list = TreeUtils.treeToList(tree);
        list = list.stream().sorted(Comparator.comparing(ExecPlanDetailEntity::getTid)).collect(Collectors.toList());
        //todo:字段翻译等等
        JSONArray records = new JSONArray();
        for(int i = 0; i < list.size(); i++){
            ExecPlanDetailEntity vo = list.get(i);
            JSONObject obj = (JSONObject) JSONObject.toJSON(vo);
            obj.put("index", i+1);
            obj.put("nodeLevel", PlanConstant.NODE_LEVEL.get(vo.getNodeLevel()));
            obj.put("unit", PlanConstant.UNIT.get(vo.getUnit()));
            records.add(obj);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ExecPlanDetail-export.xlsx", beans, response);
    }



    /**
     * 根据项目id查询单据详情
     * projectId 必输
     */
    @RequestMapping(value = "/queryDetailByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetailByProject(@RequestParam(value = "projectId") Long projectId) {
        List<ExecPlanEntity> entities = service.list(new LambdaQueryWrapper<ExecPlanEntity>().eq(ExecPlanEntity::getProjectId, projectId));
        if (CollectionUtils.isEmpty(entities)){
            return CommonResponse.success("未查询到对应数据！");
        }
        ExecPlanVO vo = service.queryDetail(entities.get(0).getId());
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询组织下延期任务
     * @param orgId 非必输，当前登录组织
     * @param type  非必输，默认产品，project-项目（根据项目汇总）
     * @return
     */
    @RequestMapping(value = "/queryDeferDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONArray> queryDeferDetail(@RequestParam(value = "orgId", required = false) Long orgId,
            @RequestParam(value = "type", required = false) String type) {
        if(null == orgId){
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ExecPlanEntity> execList = service.queryList(param);
        if(CollectionUtils.isEmpty(execList)){
            return CommonResponse.success("查询数据为空！", new JSONArray());
        }
        Map<Long, ExecPlanEntity> map = execList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        // 类型为“产品”，当前日期大于完成日期且累计完成数量小于计划数量
        QueryWrapper<ExecPlanDetailEntity> dw = new QueryWrapper<>();
        dw.in("progress_id", map.keySet());
        dw.eq("node_level", 3);
        dw.lt("finish", DateUtil.formatSeconds(new Date()));
        dw.last(" and ifnull(finish_num, 0) < ifnull(plan_num, 0)");
        List<ExecPlanDetailEntity> list = detailService.list(dw);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询数据为空！", new JSONArray());
        }
        JSONArray result = new JSONArray();
        if("project".equals(type)){
            Map<Long, List<ExecPlanDetailEntity>> group = list.stream().collect(Collectors.groupingBy(x->x.getProgressId()));
            for(Long id : group.keySet()){
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(group.get(id).get(0));
                JSONObject obj = JSONObject.parseObject(JsonUtils.object2JsonStr(vo));
                obj.put("projectName", map.get(id).getProjectName());
                obj.put("num", group.get(id).size());
                result.add(obj);
            }
        } else {
            for(ExecPlanDetailEntity detail : list) {
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
                vo.setDiffNum(ComputeUtil.safeSub(vo.getPlanNum(), vo.getFinishNum()));
                vo.setDiffValue(ComputeUtil.toBigDecimal(DateUtil.getSubDay(new Date(), vo.getFinish())));
                JSONObject obj = JSONObject.parseObject(JsonUtils.object2JsonStr(vo));
                obj.put("projectName", map.get(detail.getProgressId()).getProjectName());
                result.add(obj);
            }
        }
        return CommonResponse.success("查询成功！", result);
    }
}
