package com.ejianc.business.jlprogress.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.quality.bean.WorkTimeDetailEntity;

/**
 * 质量检测-工时结算-主表
 *
 * @author generator
 */
@TableName("ejc_quality_work_time")
public class WorkTimeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 工时单号
    @TableField(value = "date")
    private Date date; // 日期
    @TableField(value = "org_id")
    private Long orgId; // 生产厂
    @TableField(value = "org_name")
    private String orgName; // 生产厂名称
    @TableField(value = "org_code")
    private String orgCode; //生产厂code
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value = "employee_id")
    private Long employeeId; // 填表人
    @TableField(value = "employee_name")
    private String employeeName; // 填表人名称
    @TableField(value = "create_employee_id")
    private Long createEmployeeId; // 创建人
    @TableField(value = "create_employee_name")
    private String createEmployeeName; // 创建人名称
    @TableField(value = "create_department_id")
    private Long createDepartmentId; // 创建人部门
    @TableField(value = "create_department_name")
    private String createDepartmentName; // 创建人部门名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist = false)
    @SubEntity(serviceName = "workTimeDetailService", pidName = "workTimeId")
    private List<WorkTimeDetailEntity> workTimeDetailList = new ArrayList<>(); // 质量检测-工时结算-子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCreateEmployeeId() {
        return createEmployeeId;
    }

    public void setCreateEmployeeId(Long createEmployeeId) {
        this.createEmployeeId = createEmployeeId;
    }

    public String getCreateEmployeeName() {
        return createEmployeeName;
    }

    public void setCreateEmployeeName(String createEmployeeName) {
        this.createEmployeeName = createEmployeeName;
    }

    public Long getCreateDepartmentId() {
        return createDepartmentId;
    }

    public void setCreateDepartmentId(Long createDepartmentId) {
        this.createDepartmentId = createDepartmentId;
    }

    public String getCreateDepartmentName() {
        return createDepartmentName;
    }

    public void setCreateDepartmentName(String createDepartmentName) {
        this.createDepartmentName = createDepartmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<WorkTimeDetailEntity> getWorkTimeDetailList() {
        return workTimeDetailList;
    }

    public void setWorkTimeDetailList(List<WorkTimeDetailEntity> workTimeDetailList) {
        this.workTimeDetailList = workTimeDetailList;
    }
}
