package com.ejianc.business.jlprogress.quality.controller;

import java.io.IOException;
import java.io.Serializable;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.vo.PlanDetailVO;
import com.ejianc.business.jlprogress.quality.bean.SupplyConfirmEntity;
import com.ejianc.business.jlprogress.quality.bean.SupplyDetailEntity;
import com.ejianc.business.jlprogress.quality.service.ISupplyConfirmService;
import com.ejianc.business.jlprogress.quality.service.ISupplyDetailService;
import com.ejianc.business.jlprogress.quality.service.impl.SupplyBpmServiceImpl;
import com.ejianc.business.jlprogress.quality.vo.DetectReportVO;
import com.ejianc.business.jlprogress.quality.vo.SupplyConfirmVO;
import com.ejianc.business.jlprogress.quality.vo.SupplyDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.service.ISupplyService;
import com.ejianc.business.jlprogress.quality.vo.SupplyVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 物资供货单
 *
 * @author generator
 */
@Controller
@RequestMapping("supply")
public class SupplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;

    private static final String BILL_CODE = "WZGH";//此处需要根据实际修改

    @Autowired
    private ISupplyService service;

    @Autowired
    private ISupplyConfirmService confirmService;


    @Autowired
    private ISupplyDetailService detailsService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplyVO> saveOrUpdate(@RequestBody SupplyVO saveOrUpdateVO) {
        SupplyVO supplyVO = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", supplyVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplyVO> queryDetail(Long id) {
        SupplyEntity entity = service.selectById(id);
        SupplyVO vo = BeanMapper.map(entity, SupplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SupplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("useMemo");
        fuzzyFields.add("productionMemo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SupplyEntity> page = service.queryPage(param, false);
        IPage<SupplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SupplyVO> records = new ArrayList<>();
        CommonResponse<IPage<SupplyVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        records.stream().forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Supply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSupplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplyVO>> refSupplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) throws IOException {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("purchaseName");
        fuzzyFields.add("useMemo");
        fuzzyFields.add("productionMemo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("referenceFlag")) {
                param.getParams().put("referenceFlag", new Parameter(QueryParam.EQ, _con.getString("referenceFlag")));
            }
            String excludeIdStr = _con.getString("excludeIds");
            if (StringUtils.isNotBlank(excludeIdStr)) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeIdStr.split(","))));
            }
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        System.out.println("condition:" + condition);
        //供货确认单 前端带值condition
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject conditionJson = JSONObject.parseObject(condition);
            if (conditionJson.containsKey("flag")) {
                String flag = String.valueOf(conditionJson.get("flag"));
                if ("supplyConfirm".equals(flag)) {
                    //查询确认单中的全部数据
                    List<SupplyConfirmEntity> confirmList = confirmService.list();
                    //筛选出确认单中的供货单id
                    List<Long> supplyIds = confirmList.stream().map(SupplyConfirmEntity::getSupplyId).distinct().collect(Collectors.toList());
                    //查询，去掉供货单确认单中被参照过的供货单
                    param.getParams().put("id", new Parameter(QueryParam.NOT_IN, supplyIds));
                }
            }
        }
        IPage<SupplyEntity> page = service.queryPage(param, false);
        IPage<SupplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplyVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @RequestMapping(value = "/refSupplyDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplyDetailVO>> refSupplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("model");
        fuzzyFields.add("texture");
        fuzzyFields.add("batchNumber");
        fuzzyFields.add("weightNum");
        fuzzyFields.add("num");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("supplyId")) {
                param.getParams().put("supplyId", new Parameter(QueryParam.EQ, _con.getString("supplyId")));
            }
        }
        IPage<SupplyDetailEntity> page = detailsService.queryPage(param, false);
        IPage<SupplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplyDetailVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SupplyDetail-import.xlsx", "无聊供货-物料明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SupplyDetailVO> successList = new ArrayList<>();
        List<SupplyDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }

                CommonResponse<List<MaterialVO>> materialRes = iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
                if (!materialRes.isSuccess()) {
                    return CommonResponse.error(materialRes.getMsg());
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));


                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SupplyDetailVO detailVO = new SupplyDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(0);
                    detailVO.setMaterialCode(materialCode);
                    //材料code  材料Id赋值
                    try {
                        if (ObjectUtils.isEmpty(map.get(materialCode))) {
                            throw new Exception("没有此材料！");
                        }

                        detailVO.setMaterialId(map.get(materialCode).getId());
                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                    } catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！");
                        errorList.add(detailVO);
                        continue;
                    }

                    detailVO.setTexture(datas.get(4));
                    detailVO.setBatchNumber(datas.get(5));
                    //重量  校验赋值
                    try {
                        detailVO.setWeightNum(BigDecimal.valueOf(Double.parseDouble(datas.get(6))));
                    } catch (Exception e) {
                        detailVO.setErrorMsg("重量不能为空或重量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //数量  校验赋值
                    try {
                        if (StringUtils.isNotEmpty(datas.get(7))){
                            detailVO.setNum(BigDecimal.valueOf(Double.parseDouble(datas.get(7))));
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("数量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //备注
                    detailVO.setMemo(datas.get(8));
/*                    //给备注值
                    String memo = datas.get(7);
                    detailVO.setMemo(memo);*/
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}