/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.quality.bean.FinishedCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IFinishedCheckService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finishedCheck")
public class FinishedCheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IFinishedCheckService service;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishedCheckEntity entity = (FinishedCheckEntity)((Object)this.service.selectById(billId));
        BigDecimal num = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)entity.getTotalNum(), (BigDecimal)entity.getQualifiedScale()), (BigDecimal)new BigDecimal("100"));
        this.logger.info("\u56de\u5199\u6267\u884c\u8ba1\u5212\u660e\u7ec6\u5b8c\u6210\u91cf----" + num);
        this.execPlanDetailService.writeBackFinishNum(String.valueOf(entity.getWbsId()), num, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        FinishedCheckEntity entity = (FinishedCheckEntity)((Object)this.service.selectById(billId));
        this.service.validateFill(entity.getProjectId());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        FinishedCheckEntity entity = (FinishedCheckEntity)((Object)this.service.selectById(billId));
        BigDecimal num = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)entity.getTotalNum(), (BigDecimal)entity.getQualifiedScale()), (BigDecimal)new BigDecimal("100"));
        this.execPlanDetailService.writeBackFinishNum(String.valueOf(entity.getWbsId()), num, false);
        return CommonResponse.success();
    }
}

