/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="processCheck")
public class ProcessCheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProcessCheckService service;
    @Autowired
    private IUserApi userApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IShareProjectWbsApi wbsApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProcessCheckEntity entity = (ProcessCheckEntity)((Object)this.service.selectById(billId));
        CommonResponse response = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        this.logger.info("\u5355\u5b50\u7684\u521b\u5efa\u4eba\u7684code\uff1a" + entity.getCreateUserCode());
        this.logger.info("\u5f53\u524d\u767b\u5f55\u4eba\u7684code\uff1a" + ((UserVO)response.getData()).getUserCode());
        if (!entity.getCreateUserCode().equals(((UserVO)response.getData()).getUserCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0e\u5236\u5355\u4eba\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProcessCheckEntity entity = (ProcessCheckEntity)((Object)this.service.selectById(billId));
        BigDecimal num = entity.getQualifiedNum();
        String wbs = null;
        CommonResponse resp = this.wbsApi.queryByProjectId(entity.getProjectId());
        if (resp.isSuccess() && null != resp.getData()) {
            for (ProjectWbsVO vo : (List)resp.getData()) {
                if (null == vo.getProcessId() || !vo.getProcessId().equals(entity.getProcessId()) || !StringUtils.isEmpty(wbs) && !entity.getWbsId().equals(vo.getParentId())) continue;
                wbs = String.valueOf(vo.getId());
            }
        }
        this.logger.info("\u56de\u5199\u6267\u884c\u8ba1\u5212\u660e\u7ec6{}\u5b8c\u6210\u91cf{}", wbs, (Object)num.toPlainString());
        this.execPlanDetailService.writeBackFinishNum(wbs, num, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        ProcessCheckEntity entity = (ProcessCheckEntity)((Object)this.service.selectById(billId));
        CommonResponse response = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!entity.getCreateUserCode().equals(((UserVO)response.getData()).getUserCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0e\u5236\u5355\u4eba\u4e0d\u4e00\u81f4\uff0c\u7981\u6b62\u64a4\u56de");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProcessCheckEntity entity = (ProcessCheckEntity)((Object)this.service.selectById(billId));
        BigDecimal num = entity.getQualifiedNum();
        String wbs = null;
        CommonResponse resp = this.wbsApi.queryByProjectId(entity.getProjectId());
        if (resp.isSuccess() && null != resp.getData()) {
            for (ProjectWbsVO vo : (List)resp.getData()) {
                if (null == vo.getProcessId() || !vo.getProcessId().equals(entity.getProcessId()) || !StringUtils.isEmpty(wbs) && !entity.getWbsId().equals(vo.getParentId())) continue;
                wbs = String.valueOf(vo.getId());
            }
        }
        this.logger.info("\u56de\u5199\u6267\u884c\u8ba1\u5212\u660e\u7ec6{}\u5b8c\u6210\u91cf{}", wbs, (Object)num.toPlainString());
        this.execPlanDetailService.writeBackFinishNum(wbs, num, false);
        return CommonResponse.success();
    }
}

