/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.tech.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.tech.bean.TechOrderDetailEntity;
import com.ejianc.business.jlprogress.tech.bean.TechOrderEntity;
import com.ejianc.business.jlprogress.tech.service.ITechOrderDetailService;
import com.ejianc.business.jlprogress.tech.service.ITechOrderService;
import com.ejianc.business.jlprogress.tech.vo.TechOrderDetailVO;
import com.ejianc.business.jlprogress.tech.vo.TechOrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"techOrder"})
public class TechOrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TECH-ORDER";
    @Autowired
    private ITechOrderService service;
    @Autowired
    private ITechOrderDetailService techOrderDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TechOrderVO> saveOrUpdate(@RequestBody TechOrderVO saveOrUpdateVO) {
        int curCount;
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq((Object)"DATE_FORMAT(month, '%Y-%m' )", (Object)saveOrUpdateVO.getMonth());
        if (saveOrUpdateVO.getId() != null) {
            curQuery.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((curCount = this.service.count((Wrapper)curQuery)) > 0) {
            throw new BusinessException("\u4e00\u4e2a\u6708\u53ea\u80fd\u505a\u4e00\u6761\u6570\u636e\uff01");
        }
        TechOrderEntity entity = (TechOrderEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), TechOrderEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TechOrderVO vo = (TechOrderVO)((Object)BeanMapper.map((Object)((Object)entity), TechOrderVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TechOrderVO> queryDetail(Long id) {
        TechOrderEntity entity = (TechOrderEntity)((Object)this.service.selectById(id));
        TechOrderVO vo = (TechOrderVO)((Object)BeanMapper.map((Object)((Object)entity), TechOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/selectLastDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TechOrderDetailVO>> queryDetail(String month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = format.parse(month);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        Date time = calendar.getTime();
        String lastDate = format.format(time);
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq((Object)"DATE_FORMAT(month, '%Y-%m' )", (Object)lastDate);
        curQuery.in((Object)"bill_state", new Object[]{1, 3});
        TechOrderEntity techOrderEntity = (TechOrderEntity)((Object)this.service.getOne((Wrapper)curQuery));
        List techOrderDetailEntities = new ArrayList();
        if (techOrderEntity != null) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(TechOrderDetailEntity::getMid, (Object)techOrderEntity.getId());
            lambdaQueryWrapper.eq(TechOrderDetailEntity::getPropertyCode, (Object)"1");
            List list = this.techOrderDetailService.list((Wrapper)lambdaQueryWrapper);
            techOrderDetailEntities = BeanMapper.mapList((Iterable)list, TechOrderDetailVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", techOrderDetailEntities);
    }

    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"tech-order-import.xlsx", (String)"\u5728\u6267\u884c\u8ba2\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<TechOrderDetailVO> successList = new ArrayList<TechOrderDetailVO>();
        ArrayList processList = new ArrayList();
        ArrayList<TechOrderDetailVO> errorList = new ArrayList<TechOrderDetailVO>();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode("tect-doc-type");
        if (!defDocByDefCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6863\u6848\u4fe1\u606f\u5931\u8d25!");
        }
        List defDocByDefCodeData = (List)defDocByDefCode.getData();
        Map defdocDetailVOTechMap = defDocByDefCodeData.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        CommonResponse defDocByDefCodeStatus = this.defdocApi.getDefDocByDefCode("tech-status");
        if (!defDocByDefCodeStatus.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6863\u6848\u4fe1\u606f\u5931\u8d25!");
        }
        List defDocByDefCodeDataStataus = (List)defDocByDefCodeStatus.getData();
        Map defdocDetailVOStatusMap = defDocByDefCodeDataStataus.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap codeMapCache = new HashMap();
            TechOrderDetailVO importVo = null;
            for (int i = 0; i < result.size(); ++i) {
                DefdocDetailVO defdocDetailVO;
                List datas = (List)result.get(i);
                importVo = new TechOrderDetailVO();
                importVo.setId(IdWorker.getId());
                String projectCode = (String)datas.get(1);
                importVo.setProjectCode((String)datas.get(1));
                if (StringUtils.isBlank((CharSequence)projectCode)) {
                    importVo.setErrorMsg("\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)projectCode)) {
                    CommonResponse projectArchiveByCode = this.projectArchiveApi.getProjectArchiveByCode(projectCode);
                    if (!projectArchiveByCode.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    ProjectArchiveVO projectArchiveByCodeData = (ProjectArchiveVO)projectArchiveByCode.getData();
                    if (projectArchiveByCodeData != null) {
                        importVo.setProjectId(projectArchiveByCodeData.getId());
                        importVo.setProjectName(projectArchiveByCodeData.getName());
                        importVo.setCustomerId(projectArchiveByCodeData.getCustomId());
                        importVo.setCustomerName(projectArchiveByCodeData.getCustomName());
                    } else {
                        importVo.setErrorMsg("\u9879\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                importVo.setProduct((String)datas.get(3));
                importVo.setSpec((String)datas.get(4));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    if (DateUtil.grepDate((String)datas.get(5))) {
                        importVo.setReceiptDate(DateUtil.Date((String)datas.get(5)));
                    } else {
                        importVo.setErrorMsg("\u63a5\u6536\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    if (DateUtil.grepDate((String)datas.get(6))) {
                        importVo.setProductionDate(DateUtil.Date((String)datas.get(6)));
                    } else {
                        importVo.setErrorMsg("\u6295\u4ea7\u4ea4\u8d27\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                importVo.setResponseName((String)datas.get(7));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    if ("\u662f".equals(datas.get(8))) {
                        importVo.setGrantType(1);
                    } else if ("\u5426".equals(datas.get(8))) {
                        importVo.setGrantType(0);
                    } else {
                        importVo.setErrorMsg("\u56fe\u7eb8\u53ca\u5de5\u827a\u662f\u5426\u4e0b\u53d1\u6570\u636e\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    if (DateUtil.grepDate((String)datas.get(9))) {
                        importVo.setDrawDate(DateUtil.Date((String)datas.get(9)));
                    } else {
                        importVo.setErrorMsg("\u56fe\u7eb8\u53ca\u5de5\u827a\u4e0b\u53d1\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    if (defdocDetailVOTechMap.containsKey(datas.get(10))) {
                        defdocDetailVO = (DefdocDetailVO)defdocDetailVOTechMap.get(datas.get(10));
                        importVo.setTechId(defdocDetailVO.getId());
                        importVo.setTechName(defdocDetailVO.getName());
                    } else {
                        importVo.setErrorMsg("\u6280\u672f\u6587\u4ef6\u7c7b\u578b\u4e0d\u5728\u81ea\u5b9a\u4e49\u6863\u6848\u5e93\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    if (defdocDetailVOStatusMap.containsKey(datas.get(12))) {
                        defdocDetailVO = (DefdocDetailVO)defdocDetailVOStatusMap.get(datas.get(12));
                        importVo.setStatusId(defdocDetailVO.getId());
                        importVo.setStatusName(defdocDetailVO.getName());
                        importVo.setPropertyCode(defdocDetailVO.getAttrCode());
                    } else {
                        importVo.setErrorMsg("\u72b6\u6001\u4e0d\u5728\u81ea\u5b9a\u4e49\u6863\u6848\u5e93\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    if (DateUtil.grepDate((String)datas.get(11))) {
                        importVo.setTechDate(DateUtil.Date((String)datas.get(11)));
                    } else {
                        importVo.setErrorMsg("\u6280\u672f\u6587\u4ef6\u4e0b\u53d1\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                successList.add(importVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TechOrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TechOrderVO techOrderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TechOrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TechOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TechOrder-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTechOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TechOrderVO>> refTechOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TechOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

