/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sales")
public class SalesBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISalesService service;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private SalesMapper mapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SalesEntity entity = (SalesEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SalesEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQueryWrapper.in(SalesEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.\u751f\u4ea7\u9636\u6bb5.getCode(), entity.getProjectId(), entity.getId(), Boolean.valueOf(this.service.list((Wrapper)lambdaQueryWrapper).size() > 0), Boolean.valueOf(true));
        this.mapper.changeContractCustomer(entity.getContractId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCustomerCode());
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        CommonResponse projectArchiveData = this.projectArchiveApi.getProjectArchiveById(entity.getProjectId());
        this.logger.info("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)projectArchiveData));
        ProjectArchiveVO projectArchiveVO = (ProjectArchiveVO)projectArchiveData.getData();
        if (null == projectArchiveVO.getCustomId() && null != entity.getCustomerId()) {
            projectArchiveVO.setCustomId(entity.getCustomerId());
            projectArchiveVO.setCustomName(entity.getCustomerName());
            projectArchiveVO.setCustomCode(entity.getCustomerCode());
            projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.\u751f\u4ea7\u9636\u6bb5.getCode());
            CommonResponse updateResponse = this.projectArchiveApi.updateProjectData(projectArchiveVO);
            if (!updateResponse.isSuccess()) {
                throw new BusinessException("\u66f4\u65b0\u9879\u76ee\u4fe1\u606f-\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        SalesEntity entity = (SalesEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SalesEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQueryWrapper.in(SalesEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.\u751f\u4ea7\u9636\u6bb5.getCode(), entity.getProjectId(), entity.getId(), Boolean.valueOf(this.service.list((Wrapper)lambdaQueryWrapper).size() > 0), Boolean.valueOf(false));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }
}

