/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.bean.ProjectTeamEntity;
import com.ejianc.business.jlprogress.labor.bean.WorkRecordEntity;
import com.ejianc.business.jlprogress.labor.bean.WorkerEnterEntity;
import com.ejianc.business.jlprogress.labor.enums.LastFlagEnum;
import com.ejianc.business.jlprogress.labor.mapper.WorkRecordMapper;
import com.ejianc.business.jlprogress.labor.service.IAttendanceService;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.service.IWorkerEnterService;
import com.ejianc.business.jlprogress.labor.vo.ProjectRecordVO;
import com.ejianc.business.jlprogress.labor.vo.WorkRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workRecordService")
public class WorkRecordServiceImpl
extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity>
implements IWorkRecordService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RECORD_BILL_TYPE = "EJCBT202405000065";
    private static final String ENTER_BILL_TYPE = "EJCBT202405000066";
    private static final String WORKER_BILL_TYPE = "EJCBT202405000028";
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";
    private static final String IDBACK_TYPE = "idCardBack";
    private static final String FACE_TYPE = "face";
    private static final String ORDER_TYPE = "desc";
    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    IAttendanceService attendanceService;

    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList) {
        ArrayList<WorkRecordVO> returnList = new ArrayList<WorkRecordVO>();
        for (WorkRecordVO vo : voList) {
            WorkRecordEntity one;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)vo.getProjectId());
            query.eq((Object)"last_flag", (Object)LastFlagEnum.\u662f.getStatus());
            query.eq((Object)"worker_id", (Object)vo.getWorkerId());
            if (vo.getId() != null) {
                query.ne((Object)"id", (Object)vo.getId());
            }
            if ((one = (WorkRecordEntity)((Object)super.getOne((Wrapper)query))) != null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(WorkRecordEntity::getLastFlag, (Object)LastFlagEnum.\u5426.getStatus());
                wrapper.eq(BaseEntity::getId, (Object)one.getId());
                super.update((Wrapper)wrapper);
            }
            WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
            if (vo.getWorkType() != null && vo.getWorkType().isEmpty()) {
                entity.setWorkType(null);
                entity.setWorkTypeName(null);
            }
            entity.setLastFlag(LastFlagEnum.\u662f.getStatus());
            this.logger.info("\u65b0\u589e\u6216\u66f4\u65b0\u8fdb\u573a\u8bb0\u5f55-{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != workRecordEntity) {
                entity.setVersion(workRecordEntity.getVersion());
                workRecordEntity = (WorkRecordEntity)((Object)BeanMapper.map((Object)((Object)entity), WorkRecordEntity.class));
                workRecordEntity.setVersion(entity.getVersion());
                super.saveOrUpdate((Object)workRecordEntity);
            } else {
                super.saveOrUpdate((Object)entity);
            }
            WorkRecordVO recordVO = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
            returnList.add(recordVO);
            this.orgToProjectCertified(entity);
        }
        return returnList;
    }

    void orgToProjectCertified(WorkRecordEntity entity) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s : typeList) {
            CommonResponse deleteFileByParam;
            CommonResponse orgIdCardResponse = this.attachmentApi.queryListBySourceId(entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
            if (!orgIdCardResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgIdCardResponse.getData())) && !(deleteFileByParam = this.attachmentApi.deleteFileByParam(entity.getId(), RECORD_BILL_TYPE, s)).isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u5220\u9664\u5931\u8d25");
            }
            CommonResponse orgIdCardResponseTow = this.attachmentApi.queryListBySourceId(entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
            this.logger.info("****************:{}", (Object)JSON.toJSONString((Object)orgIdCardResponseTow));
        }
    }

    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        WorkerEnterEntity workerEnterEntity;
        WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
        super.saveOrUpdate((Object)entity, false);
        if (entity.getSourceFlag() == 1 && (workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(entity.getSourceId()))) != null) {
            if (entity.getSubContractId() != null) {
                workerEnterEntity.setSubContractId(entity.getSubContractId());
                workerEnterEntity.setSubContractName(entity.getSubContractName());
                workerEnterEntity.setSupplierId(entity.getSupplierId());
                workerEnterEntity.setSubContractName(entity.getSupplierName());
            }
            this.workerEnterService.saveOrUpdate((Object)workerEnterEntity);
        }
        WorkRecordVO returnVo = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        returnVo.setBillState(Integer.valueOf(0));
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List ids = updateVO.getIds();
        String teamId = updateVO.getTeamId();
        String teamName = updateVO.getTeamName();
        String workType = updateVO.getWorkType();
        String workTypeName = updateVO.getWorkTypeName();
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", (Collection)ids);
            List list = super.list((Wrapper)queryWrapper);
            ArrayList<Long> workerEntities = new ArrayList<Long>();
            ArrayList<Long> enterEntities = new ArrayList<Long>();
            for (WorkRecordEntity record : list) {
                if (record.getSourceFlag() == 1) {
                    enterEntities.add(record.getSourceId());
                }
                workerEntities.add(record.getWorkerId());
            }
            if (teamName != null || workType != null || subContractId != null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                LambdaUpdateWrapper enterWrapper = new LambdaUpdateWrapper();
                wrapper.set(teamId != null, WorkRecordEntity::getTeamId, (Object)teamId);
                wrapper.set(teamId != null, WorkRecordEntity::getTeamName, (Object)teamName);
                wrapper.set(workType != null, WorkRecordEntity::getWorkType, (Object)workType);
                wrapper.set(workTypeName != null, WorkRecordEntity::getWorkTypeName, (Object)workTypeName);
                wrapper.set(supplierId != null, WorkRecordEntity::getSupplierId, (Object)supplierId);
                wrapper.set(supplierName != null, WorkRecordEntity::getSupplierName, (Object)supplierName);
                wrapper.set(subContractId != null, WorkRecordEntity::getSubContractId, (Object)subContractId);
                wrapper.set(subContractName != null, WorkRecordEntity::getSubContractName, (Object)subContractName);
                wrapper.in(BaseEntity::getId, (Collection)ids);
                enterWrapper.set(supplierId != null, WorkerEnterEntity::getSupplierId, (Object)supplierId);
                enterWrapper.set(supplierName != null, WorkerEnterEntity::getSupplierName, (Object)supplierName);
                enterWrapper.set(subContractId != null, WorkerEnterEntity::getSubContractId, (Object)subContractId);
                enterWrapper.set(subContractName != null, WorkerEnterEntity::getSubContractName, (Object)subContractName);
                enterWrapper.in(BaseEntity::getId, enterEntities);
                super.update((Wrapper)wrapper);
                if (subContractId != null && CollectionUtils.isNotEmpty(enterEntities)) {
                    this.workerEnterService.update((Wrapper)enterWrapper);
                }
            }
        }
        return updateVO;
    }

    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return ((WorkRecordMapper)this.baseMapper).updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }

    @Override
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(int pageNumber, int pageSize, String relyCondition, String searchText, String condition, String searchObject) throws ParseException {
        Long teamId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            ProjectTeamEntity team = (ProjectTeamEntity)((Object)this.projectTeamService.getById(teamId));
            if (teamId == null) {
                return CommonResponse.error((String)"\u5f53\u524d\u73ed\u7ec4\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
            teamId = team.getParentId() == null ? null : teamId;
        }
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String salaryMonth = (String)((Map)JSONObject.parseObject((String)condition, Map.class)).get("salaryMonth");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (conditionMap.containsKey("salaryMonth")) {
                salaryMonth = (String)conditionMap.get("salaryMonth");
                param.getParams().put(" ", new Parameter("sql", (Object)("DATE_FORMAT( enter_date, '%Y-%m' )<= '" + salaryMonth + "' AND ( DATE_FORMAT( exit_date, '%Y-%m' )>= '" + salaryMonth + "' OR exit_date IS NULL)")));
            }
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter("eq", conditionMap.get("projectId")));
            } else {
                param.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (teamId != null) {
            param.getParams().put("team_id", new Parameter("like", (Object)teamId));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enter_date", ORDER_TYPE);
        orderMap.put("create_time", ORDER_TYPE);
        param.setOrderMap(orderMap);
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List recordVOS = BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        Date parseSalaryMonth = df.parse(salaryMonth);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parseSalaryMonth);
        int actualMaximum = calendar.getActualMaximum(5);
        Date dateEnter = sdf.parse(salaryMonth + "-1");
        Date dateExit = sdf.parse(salaryMonth + "-" + actualMaximum);
        for (WorkRecordVO vo : recordVOS) {
            Date _dateEnter = dateEnter;
            if (vo.getEnterDate().compareTo(dateEnter) > 0) {
                _dateEnter = vo.getEnterDate();
            }
            Date _dateExit = dateExit;
            if (vo.getExitDate() != null && vo.getExitDate().compareTo(dateExit) < 0) {
                _dateExit = vo.getExitDate();
            }
            vo.setCheckingDay(Integer.valueOf(this.attendanceService.totalAttendanceDays(_dateEnter, _dateExit, vo.getWorkerId(), vo.getProjectId())));
            vo.setCheckingDayFlag(Integer.valueOf(vo.getCheckingDay() > 0 ? 1 : 0));
        }
        pageData.setRecords(recordVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public List<ProjectRecordVO> queryProjectList(String startDate, String endDate) {
        return ((WorkRecordMapper)this.baseMapper).queryProjectList(startDate, endDate);
    }

    @Override
    public List<WorkRecordVO> queryZcList(Long projectId, String startDate, String endDate) {
        return ((WorkRecordMapper)this.baseMapper).queryZcList(projectId, startDate, endDate);
    }

    void updateAttachmentCheck(WorkRecordEntity entity) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s : typeList) {
            CommonResponse deleteFileByParam;
            CommonResponse idCardResponse = this.attachmentApi.queryListBySourceId(entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u8bbf\u95ee\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (!CollectionUtils.isNotEmpty((Collection)((Collection)idCardResponse.getData()))) continue;
            CommonResponse orgIdCardResponse = this.attachmentApi.queryListBySourceId(entity.getWorkerId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (!orgIdCardResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgIdCardResponse.getData())) && !(deleteFileByParam = this.attachmentApi.deleteFileByParam(entity.getWorkerId(), WORKER_BILL_TYPE, s)).isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u5220\u9664\u5931\u8d25");
            }
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(Long.toString(entity.getId()), RECORD_BILL_TYPE, s, Long.toString(entity.getWorkerId()), WORKER_BILL_TYPE, s);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u6587\u4ef6\u4e2d\u5fc3\u590d\u5236\u5931\u8d25");
            }
            CommonResponse orgIdCardNewResponse = this.attachmentApi.queryListBySourceId(entity.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (orgIdCardNewResponse.isSuccess()) continue;
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38 \u67e5\u8be2\u6587\u4ef6\u4e2d\u5fc3\u5f02\u5e38");
        }
    }
}

